"""
This type stub file was generated by pyright.
"""

from IPython.testing.skipdoctest import skip_doctest

"""Top-level display functions for displaying object in different formats."""
__all__ = ['display_pretty', 'display_html', 'display_markdown', 'display_svg', 'display_png', 'display_jpeg', 'display_latex', 'display_json', 'display_javascript', 'display_pdf', 'DisplayObject', 'TextDisplayObject', 'Pretty', 'HTML', 'Markdown', 'Math', 'Latex', 'SVG', 'ProgressBar', 'JSON', 'GeoJSON', 'Javascript', 'Image', 'set_matplotlib_formats', 'set_matplotlib_close', 'Video']
_deprecated_names = ...
__all__ = __all__ + _deprecated_names
def __getattr__(name):
    ...

def display_pretty(*objs, **kwargs) -> None:
    """Display the pretty (default) representation of an object.

    Parameters
    ----------
    *objs : object
        The Python objects to display, or if raw=True raw text data to
        display.
    raw : bool
        Are the data objects raw data or Python objects that need to be
        formatted before display? [default: False]
    metadata : dict (optional)
        Metadata to be associated with the specific mimetype output.
    """
    ...

def display_html(*objs, **kwargs) -> None:
    """Display the HTML representation of an object.

    Note: If raw=False and the object does not have a HTML
    representation, no HTML will be shown.

    Parameters
    ----------
    *objs : object
        The Python objects to display, or if raw=True raw HTML data to
        display.
    raw : bool
        Are the data objects raw data or Python objects that need to be
        formatted before display? [default: False]
    metadata : dict (optional)
        Metadata to be associated with the specific mimetype output.
    """
    ...

def display_markdown(*objs, **kwargs) -> None:
    """Displays the Markdown representation of an object.

    Parameters
    ----------
    *objs : object
        The Python objects to display, or if raw=True raw markdown data to
        display.
    raw : bool
        Are the data objects raw data or Python objects that need to be
        formatted before display? [default: False]
    metadata : dict (optional)
        Metadata to be associated with the specific mimetype output.
    """
    ...

def display_svg(*objs, **kwargs) -> None:
    """Display the SVG representation of an object.

    Parameters
    ----------
    *objs : object
        The Python objects to display, or if raw=True raw svg data to
        display.
    raw : bool
        Are the data objects raw data or Python objects that need to be
        formatted before display? [default: False]
    metadata : dict (optional)
        Metadata to be associated with the specific mimetype output.
    """
    ...

def display_png(*objs, **kwargs) -> None:
    """Display the PNG representation of an object.

    Parameters
    ----------
    *objs : object
        The Python objects to display, or if raw=True raw png data to
        display.
    raw : bool
        Are the data objects raw data or Python objects that need to be
        formatted before display? [default: False]
    metadata : dict (optional)
        Metadata to be associated with the specific mimetype output.
    """
    ...

def display_jpeg(*objs, **kwargs) -> None:
    """Display the JPEG representation of an object.

    Parameters
    ----------
    *objs : object
        The Python objects to display, or if raw=True raw JPEG data to
        display.
    raw : bool
        Are the data objects raw data or Python objects that need to be
        formatted before display? [default: False]
    metadata : dict (optional)
        Metadata to be associated with the specific mimetype output.
    """
    ...

def display_latex(*objs, **kwargs) -> None:
    """Display the LaTeX representation of an object.

    Parameters
    ----------
    *objs : object
        The Python objects to display, or if raw=True raw latex data to
        display.
    raw : bool
        Are the data objects raw data or Python objects that need to be
        formatted before display? [default: False]
    metadata : dict (optional)
        Metadata to be associated with the specific mimetype output.
    """
    ...

def display_json(*objs, **kwargs) -> None:
    """Display the JSON representation of an object.

    Note that not many frontends support displaying JSON.

    Parameters
    ----------
    *objs : object
        The Python objects to display, or if raw=True raw json data to
        display.
    raw : bool
        Are the data objects raw data or Python objects that need to be
        formatted before display? [default: False]
    metadata : dict (optional)
        Metadata to be associated with the specific mimetype output.
    """
    ...

def display_javascript(*objs, **kwargs) -> None:
    """Display the Javascript representation of an object.

    Parameters
    ----------
    *objs : object
        The Python objects to display, or if raw=True raw javascript data to
        display.
    raw : bool
        Are the data objects raw data or Python objects that need to be
        formatted before display? [default: False]
    metadata : dict (optional)
        Metadata to be associated with the specific mimetype output.
    """
    ...

def display_pdf(*objs, **kwargs) -> None:
    """Display the PDF representation of an object.

    Parameters
    ----------
    *objs : object
        The Python objects to display, or if raw=True raw javascript data to
        display.
    raw : bool
        Are the data objects raw data or Python objects that need to be
        formatted before display? [default: False]
    metadata : dict (optional)
        Metadata to be associated with the specific mimetype output.
    """
    ...

class DisplayObject:
    """An object that wraps data to be displayed."""
    _read_flags = ...
    _show_mem_addr = ...
    metadata = ...
    def __init__(self, data=..., url=..., filename=..., metadata=...) -> None:
        """Create a display object given raw data.

        When this object is returned by an expression or passed to the
        display function, it will result in the data being displayed
        in the frontend. The MIME type of the data should match the
        subclasses used, so the Png subclass should be used for 'image/png'
        data. If the data is a URL, the data will first be downloaded
        and then displayed. If

        Parameters
        ----------
        data : unicode, str or bytes
            The raw data or a URL or file to load the data from
        url : unicode
            A URL to download the data from.
        filename : unicode
            Path to a local file to load the data from.
        metadata : dict
            Dict of metadata associated to be the object when displayed
        """
        ...
    
    def __repr__(self):
        ...
    
    def reload(self): # -> None:
        """Reload the raw data from file or URL."""
        ...
    


class TextDisplayObject(DisplayObject):
    """Create a text display object given raw data.

    Parameters
    ----------
    data : str or unicode
        The raw data or a URL or file to load the data from.
    url : unicode
        A URL to download the data from.
    filename : unicode
        Path to a local file to load the data from.
    metadata : dict
        Dict of metadata associated to be the object when displayed
    """
    ...


class Pretty(TextDisplayObject):
    ...


class HTML(TextDisplayObject):
    def __init__(self, data=..., url=..., filename=..., metadata=...) -> None:
        ...
    
    def __html__(self): # -> None:
        """
        This method exists to inform other HTML-using modules (e.g. Markupsafe,
        htmltag, etc) that this object is HTML and does not need things like
        special characters (<>&) escaped.
        """
        ...
    


class Markdown(TextDisplayObject):
    ...


class Math(TextDisplayObject):
    ...


class Latex(TextDisplayObject):
    ...


class SVG(DisplayObject):
    """Embed an SVG into the display.

    Note if you just want to view a svg image via a URL use `:class:Image` with
    a url=URL keyword argument.
    """
    _read_flags = ...
    _data = ...
    @property
    def data(self): # -> None:
        ...
    
    @data.setter
    def data(self, svg): # -> None:
        ...
    


class ProgressBar(DisplayObject):
    """Progressbar supports displaying a progressbar like element
    """
    def __init__(self, total) -> None:
        """Creates a new progressbar

        Parameters
        ----------
        total : int
            maximum size of the progressbar
        """
        ...
    
    def __repr__(self):
        ...
    
    def display(self): # -> None:
        ...
    
    def update(self): # -> None:
        ...
    
    @property
    def progress(self):
        ...
    
    @progress.setter
    def progress(self, value): # -> None:
        ...
    
    def __iter__(self): # -> Self@ProgressBar:
        ...
    
    def __next__(self):
        """Returns current value and increments display by one."""
        ...
    


class JSON(DisplayObject):
    """JSON expects a JSON-able dict or list

    not an already-serialized JSON string.

    Scalar types (None, number, string) are not allowed, only dict or list containers.
    """
    _data = ...
    def __init__(self, data=..., url=..., filename=..., expanded=..., metadata=..., root=..., **kwargs) -> None:
        """Create a JSON display object given raw data.

        Parameters
        ----------
        data : dict or list
            JSON data to display. Not an already-serialized JSON string.
            Scalar types (None, number, string) are not allowed, only dict
            or list containers.
        url : unicode
            A URL to download the data from.
        filename : unicode
            Path to a local file to load the data from.
        expanded : boolean
            Metadata to control whether a JSON display component is expanded.
        metadata : dict
            Specify extra metadata to attach to the json display object.
        root : str
            The name of the root element of the JSON tree
        """
        ...
    
    @property
    def data(self): # -> None:
        ...
    
    @data.setter
    def data(self, data): # -> None:
        ...
    


_css_t = ...
_lib_t1 = ...
_lib_t2 = ...
class GeoJSON(JSON):
    """GeoJSON expects JSON-able dict

    not an already-serialized JSON string.

    Scalar types (None, number, string) are not allowed, only dict containers.
    """
    def __init__(self, *args, **kwargs) -> None:
        """Create a GeoJSON display object given raw data.

        Parameters
        ----------
        data : dict or list
            VegaLite data. Not an already-serialized JSON string.
            Scalar types (None, number, string) are not allowed, only dict
            or list containers.
        url_template : string
            Leaflet TileLayer URL template: http://leafletjs.com/reference.html#url-template
        layer_options : dict
            Leaflet TileLayer options: http://leafletjs.com/reference.html#tilelayer-options
        url : unicode
            A URL to download the data from.
        filename : unicode
            Path to a local file to load the data from.
        metadata : dict
            Specify extra metadata to attach to the json display object.

        Examples
        --------
        The following will display an interactive map of Mars with a point of
        interest on frontend that do support GeoJSON display.

            >>> from IPython.display import GeoJSON

            >>> GeoJSON(data={
            ...     "type": "Feature",
            ...     "geometry": {
            ...         "type": "Point",
            ...         "coordinates": [-81.327, 296.038]
            ...     }
            ... },
            ... url_template="http://s3-eu-west-1.amazonaws.com/whereonmars.cartodb.net/{basemap_id}/{z}/{x}/{y}.png",
            ... layer_options={
            ...     "basemap_id": "celestia_mars-shaded-16k_global",
            ...     "attribution" : "Celestia/praesepe",
            ...     "minZoom" : 0,
            ...     "maxZoom" : 18,
            ... })
            <IPython.core.display.GeoJSON object>

        In the terminal IPython, you will only see the text representation of
        the GeoJSON object.

        """
        ...
    


class Javascript(TextDisplayObject):
    def __init__(self, data=..., url=..., filename=..., lib=..., css=...) -> None:
        """Create a Javascript display object given raw data.

        When this object is returned by an expression or passed to the
        display function, it will result in the data being displayed
        in the frontend. If the data is a URL, the data will first be
        downloaded and then displayed.

        In the Notebook, the containing element will be available as `element`,
        and jQuery will be available.  Content appended to `element` will be
        visible in the output area.

        Parameters
        ----------
        data : unicode, str or bytes
            The Javascript source code or a URL to download it from.
        url : unicode
            A URL to download the data from.
        filename : unicode
            Path to a local file to load the data from.
        lib : list or str
            A sequence of Javascript library URLs to load asynchronously before
            running the source code. The full URLs of the libraries should
            be given. A single Javascript library URL can also be given as a
            string.
        css : list or str
            A sequence of css files to load before running the source code.
            The full URLs of the css files should be given. A single css URL
            can also be given as a string.
        """
        ...
    


_PNG = ...
_JPEG = ...
class Image(DisplayObject):
    _read_flags = ...
    _FMT_JPEG = ...
    _FMT_PNG = ...
    _FMT_GIF = ...
    _ACCEPTABLE_EMBEDDINGS = ...
    _MIMETYPES = ...
    def __init__(self, data=..., url=..., filename=..., format=..., embed=..., width=..., height=..., retina=..., unconfined=..., metadata=..., alt=...) -> None:
        """Create a PNG/JPEG/GIF image object given raw data.

        When this object is returned by an input cell or passed to the
        display function, it will result in the image being displayed
        in the frontend.

        Parameters
        ----------
        data : unicode, str or bytes
            The raw image data or a URL or filename to load the data from.
            This always results in embedded image data.

        url : unicode
            A URL to download the data from. If you specify `url=`,
            the image data will not be embedded unless you also specify `embed=True`.

        filename : unicode
            Path to a local file to load the data from.
            Images from a file are always embedded.

        format : unicode
            The format of the image data (png/jpeg/jpg/gif). If a filename or URL is given
            for format will be inferred from the filename extension.

        embed : bool
            Should the image data be embedded using a data URI (True) or be
            loaded using an <img> tag. Set this to True if you want the image
            to be viewable later with no internet connection in the notebook.

            Default is `True`, unless the keyword argument `url` is set, then
            default value is `False`.

            Note that QtConsole is not able to display images if `embed` is set to `False`

        width : int
            Width in pixels to which to constrain the image in html

        height : int
            Height in pixels to which to constrain the image in html

        retina : bool
            Automatically set the width and height to half of the measured
            width and height.
            This only works for embedded images because it reads the width/height
            from image data.
            For non-embedded images, you can just set the desired display width
            and height directly.

        unconfined : bool
            Set unconfined=True to disable max-width confinement of the image.

        metadata : dict
            Specify extra metadata to attach to the image.

        alt : unicode
            Alternative text for the image, for use by screen readers.

        Examples
        --------
        embedded image data, works in qtconsole and notebook
        when passed positionally, the first arg can be any of raw image data,
        a URL, or a filename from which to load image data.
        The result is always embedding image data for inline images.

        >>> Image('https://www.google.fr/images/srpr/logo3w.png') # doctest: +SKIP
        <IPython.core.display.Image object>

        >>> Image('/path/to/image.jpg')
        <IPython.core.display.Image object>

        >>> Image(b'RAW_PNG_DATA...')
        <IPython.core.display.Image object>

        Specifying Image(url=...) does not embed the image data,
        it only generates ``<img>`` tag with a link to the source.
        This will not work in the qtconsole or offline.

        >>> Image(url='https://www.google.fr/images/srpr/logo3w.png')
        <IPython.core.display.Image object>

        """
        ...
    
    def reload(self): # -> None:
        """Reload the raw data from file or URL."""
        ...
    


class Video(DisplayObject):
    def __init__(self, data=..., url=..., filename=..., embed=..., mimetype=..., width=..., height=..., html_attributes=...) -> None:
        """Create a video object given raw data or an URL.

        When this object is returned by an input cell or passed to the
        display function, it will result in the video being displayed
        in the frontend.

        Parameters
        ----------
        data : unicode, str or bytes
            The raw video data or a URL or filename to load the data from.
            Raw data will require passing ``embed=True``.

        url : unicode
            A URL for the video. If you specify ``url=``,
            the image data will not be embedded.

        filename : unicode
            Path to a local file containing the video.
            Will be interpreted as a local URL unless ``embed=True``.

        embed : bool
            Should the video be embedded using a data URI (True) or be
            loaded using a <video> tag (False).

            Since videos are large, embedding them should be avoided, if possible.
            You must confirm embedding as your intention by passing ``embed=True``.

            Local files can be displayed with URLs without embedding the content, via::

                Video('./video.mp4')

        mimetype : unicode
            Specify the mimetype for embedded videos.
            Default will be guessed from file extension, if available.

        width : int
            Width in pixels to which to constrain the video in HTML.
            If not supplied, defaults to the width of the video.

        height : int
            Height in pixels to which to constrain the video in html.
            If not supplied, defaults to the height of the video.

        html_attributes : str
            Attributes for the HTML ``<video>`` block.
            Default: ``"controls"`` to get video controls.
            Other examples: ``"controls muted"`` for muted video with controls,
            ``"loop autoplay"`` for looping autoplaying video without controls.

        Examples
        --------
        ::

            Video('https://archive.org/download/Sita_Sings_the_Blues/Sita_Sings_the_Blues_small.mp4')
            Video('path/to/video.mp4')
            Video('path/to/video.mp4', embed=True)
            Video('path/to/video.mp4', embed=True, html_attributes="controls muted autoplay")
            Video(b'raw-videodata', embed=True)
        """
        ...
    
    def reload(self): # -> None:
        ...
    


@skip_doctest
def set_matplotlib_formats(*formats, **kwargs): # -> None:
    """
    .. deprecated:: 7.23

       use `matplotlib_inline.backend_inline.set_matplotlib_formats()`

    Select figure formats for the inline backend. Optionally pass quality for JPEG.

    For example, this enables PNG and JPEG output with a JPEG quality of 90%::

        In [1]: set_matplotlib_formats('png', 'jpeg', quality=90)

    To set this in your config files use the following::

        c.InlineBackend.figure_formats = {'png', 'jpeg'}
        c.InlineBackend.print_figure_kwargs.update({'quality' : 90})

    Parameters
    ----------
    *formats : strs
        One or more figure formats to enable: 'png', 'retina', 'jpeg', 'svg', 'pdf'.
    **kwargs
        Keyword args will be relayed to ``figure.canvas.print_figure``.
    """
    ...

@skip_doctest
def set_matplotlib_close(close=...): # -> None:
    """
    .. deprecated:: 7.23

        use `matplotlib_inline.backend_inline.set_matplotlib_close()`

    Set whether the inline backend closes all figures automatically or not.

    By default, the inline backend used in the IPython Notebook will close all
    matplotlib figures automatically after each cell is run. This means that
    plots in different cells won't interfere. Sometimes, you may want to make
    a plot in one cell and then refine it in later cells. This can be accomplished
    by::

        In [1]: set_matplotlib_close(False)

    To set this in your config files use the following::

        c.InlineBackend.close_figures = False

    Parameters
    ----------
    close : bool
        Should all matplotlib figures be automatically closed after each cell is
        run?
    """
    ...

