"""
This type stub file was generated by pyright.
"""

import abc
from decorator import decorator
from traitlets.config.configurable import Configurable
from ..lib import pretty
from traitlets import Integer
from typing import Any

"""Display formatters.

Inheritance diagram:

.. inheritance-diagram:: IPython.core.formatters
   :parts: 3
"""
class DisplayFormatter(Configurable):
    active_types = ...
    ipython_display_formatter = ...
    mimebundle_formatter = ...
    formatters = ...
    def format(self, obj, include=..., exclude=...):
        """Return a format data dict for an object.

        By default all format types will be computed.

        The following MIME types are usually implemented:

        * text/plain
        * text/html
        * text/markdown
        * text/latex
        * application/json
        * application/javascript
        * application/pdf
        * image/png
        * image/jpeg
        * image/svg+xml

        Parameters
        ----------
        obj : object
            The Python object whose format data will be computed.
        include : list, tuple or set; optional
            A list of format type strings (MIME types) to include in the
            format data dict. If this is set *only* the format types included
            in this list will be computed.
        exclude : list, tuple or set; optional
            A list of format type string (MIME types) to exclude in the format
            data dict. If this is set all format types will be computed,
            except for those included in this argument.
            Mimetypes present in exclude will take precedence over the ones in include

        Returns
        -------
        (format_dict, metadata_dict) : tuple of two dicts
            format_dict is a dictionary of key/value pairs, one of each format that was
            generated for the object. The keys are the format types, which
            will usually be MIME type strings and the values and JSON'able
            data structure containing the raw data for the representation in
            that format.

            metadata_dict is a dictionary of metadata about each mime-type output.
            Its keys will be a strict subset of the keys in format_dict.

        Notes
        -----
            If an object implement `_repr_mimebundle_` as well as various
            `_repr_*_`, the data returned by `_repr_mimebundle_` will take
            precedence and the corresponding `_repr_*_` for this mimetype will
            not be called.

        """
        ...
    
    @property
    def format_types(self):
        """Return the format types (MIME types) of the active formatters."""
        ...
    


class FormatterWarning(UserWarning):
    """Warning class for errors in formatters"""
    ...


@decorator
def catch_format_error(method, self, *args, **kwargs):
    """show traceback on failed format call"""
    ...

class FormatterABC(metaclass=abc.ABCMeta):
    """ Abstract base class for Formatters.

    A formatter is a callable class that is responsible for computing the
    raw format data for a particular format type (MIME type). For example,
    an HTML formatter would have a format type of `text/html` and would return
    the HTML representation of the object when called.
    """
    format_type = ...
    enabled = ...
    @abc.abstractmethod
    def __call__(self, obj):
        """Return a JSON'able representation of the object.

        If the object cannot be formatted by this formatter,
        warn and return None.
        """
        ...
    


_raise_key_error = ...
class BaseFormatter(Configurable):
    """A base formatter class that is configurable.

    This formatter should usually be used as the base class of all formatters.
    It is a traited :class:`Configurable` class and includes an extensible
    API for users to determine how their objects are formatted. The following
    logic is used to find a function to format an given object.

    1. The object is introspected to see if it has a method with the name
       :attr:`print_method`. If is does, that object is passed to that method
       for formatting.
    2. If no print method is found, three internal dictionaries are consulted
       to find print method: :attr:`singleton_printers`, :attr:`type_printers`
       and :attr:`deferred_printers`.

    Users should use these dictionaries to register functions that will be
    used to compute the format data for their objects (if those objects don't
    have the special print methods). The easiest way of using these
    dictionaries is through the :meth:`for_type` and :meth:`for_type_by_name`
    methods.

    If no function/callable is found to compute the format data, ``None`` is
    returned and this format type is not used.
    """
    format_type = ...
    _return_type: Any = ...
    enabled = ...
    print_method = ...
    singleton_printers = ...
    type_printers = ...
    deferred_printers = ...
    @catch_format_error
    def __call__(self, obj): # -> None:
        """Compute the format for an object."""
        ...
    
    def __contains__(self, typ):
        """map in to lookup_by_type"""
        ...
    
    def lookup(self, obj):
        """Look up the formatter for a given instance.

        Parameters
        ----------
        obj : object instance

        Returns
        -------
        f : callable
            The registered formatting callable for the type.

        Raises
        ------
        KeyError if the type has not been registered.
        """
        ...
    
    def lookup_by_type(self, typ):
        """Look up the registered formatter for a type.

        Parameters
        ----------
        typ : type or '__module__.__name__' string for a type

        Returns
        -------
        f : callable
            The registered formatting callable for the type.

        Raises
        ------
        KeyError if the type has not been registered.
        """
        ...
    
    def for_type(self, typ, func=...): # -> None:
        """Add a format function for a given type.

        Parameters
        ----------
        typ : type or '__module__.__name__' string for a type
            The class of the object that will be formatted using `func`.

        func : callable
            A callable for computing the format data.
            `func` will be called with the object to be formatted,
            and will return the raw data in this formatter's format.
            Subclasses may use a different call signature for the
            `func` argument.

            If `func` is None or not specified, there will be no change,
            only returning the current value.

        Returns
        -------
        oldfunc : callable
            The currently registered callable.
            If you are registering a new formatter,
            this will be the previous value (to enable restoring later).
        """
        ...
    
    def for_type_by_name(self, type_module, type_name, func=...): # -> None:
        """Add a format function for a type specified by the full dotted
        module and name of the type, rather than the type of the object.

        Parameters
        ----------
        type_module : str
            The full dotted name of the module the type is defined in, like
            ``numpy``.

        type_name : str
            The name of the type (the class name), like ``dtype``

        func : callable
            A callable for computing the format data.
            `func` will be called with the object to be formatted,
            and will return the raw data in this formatter's format.
            Subclasses may use a different call signature for the
            `func` argument.

            If `func` is None or unspecified, there will be no change,
            only returning the current value.

        Returns
        -------
        oldfunc : callable
            The currently registered callable.
            If you are registering a new formatter,
            this will be the previous value (to enable restoring later).
        """
        ...
    
    def pop(self, typ, default=...): # -> Sentinel:
        """Pop a formatter for the given type.

        Parameters
        ----------
        typ : type or '__module__.__name__' string for a type
        default : object
            value to be returned if no formatter is registered for typ.

        Returns
        -------
        obj : object
            The last registered object for the type.

        Raises
        ------
        KeyError if the type is not registered and default is not specified.
        """
        ...
    


class PlainTextFormatter(BaseFormatter):
    """The default pretty-printer.

    This uses :mod:`IPython.lib.pretty` to compute the format data of
    the object. If the object cannot be pretty printed, :func:`repr` is used.
    See the documentation of :mod:`IPython.lib.pretty` for details on
    how to write pretty printers.  Here is a simple example::

        def dtype_pprinter(obj, p, cycle):
            if cycle:
                return p.text('dtype(...)')
            if hasattr(obj, 'fields'):
                if obj.fields is None:
                    p.text(repr(obj))
                else:
                    p.begin_group(7, 'dtype([')
                    for i, field in enumerate(obj.descr):
                        if i > 0:
                            p.text(',')
                            p.breakable()
                        p.pretty(field)
                    p.end_group(7, '])')
    """
    format_type = ...
    enabled = ...
    max_seq_length = Integer(pretty.MAX_SEQ_LENGTH, help="""Truncate large collections (lists, dicts, tuples, sets) to this size.
        
        Set to 0 to disable truncation.
        """).tag(config=True)
    print_method = ...
    pprint = ...
    verbose = ...
    max_width = Integer(79).tag(config=True)
    newline = ...
    float_format = ...
    float_precision = ...
    @catch_format_error
    def __call__(self, obj):
        """Compute the pretty representation of the object."""
        ...
    


class HTMLFormatter(BaseFormatter):
    """An HTML formatter.

    To define the callables that compute the HTML representation of your
    objects, define a :meth:`_repr_html_` method or use the :meth:`for_type`
    or :meth:`for_type_by_name` methods to register functions that handle
    this.

    The return value of this formatter should be a valid HTML snippet that
    could be injected into an existing DOM. It should *not* include the
    ```<html>`` or ```<body>`` tags.
    """
    format_type = ...
    print_method = ...


class MarkdownFormatter(BaseFormatter):
    """A Markdown formatter.

    To define the callables that compute the Markdown representation of your
    objects, define a :meth:`_repr_markdown_` method or use the :meth:`for_type`
    or :meth:`for_type_by_name` methods to register functions that handle
    this.

    The return value of this formatter should be a valid Markdown.
    """
    format_type = ...
    print_method = ...


class SVGFormatter(BaseFormatter):
    """An SVG formatter.

    To define the callables that compute the SVG representation of your
    objects, define a :meth:`_repr_svg_` method or use the :meth:`for_type`
    or :meth:`for_type_by_name` methods to register functions that handle
    this.

    The return value of this formatter should be valid SVG enclosed in
    ```<svg>``` tags, that could be injected into an existing DOM. It should
    *not* include the ```<html>`` or ```<body>`` tags.
    """
    format_type = ...
    print_method = ...


class PNGFormatter(BaseFormatter):
    """A PNG formatter.

    To define the callables that compute the PNG representation of your
    objects, define a :meth:`_repr_png_` method or use the :meth:`for_type`
    or :meth:`for_type_by_name` methods to register functions that handle
    this.

    The return value of this formatter should be raw PNG data, *not*
    base64 encoded.
    """
    format_type = ...
    print_method = ...
    _return_type = ...


class JPEGFormatter(BaseFormatter):
    """A JPEG formatter.

    To define the callables that compute the JPEG representation of your
    objects, define a :meth:`_repr_jpeg_` method or use the :meth:`for_type`
    or :meth:`for_type_by_name` methods to register functions that handle
    this.

    The return value of this formatter should be raw JPEG data, *not*
    base64 encoded.
    """
    format_type = ...
    print_method = ...
    _return_type = ...


class LatexFormatter(BaseFormatter):
    """A LaTeX formatter.

    To define the callables that compute the LaTeX representation of your
    objects, define a :meth:`_repr_latex_` method or use the :meth:`for_type`
    or :meth:`for_type_by_name` methods to register functions that handle
    this.

    The return value of this formatter should be a valid LaTeX equation,
    enclosed in either ```$```, ```$$``` or another LaTeX equation
    environment.
    """
    format_type = ...
    print_method = ...


class JSONFormatter(BaseFormatter):
    """A JSON string formatter.

    To define the callables that compute the JSONable representation of
    your objects, define a :meth:`_repr_json_` method or use the :meth:`for_type`
    or :meth:`for_type_by_name` methods to register functions that handle
    this.

    The return value of this formatter should be a JSONable list or dict.
    JSON scalars (None, number, string) are not allowed, only dict or list containers.
    """
    format_type = ...
    _return_type = ...
    print_method = ...


class JavascriptFormatter(BaseFormatter):
    """A Javascript formatter.

    To define the callables that compute the Javascript representation of
    your objects, define a :meth:`_repr_javascript_` method or use the
    :meth:`for_type` or :meth:`for_type_by_name` methods to register functions
    that handle this.

    The return value of this formatter should be valid Javascript code and
    should *not* be enclosed in ```<script>``` tags.
    """
    format_type = ...
    print_method = ...


class PDFFormatter(BaseFormatter):
    """A PDF formatter.

    To define the callables that compute the PDF representation of your
    objects, define a :meth:`_repr_pdf_` method or use the :meth:`for_type`
    or :meth:`for_type_by_name` methods to register functions that handle
    this.

    The return value of this formatter should be raw PDF data, *not*
    base64 encoded.
    """
    format_type = ...
    print_method = ...
    _return_type = ...


class IPythonDisplayFormatter(BaseFormatter):
    """An escape-hatch Formatter for objects that know how to display themselves.
    
    To define the callables that compute the representation of your
    objects, define a :meth:`_ipython_display_` method or use the :meth:`for_type`
    or :meth:`for_type_by_name` methods to register functions that handle
    this. Unlike mime-type displays, this method should not return anything,
    instead calling any appropriate display methods itself.
    
    This display formatter has highest priority.
    If it fires, no other display formatter will be called.

    Prior to IPython 6.1, `_ipython_display_` was the only way to display custom mime-types
    without registering a new Formatter.
    
    IPython 6.1 introduces `_repr_mimebundle_` for displaying custom mime-types,
    so `_ipython_display_` should only be used for objects that require unusual
    display patterns, such as multiple display calls.
    """
    print_method = ...
    _return_type = ...
    @catch_format_error
    def __call__(self, obj): # -> None:
        """Compute the format for an object."""
        ...
    


class MimeBundleFormatter(BaseFormatter):
    """A Formatter for arbitrary mime-types.

    Unlike other `_repr_<mimetype>_` methods,
    `_repr_mimebundle_` should return mime-bundle data,
    either the mime-keyed `data` dictionary or the tuple `(data, metadata)`.
    Any mime-type is valid.

    To define the callables that compute the mime-bundle representation of your
    objects, define a :meth:`_repr_mimebundle_` method or use the :meth:`for_type`
    or :meth:`for_type_by_name` methods to register functions that handle
    this.

    .. versionadded:: 6.1
    """
    print_method = ...
    _return_type = ...
    @catch_format_error
    def __call__(self, obj, include=..., exclude=...): # -> None:
        """Compute the format for an object.

        Identical to parent's method but we pass extra parameters to the method.

        Unlike other _repr_*_ `_repr_mimebundle_` should allow extra kwargs, in
        particular `include` and `exclude`.
        """
        ...
    


def format_display_data(obj, include=..., exclude=...):
    """Return a format data dict for an object.

    By default all format types will be computed.

    Parameters
    ----------
    obj : object
        The Python object whose format data will be computed.

    Returns
    -------
    format_dict : dict
        A dictionary of key/value pairs, one or each format that was
        generated for the object. The keys are the format types, which
        will usually be MIME type strings and the values and JSON'able
        data structure containing the raw data for the representation in
        that format.
    include : list or tuple, optional
        A list of format type strings (MIME types) to include in the
        format data dict. If this is set *only* the format types included
        in this list will be computed.
    exclude : list or tuple, optional
        A list of format type string (MIME types) to exclude in the format
        data dict. If this is set all format types will be computed,
        except for those included in this argument.
    """
    ...

