"""
This type stub file was generated by pyright.
"""

import unittest

"""Decorators for labeling test objects.

Decorators that merely return a modified version of the original function
object are straightforward.  Decorators that return a new function object need
to use nose.tools.make_decorator(original_function)(decorator) in returning the
decorator, in order to preserve metadata such as function name, setup and
teardown functions and so on - see nose.tools for more information.

This module provides a set of useful decorators meant to be ready to use in
your own tests.  See the bottom of the file for the ready-made ones, and if you
find yourself writing a new one that may be of generic use, add it here.

Included decorators:


Lightweight testing that remains unittest-compatible.

- An @as_unittest decorator can be used to tag any normal parameter-less
  function as a unittest TestCase.  Then, both nose and normal unittest will
  recognize it as such.  This will make it easier to migrate away from Nose if
  we ever need/want to while maintaining very lightweight tests.

NOTE: This file contains IPython-specific decorators. Using the machinery in
IPython.external.decorators, we import either numpy.testing.decorators if numpy is
available, OR use equivalent code in IPython.external._decorators, which
we've copied verbatim from numpy.

"""
def as_unittest(func): # -> Type[Tester]:
    """Decorator to make a simple function into a normal test via unittest."""
    class Tester(unittest.TestCase):
        ...
    
    

def skipif(skip_condition, msg=...): # -> MarkDecorator:
    """Make function raise SkipTest exception if skip_condition is true

    Parameters
    ----------

    skip_condition : bool or callable
      Flag to determine whether to skip test. If the condition is a
      callable, it is used at runtime to dynamically make the decision. This
      is useful for tests that may require costly imports, to delay the cost
      until the test suite is actually executed.
    msg : string
      Message to give on raising a SkipTest exception.

    Returns
    -------
    decorator : function
      Decorator, which, when applied to a function, causes SkipTest
      to be raised when the skip_condition was True, and the function
      to be called normally otherwise.
    """
    ...

def skip(msg=...): # -> MarkDecorator:
    """Decorator factory - mark a test function for skipping from test suite.

    Parameters
    ----------
      msg : string
        Optional message to be added.

    Returns
    -------
       decorator : function
         Decorator, which, when applied to a function, causes SkipTest
         to be raised, with the optional message added.
      """
    ...

def onlyif(condition, msg): # -> MarkDecorator:
    """The reverse from skipif, see skipif for details."""
    ...

def module_not_available(module):
    """Can module be imported?  Returns true if module does NOT import.

    This is used to make a decorator to skip tests that require module to be
    available, but delay the 'import numpy' to test execution time.
    """
    ...

skip_win32 = ...
skip_linux = ...
skip_osx = ...
skip_if_not_win32 = ...
skip_if_not_linux = ...
_x11_skip_cond = ...
_x11_skip_msg = ...
skip_if_no_x11 = ...
skip_without = ...
skipif_not_numpy = ...
skipif_not_matplotlib = ...
null_deco = ...
f = ...
onlyif_unicode_paths = ...
def onlyif_cmds_exist(*commands): # -> MarkDecorator | ((f: Unknown) -> Unknown):
    """
    Decorator to skip test when at least one of `commands` is not found.
    """
    ...

