"""
This type stub file was generated by pyright.
"""

"""IO capturing utilities."""
class RichOutput:
    def __init__(self, data=..., metadata=..., transient=..., update=...) -> None:
        ...
    
    def display(self): # -> None:
        ...
    


class CapturedIO:
    """Simple object for containing captured stdout/err and rich display StringIO objects

    Each instance `c` has three attributes:

    - ``c.stdout`` : standard output as a string
    - ``c.stderr`` : standard error as a string
    - ``c.outputs``: a list of rich display outputs

    Additionally, there's a ``c.show()`` method which will print all of the
    above in the same order, and can be invoked simply via ``c()``.
    """
    def __init__(self, stdout, stderr, outputs=...) -> None:
        ...
    
    def __str__(self) -> str:
        ...
    
    @property
    def stdout(self):
        "Captured standard output"
        ...
    
    @property
    def stderr(self):
        "Captured standard error"
        ...
    
    @property
    def outputs(self):
        """A list of the captured rich display outputs, if any.

        If you have a CapturedIO object ``c``, these can be displayed in IPython
        using::

            from IPython.display import display
            for o in c.outputs:
                display(o)
        """
        ...
    
    def show(self): # -> None:
        """write my output to sys.stdout/err as appropriate"""
        ...
    
    __call__ = ...


class capture_output:
    """context manager for capturing stdout/err"""
    stdout = ...
    stderr = ...
    display = ...
    def __init__(self, stdout=..., stderr=..., display=...) -> None:
        ...
    
    def __enter__(self): # -> CapturedIO:
        ...
    
    def __exit__(self, exc_type, exc_value, traceback): # -> None:
        ...
    


