"""
This type stub file was generated by pyright.
"""

from typing import Sequence

"""Decorators that don't go anywhere else.

This module contains misc. decorators that don't really go with another module
in :mod:`IPython.utils`. Before putting something here please see if it should
go into another topical module in :mod:`IPython.utils`.
"""
def flag_calls(func): # -> (*args: Unknown, **kw: Unknown) -> Unknown:
    """Wrap a function to detect and flag when it gets called.

    This is a decorator which takes a function and wraps it in a function with
    a 'called' attribute. wrapper.called is initialized to False.

    The wrapper.called attribute is set to False right before each call to the
    wrapped function, so if the call fails it remains False.  After the call
    completes, wrapper.called is set to True and the output is returned.

    Testing for truth in wrapper.called allows you to determine if a call to
    func() was attempted and succeeded."""
    ...

def undoc(func):
    """Mark a function or class as undocumented.

    This is found by inspecting the AST, so for now it must be used directly
    as @undoc, not as e.g. @decorators.undoc
    """
    ...

def sphinx_options(show_inheritance: bool = ..., show_inherited_members: bool = ..., exclude_inherited_from: Sequence[str] = ...): # -> (func: Unknown) -> Unknown:
    """Set sphinx options"""
    ...

