"""
This type stub file was generated by pyright.
"""

"""
Utilities for working with stack frames.
"""
def extract_vars(*names, **kw):
    """Extract a set of variables by name from another frame.

    Parameters
    ----------
    *names : str
        One or more variable names which will be extracted from the caller's
        frame.
    **kw : integer, optional
        How many frames in the stack to walk when looking for your variables.
        The default is 0, which will use the frame where the call was made.

    Examples
    --------
    ::

        In [2]: def func(x):
           ...:     y = 1
           ...:     print(sorted(extract_vars('x','y').items()))
           ...:

        In [3]: func('hello')
        [('x', 'hello'), ('y', 1)]
    """
    ...

def extract_vars_above(*names):
    """Extract a set of variables by name from another frame.

    Similar to extractVars(), but with a specified depth of 1, so that names
    are extracted exactly from above the caller.

    This is simply a convenience function so that the very common case (for us)
    of skipping exactly 1 frame doesn't have to construct a special dict for
    keyword passing."""
    ...

def debugx(expr, pre_msg=...): # -> None:
    """Print the value of an expression from the caller's frame.

    Takes an expression, evaluates it in the caller's frame and prints both
    the given expression and the resulting value (as well as a debug mark
    indicating the name of the calling function.  The input must be of a form
    suitable for eval().

    An optional message can be passed, which will be prepended to the printed
    expr->value pair."""
    ...

def extract_module_locals(depth=...):
    """Returns (module, locals) of the function `depth` frames away from the caller"""
    ...

