from typing import Any, TypeVar
from typing_extensions import Literal

from django.db import models
from django.db.models.base import Model
from django.db.models.fields import BooleanField

_T = TypeVar("_T")
_ModelT = TypeVar("_ModelT", bound=Model)

class BaseUserManager(models.Manager[_ModelT]):
    @classmethod
    def normalize_email(cls, email: str | None) -> str: ...
    def make_random_password(
        self, length: int = ..., allowed_chars: str = ...
    ) -> str: ...
    def get_by_natural_key(self, username: str) -> _ModelT: ...

class AbstractBaseUser(models.Model):
    REQUIRED_FIELDS: list[str] = ...

    password = models.CharField(max_length=128)
    last_login = models.DateTimeField(blank=True, null=True)
    is_active: bool | BooleanField[Any] = ...
    def get_username(self) -> str: ...
    def natural_key(self) -> tuple[str]: ...
    @property
    def is_anonymous(self) -> Literal[False]: ...
    @property
    def is_authenticated(self) -> Literal[True]: ...
    def set_password(self, raw_password: str | None) -> None: ...
    def check_password(self, raw_password: str) -> bool: ...
    def set_unusable_password(self) -> None: ...
    def has_usable_password(self) -> bool: ...
    def get_session_auth_hash(self) -> str: ...
    @classmethod
    def get_email_field_name(cls) -> str: ...
    @classmethod
    def normalize_username(cls, username: _T) -> _T: ...
