from typing import Any

from django.contrib.gis.gdal.base import GDALBase as GDALBase

class OGRGeometry(GDALBase):
    destructor: Any = ...
    ptr: Any = ...
    srs: Any = ...
    __class__: Any = ...
    def __init__(self, geom_input: Any, srs: Any | None = ...) -> None: ...
    @classmethod
    def from_bbox(cls, bbox: Any) -> Any: ...
    @staticmethod
    def from_json(geom_input: Any) -> Any: ...
    @classmethod
    def from_gml(cls, gml_string: Any) -> Any: ...
    def __or__(self, other: Any) -> Any: ...
    def __and__(self, other: Any) -> Any: ...
    def __sub__(self, other: Any) -> Any: ...
    def __xor__(self, other: Any) -> Any: ...
    def __eq__(self, other: object) -> Any: ...
    @property
    def dimension(self) -> Any: ...
    coord_dim: Any = ...
    @property
    def geom_count(self) -> Any: ...
    @property
    def point_count(self) -> Any: ...
    @property
    def num_points(self) -> Any: ...
    @property
    def num_coords(self) -> Any: ...
    @property
    def geom_type(self) -> Any: ...
    @property
    def geom_name(self) -> Any: ...
    @property
    def area(self) -> Any: ...
    @property
    def envelope(self) -> Any: ...
    @property
    def empty(self) -> Any: ...
    @property
    def extent(self) -> Any: ...
    srid: Any = ...
    @property
    def geos(self) -> Any: ...
    @property
    def gml(self) -> Any: ...
    @property
    def hex(self) -> Any: ...
    @property
    def json(self) -> Any: ...
    geojson: Any = ...
    @property
    def kml(self) -> Any: ...
    @property
    def wkb_size(self) -> Any: ...
    @property
    def wkb(self) -> Any: ...
    @property
    def wkt(self) -> Any: ...
    @property
    def ewkt(self) -> Any: ...
    def clone(self) -> Any: ...
    def close_rings(self) -> None: ...
    def transform(self, coord_trans: Any, clone: bool = ...) -> Any: ...
    def intersects(self, other: Any) -> Any: ...
    def equals(self, other: Any) -> Any: ...
    def disjoint(self, other: Any) -> Any: ...
    def touches(self, other: Any) -> Any: ...
    def crosses(self, other: Any) -> Any: ...
    def within(self, other: Any) -> Any: ...
    def contains(self, other: Any) -> Any: ...
    def overlaps(self, other: Any) -> Any: ...
    @property
    def boundary(self) -> Any: ...
    @property
    def convex_hull(self) -> Any: ...
    def difference(self, other: Any) -> Any: ...
    def intersection(self, other: Any) -> Any: ...
    def sym_difference(self, other: Any) -> Any: ...
    def union(self, other: Any) -> Any: ...

class Point(OGRGeometry):
    @property
    def x(self) -> Any: ...
    @property
    def y(self) -> Any: ...
    @property
    def z(self) -> Any: ...
    @property
    def tuple(self) -> Any: ...
    coords: Any = ...

class LineString(OGRGeometry):
    def __getitem__(self, index: Any) -> Any: ...
    def __len__(self) -> Any: ...
    @property
    def tuple(self) -> Any: ...
    coords: Any = ...
    @property
    def x(self) -> Any: ...
    @property
    def y(self) -> Any: ...
    @property
    def z(self) -> Any: ...

class LinearRing(LineString): ...

class Polygon(OGRGeometry):
    def __len__(self) -> Any: ...
    def __getitem__(self, index: Any) -> Any: ...
    @property
    def shell(self) -> Any: ...
    exterior_ring: Any = ...
    @property
    def tuple(self) -> Any: ...
    coords: Any = ...
    @property
    def point_count(self) -> Any: ...
    @property
    def centroid(self) -> Any: ...

class GeometryCollection(OGRGeometry):
    def __getitem__(self, index: Any) -> Any: ...
    def __len__(self) -> Any: ...
    def add(self, geom: Any) -> None: ...
    @property
    def point_count(self) -> Any: ...
    @property
    def tuple(self) -> Any: ...
    coords: Any = ...

class MultiPoint(GeometryCollection): ...
class MultiLineString(GeometryCollection): ...
class MultiPolygon(GeometryCollection): ...

GEO_CLASSES: Any
