from datetime import datetime
from typing import Any, Protocol

from django.contrib.sites.models import Site
from django.contrib.sites.requests import RequestSite
from django.core.paginator import Paginator
from django.db.models.base import Model
from django.db.models.query import QuerySet

PING_URL: str

class SitemapNotFound(Exception): ...

def ping_google(sitemap_url: str | None = ..., ping_url: str = ...) -> None: ...

class _SupportsLen(Protocol):
    def __len__(self) -> int: ...

class _SupportsCount(Protocol):
    def count(self) -> int: ...

class _SupportsOrdered(Protocol):
    ordered: bool = ...

class Sitemap:
    limit: int = ...
    protocol: str | None = ...
    def items(self) -> _SupportsLen | _SupportsCount | _SupportsOrdered: ...
    def location(self, obj: Model) -> str: ...
    @property
    def paginator(self) -> Paginator: ...
    def get_urls(
        self,
        page: int | str = ...,
        site: Site | RequestSite | None = ...,
        protocol: str | None = ...,
    ) -> list[dict[str, Any]]: ...

class GenericSitemap(Sitemap):
    priority: float | None = ...
    changefreq: str | None = ...
    queryset: QuerySet[Any] = ...
    date_field: None = ...
    def __init__(
        self,
        info_dict: dict[str, datetime | QuerySet[Any] | str],
        priority: float | None = ...,
        changefreq: str | None = ...,
        protocol: str | None = ...,
    ) -> None: ...
    def lastmod(self, item: Model) -> datetime | None: ...

default_app_config: str
