from collections.abc import Callable
from typing import Any

from django.apps.config import AppConfig
from django.core.checks.messages import CheckMessage

class Tags:
    admin: str = ...
    caches: str = ...
    compatibility: str = ...
    database: str = ...
    models: str = ...
    security: str = ...
    signals: str = ...
    templates: str = ...
    translation: str = ...
    urls: str = ...

_CheckCallable = Callable[..., list[CheckMessage]]

class CheckRegistry:
    registered_checks: set[Callable[..., Any]] = ...
    deployment_checks: set[Callable[..., Any]] = ...
    def __init__(self) -> None: ...
    def register(
        self, check: _CheckCallable | str | None = ..., *tags: str, **kwargs: Any
    ) -> Callable[..., Any]: ...
    def run_checks(
        self,
        app_configs: list[AppConfig] | None = ...,
        tags: list[str] | None = ...,
        include_deployment_checks: bool = ...,
    ) -> list[CheckMessage]: ...
    def tag_exists(self, tag: str, include_deployment_checks: bool = ...) -> bool: ...
    def tags_available(self, deployment_checks: bool = ...) -> set[str]: ...
    def get_checks(
        self, include_deployment_checks: bool = ...
    ) -> list[Callable[..., Any]]: ...

registry: Any
register: Any
run_checks: Any
tag_exists: Any
