from collections.abc import Iterator, Mapping
from typing import Any

class FieldDoesNotExist(Exception): ...
class AppRegistryNotReady(Exception): ...

class ObjectDoesNotExist(Exception):
    silent_variable_failure: bool = ...

class MultipleObjectsReturned(Exception): ...
class SuspiciousOperation(Exception): ...
class SuspiciousMultipartForm(SuspiciousOperation): ...
class SuspiciousFileOperation(SuspiciousOperation): ...
class DisallowedHost(SuspiciousOperation): ...
class DisallowedRedirect(SuspiciousOperation): ...
class TooManyFieldsSent(SuspiciousOperation): ...
class TooManyFilesSent(SuspiciousOperation): ...
class RequestDataTooBig(SuspiciousOperation): ...
class RequestAborted(Exception): ...
class BadRequest(Exception): ...
class PermissionDenied(Exception): ...
class ViewDoesNotExist(Exception): ...
class MiddlewareNotUsed(Exception): ...
class ImproperlyConfigured(Exception): ...
class FieldError(Exception): ...

NON_FIELD_ERRORS: str


ValidationErrorMessageArg = (
    str
    | ValidationError
    | dict[str, ValidationErrorMessageArg]
    | list[ValidationErrorMessageArg]
)


class ValidationError(Exception):
    error_dict: dict[str, list[ValidationError]] | None
    error_list: list[ValidationError] | None
    message: str | None
    code: str | None
    params: Mapping[str, Any] | None
    def __init__(
        self,
        message: ValidationErrorMessageArg,
        code: str | None = ...,
        params: Mapping[str, Any] | None = ...,
    ) -> None: ...
    @property
    def message_dict(self) -> dict[str, list[str]]: ...
    @property
    def messages(self) -> list[str]: ...
    def update_error_dict(
        self, error_dict: Mapping[str, list[ValidationError]]
    ) -> Mapping[str, list[ValidationError]]: ...
    def __iter__(self) -> Iterator[tuple[str, list[ValidationError]] | str]: ...

class EmptyResultSet(Exception): ...
class FullResultSet(Exception): ...
class SynchronousOnlyOperation(Exception): ...
