import enum
from typing import Any, Sequence, TypeVar

_EnumMemberT = TypeVar("_EnumMemberT")

class ChoicesMeta(enum.EnumMeta):
    names: list[str] = ...
    labels: list[str] = ...
    def __contains__(self, item: Any) -> bool: ...
    @property
    def values(self: type[_EnumMemberT]) -> Sequence[_EnumMemberT]: ...
    @property
    def choices(self: type[_EnumMemberT]) -> Sequence[tuple[_EnumMemberT, str]]: ...

class Choices(enum.Enum, metaclass=ChoicesMeta):
    def __str__(self) -> Any: ...
    @property
    def label(self) -> str: ...
    @property
    def value(self) -> Any: ...

class IntegerChoices(int, Choices):
    @property
    def value(self) -> int: ...

class TextChoices(str, Choices):
    @property
    def value(self) -> str: ...
