from typing import Any

from django.db.backends.sqlite3.base import DatabaseWrapper
from django.db.models import Func, Transform
from django.db.models.expressions import Combinable, Expression, Value
from django.db.models.sql.compiler import SQLCompiler

class BytesToCharFieldConversionMixin: ...
class Chr(Transform): ...

class ConcatPair(Func):
    def coalesce(self) -> ConcatPair: ...

class Concat(Func): ...

class Left(Func):
    def __init__(self, expression: str, length: Value | int, **extra: Any) -> None: ...
    def get_substr(self) -> Substr: ...
    def use_substr(
        self, compiler: SQLCompiler, connection: DatabaseWrapper, **extra_context: Any
    ) -> tuple[str, list[int]]: ...

class Length(Transform): ...
class Lower(Transform): ...

class LPad(BytesToCharFieldConversionMixin, Func):
    def __init__(
        self,
        expression: str,
        length: Length | int | None,
        fill_text: Value = ...,
        **extra: Any
    ) -> None: ...

class LTrim(Transform): ...
class Ord(Transform): ...

class Repeat(BytesToCharFieldConversionMixin, Func):
    def __init__(
        self, expression: Value | str, number: Length | int | None, **extra: Any
    ) -> None: ...

class Replace(Func):
    def __init__(
        self,
        expression: Combinable,
        text: Value,
        replacement: Value = ...,
        **extra: Any
    ) -> None: ...

class Right(Left): ...
class RPad(LPad): ...
class RTrim(Transform): ...
class StrIndex(Func): ...

class Substr(Func):
    def __init__(
        self,
        expression: Expression | str,
        pos: Expression | int,
        length: Value | int | None = ...,
        **extra: Any
    ) -> None: ...

class Trim(Transform): ...
class Upper(Transform): ...
class Reverse(Transform): ...
class MySQLSHA2Mixin: ...
class OracleHashMixin: ...
class PostgreSQLSHAMixin: ...
class SHA1(OracleHashMixin, PostgreSQLSHAMixin, Transform): ...
class SHA224(MySQLSHA2Mixin, PostgreSQLSHAMixin, Transform): ...
class SHA256(MySQLSHA2Mixin, OracleHashMixin, PostgreSQLSHAMixin, Transform): ...
class SHA384(MySQLSHA2Mixin, OracleHashMixin, PostgreSQLSHAMixin, Transform): ...
class SHA512(MySQLSHA2Mixin, OracleHashMixin, PostgreSQLSHAMixin, Transform): ...
