from typing import Any

from django.db import models
from django.http import HttpRequest, HttpResponse
from django.views.generic.base import ContextMixin, TemplateResponseMixin, View

class SingleObjectMixin(ContextMixin):
    model: type[models.Model] = ...
    queryset: models.query.QuerySet[Any] = ...
    slug_field: str = ...
    context_object_name: str = ...
    slug_url_kwarg: str = ...
    pk_url_kwarg: str = ...
    query_pk_and_slug: bool = ...
    def get_object(
        self, queryset: models.query.QuerySet[Any] | None = ...
    ) -> models.Model: ...
    def get_queryset(self) -> models.query.QuerySet[Any]: ...
    def get_slug_field(self) -> str: ...
    def get_context_object_name(self, obj: Any) -> str | None: ...

class BaseDetailView(SingleObjectMixin, View):
    def get(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponse: ...

class SingleObjectTemplateResponseMixin(TemplateResponseMixin):
    template_name_field: str | None = ...
    template_name_suffix: str = ...

class DetailView(SingleObjectTemplateResponseMixin, BaseDetailView): ...
