from collections.abc import Sequence
from tkinter.messagebox import NO
from typing import Callable, Literal

import numpy as np
from matplotlib._enums import CapStyle, JoinStyle
from matplotlib._typing import *
from matplotlib.artist import Artist, allow_rasterization
from matplotlib.backend_bases import Event, MouseEvent
from matplotlib.cm import ScalarMappable
from matplotlib.colors import Colormap, Normalize
from matplotlib.lines import Line2D
from matplotlib.patches import Patch
from matplotlib.path import Path
from matplotlib.transforms import Bbox, Transform

class Collection(Artist, ScalarMappable):
    _transforms: np.ndarray = ...

    def __init__(
        self,
        edgecolors: Color | Sequence[Color] | None = None,
        facecolors: Color | Sequence[Color] | None = None,
        linewidths: float | Sequence[float] | None = None,
        linestyles: str | Sequence[str] | None = None,
        capstyle: CapStyle | None = None,
        joinstyle: JoinStyle | None = None,
        antialiaseds: bool | Sequence[bool] | None = None,
        offsets: Sequence[float] | Sequence[Sequence[float]] | None = None,
        offset_transform: Transform | None = None,
        norm: Normalize | None = None,
        cmap: Colormap | None = None,
        pickradius: float = 0.5,
        hatch: str | None = None,
        urls: Sequence[str] | None = None,
        *,
        zorder: int = 1,
        **kwargs,
    ) -> None: ...
    def get_paths(self): ...
    def set_paths(self) -> None: ...
    def get_transforms(self): ...
    def get_offset_transform(self) -> Transform: ...
    def set_offset_transform(self, offset_transform: Transform) -> None: ...
    def get_datalim(self, transData) -> Bbox: ...
    def get_window_extent(self, renderer=...): ...
    @allow_rasterization
    def draw(self, renderer) -> None: ...
    def set_pickradius(self, pr: float) -> None: ...
    def get_pickradius(self) -> float: ...
    def contains(self, mouseevent: Event) -> tuple[bool, dict]: ...
    def set_urls(self, urls: list[str] | None) -> None: ...
    def get_urls(self) -> list[str] | None: ...
    def set_hatch(self, hatch: Literal["/", "\\", "|", "-", "+", "x", "o", "O", ".", "*"]) -> None: ...
    def get_hatch(self) -> str: ...
    def set_offsets(self, offsets: ArrayLike) -> None: ...
    def get_offsets(self) -> ArrayLike: ...
    def set_linewidth(self, lw: float | list[float]) -> None: ...
    def set_linestyle(self, ls: str | tuple) -> None: ...
    def set_capstyle(self, cs: CapStyle | Literal["butt", "projecting", "round"]) -> None: ...
    def get_capstyle(self) -> CapStyle: ...
    def set_joinstyle(self, js: JoinStyle | Literal["miter", "round", "bevel"]) -> None: ...
    def get_joinstyle(self) -> JoinStyle: ...
    def set_antialiased(self, aa: bool | list[bool]) -> None: ...
    def set_color(self, c: Color | list) -> None: ...
    def set_facecolor(self, c: Color | list[Color]) -> None: ...
    def set_facecolors(self, c: Color | list[Color]) -> None: ...
    def get_facecolor(self) -> Color | list[Color]: ...
    def get_edgecolor(self) -> Color | list[Color]: ...
    def get_facecolors(self) -> Color | list[Color]: ...
    def get_edgecolors(self) -> Color | list[Color]: ...
    def set_edgecolor(self, c: Color | list[Color] | Literal["face"]) -> None: ...
    def set_edgecolors(self, c: Color | list[Color] | Literal["face"]) -> None: ...
    def set_alpha(self, alpha: ArrayLike | Scalar | None) -> None: ...
    def get_linewidth(self) -> float: ...
    def get_linestyle(self) -> list[tuple]: ...
    def update_scalarmappable(self) -> None: ...
    def get_fill(self) -> bool: ...
    def update_from(self, other: Collection) -> None: ...

class _CollectionWithSizes(Collection):
    def get_sizes(self) -> np.ndarray: ...
    def set_sizes(self, sizes: np.ndarray | None, dpi: float = ...) -> None: ...
    @allow_rasterization
    def draw(self, renderer) -> None: ...

class PathCollection(_CollectionWithSizes):
    def __init__(self, paths: Sequence[Path], sizes: ArrayLike = ..., **kwargs) -> None: ...
    def set_paths(self, paths: Sequence[Path]) -> None: ...
    def get_paths(self): ...
    def legend_elements(
        self, prop: Literal["colors", "sizes"] = ..., num=..., fmt=..., func: Callable = ..., **kwargs
    ) -> tuple[list[Line2D], list[str]]: ...

class PolyCollection(_CollectionWithSizes):
    def __init__(self, verts, sizes=..., closed=..., **kwargs) -> None: ...
    def set_verts(self, verts: Sequence[ArrayLike], closed: bool = ...) -> None: ...
    def set_paths(self, verts: Sequence[ArrayLike], closed: bool = ...) -> None: ...
    def set_verts_and_codes(self, verts: Sequence[ArrayLike], codes: ArrayLike) -> None: ...

class BrokenBarHCollection(PolyCollection):
    def __init__(self, xranges: Sequence[Sequence[float]], yrange: Sequence[float], **kwargs) -> None: ...
    @classmethod
    def span_where(cls, x, ymin, ymax, where, **kwargs) -> BrokenBarHCollection: ...

class RegularPolyCollection(_CollectionWithSizes):
    def __init__(self, numsides: int, rotation: float = ..., sizes: Sequence[float] = ..., **kwargs) -> None: ...
    def get_numsides(self) -> int: ...
    def get_rotation(self) -> float: ...
    @allow_rasterization
    def draw(self, renderer) -> None: ...

class StarPolygonCollection(RegularPolyCollection): ...
class AsteriskPolygonCollection(RegularPolyCollection): ...

class LineCollection(Collection):
    def __init__(self, segments: Sequence[ArrayLike], *, zorder: int = 2, **kwargs) -> None: ...
    def set_segments(self, segments: Sequence[ArrayLike]) -> None: ...
    def set_verts(self, segments: Sequence[ArrayLike]) -> None: ...
    def set_paths(self, segments: Sequence[ArrayLike]) -> None: ...
    def get_segments(self) -> list: ...
    def set_color(self, c: Color | list[Color]): ...
    def set_colors(self, c: Color | list[Color]): ...
    def get_color(self) -> Color: ...
    def get_colors(self) -> Color: ...

class EventCollection(LineCollection):
    def __init__(
        self,
        positions,
        orientation: str = "horizontal",
        lineoffset: float = 0,
        linelength: float = 1,
        linewidth: float | Sequence[float] | None = None,
        color: Color | Sequence[Color] | None = None,
        linestyle: str | Sequence[str] = "solid",
        antialiased: bool | Sequence[bool] | None = None,
        **kwargs,
    ) -> None: ...
    def get_positions(self) -> list: ...
    def set_positions(self, positions: ArrayLike) -> None: ...
    def add_positions(self, position: ArrayLike) -> None: ...
    def extend_positions(self, position: ArrayLike) -> None: ...
    def append_positions(self, position: ArrayLike) -> None: ...
    def is_horizontal(self) -> bool: ...
    def get_orientation(self) -> str: ...
    def switch_orientation(self) -> None: ...
    def set_orientation(self, orientation: Literal["horizontal", "vertical"]) -> None: ...
    def get_linelength(self) -> float: ...
    def set_linelength(self, linelength: float) -> None: ...
    def get_lineoffset(self) -> float: ...
    def set_lineoffset(self, lineoffset: float) -> None: ...
    def get_linewidth(self) -> float: ...
    def get_linewidths(self) -> list[float]: ...
    def get_color(self) -> Color: ...

class CircleCollection(_CollectionWithSizes):
    def __init__(self, sizes, **kwargs) -> None: ...

class EllipseCollection(Collection):
    def __init__(self, widths: ArrayLike, heights: ArrayLike, angles: ArrayLike, units: str = ..., **kwargs) -> None: ...
    @allow_rasterization
    def draw(self, renderer) -> None: ...

class PatchCollection(Collection):
    def __init__(self, patches: Sequence[Patch], match_original: bool = ..., **kwargs) -> None: ...
    def set_paths(self, patches) -> None: ...

class TriMesh(Collection):
    def __init__(self, triangulation, **kwargs) -> None: ...
    def get_paths(self) -> list[Path]: ...
    def set_paths(self) -> None: ...
    @staticmethod
    def convert_mesh_to_paths(tri) -> list[Path]: ...
    @allow_rasterization
    def draw(self, renderer) -> None: ...

class QuadMesh(Collection):
    def __init__(self, *args, **kwargs) -> None: ...
    def get_paths(self) -> list[Path]: ...
    def set_paths(self) -> None: ...
    def set_array(self, A: ArrayLike) -> None: ...
    def get_datalim(self, transData): ...
    def get_coordinates(self) -> np.ndarray: ...
    @staticmethod
    def convert_mesh_to_paths(meshWidth, meshHeight, coordinates) -> list[Path]: ...
    @allow_rasterization
    def draw(self, renderer) -> None: ...
    def get_cursor_data(self, event: MouseEvent): ...
