from math import log

from ..classes.graph import Graph
from ..utils import not_implemented_for

__all__ = [
    "resource_allocation_index",
    "jaccard_coefficient",
    "adamic_adar_index",
    "preferential_attachment",
    "cn_soundarajan_hopcroft",
    "ra_index_soundarajan_hopcroft",
    "within_inter_cluster",
    "common_neighbor_centrality",
]

def resource_allocation_index(G: Graph, ebunch=None): ...
def jaccard_coefficient(G: Graph, ebunch=None): ...
def adamic_adar_index(G: Graph, ebunch=None): ...
def common_neighbor_centrality(G: Graph, ebunch=None, alpha=0.8): ...
def preferential_attachment(G: Graph, ebunch=None): ...
def cn_soundarajan_hopcroft(G: Graph, ebunch=None, community="community"): ...
def ra_index_soundarajan_hopcroft(G: Graph, ebunch=None, community="community"): ...
def within_inter_cluster(G: Graph, ebunch=None, delta=0.001, community="community"): ...
