from collections.abc import Mapping

from numpy.typing import ArrayLike

from ...classes.graph import Graph

__all__ = [
    "bidirectional_shortest_path",
    "single_source_shortest_path",
    "single_source_shortest_path_length",
    "single_target_shortest_path",
    "single_target_shortest_path_length",
    "all_pairs_shortest_path",
    "all_pairs_shortest_path_length",
    "predecessor",
]

def single_source_shortest_path_length(G: Graph, source, cutoff=None) -> Mapping: ...
def single_target_shortest_path_length(G: Graph, target, cutoff=None): ...
def all_pairs_shortest_path_length(G: Graph, cutoff=None): ...
def bidirectional_shortest_path(G: Graph, source, target) -> ArrayLike: ...
def single_source_shortest_path(G: Graph, source, cutoff=None) -> Mapping: ...
def single_target_shortest_path(G: Graph, target, cutoff=None) -> Mapping: ...
def all_pairs_shortest_path(G: Graph, cutoff=None) -> Mapping: ...
def predecessor(G: Graph, source, target=None, cutoff=None, return_seen=None) -> Mapping: ...
