import warnings
from collections.abc import Mapping

__all__ = [
    "AtlasView",
    "AdjacencyView",
    "MultiAdjacencyView",
    "UnionAtlas",
    "UnionAdjacency",
    "UnionMultiInner",
    "UnionMultiAdjacency",
    "FilterAtlas",
    "FilterAdjacency",
    "FilterMultiInner",
    "FilterMultiAdjacency",
]

class AtlasView(Mapping):
    __slots__ = ...

    def __getstate__(self): ...
    def __setstate__(self, state): ...
    def __init__(self, d): ...
    def __len__(self): ...
    def __iter__(self): ...
    def __getitem__(self, key): ...
    def copy(self): ...
    def __str__(self): ...
    def __repr__(self): ...

class AdjacencyView(AtlasView):
    __slots__ = ...  # Still uses AtlasView slots names _atlas

    def __getitem__(self, name): ...
    def copy(self): ...

class MultiAdjacencyView(AdjacencyView):
    __slots__ = ...  # Still uses AtlasView slots names _atlas

    def __getitem__(self, name): ...
    def copy(self): ...

class UnionAtlas(Mapping):
    __slots__ = ...

    def __getstate__(self): ...
    def __setstate__(self, state): ...
    def __init__(self, succ, pred): ...
    def __len__(self): ...
    def __iter__(self): ...
    def __getitem__(self, key): ...
    def copy(self): ...
    def __str__(self): ...
    def __repr__(self): ...

class UnionAdjacency(Mapping):
    __slots__ = ...

    def __getstate__(self): ...
    def __setstate__(self, state): ...
    def __init__(self, succ, pred): ...
    def __len__(self): ...
    def __iter__(self): ...
    def __getitem__(self, nbr): ...
    def copy(self): ...
    def __str__(self): ...
    def __repr__(self): ...

class UnionMultiInner(UnionAtlas):
    __slots__ = ...  # Still uses UnionAtlas slots names _succ, _pred

    def __getitem__(self, node): ...
    def copy(self): ...

class UnionMultiAdjacency(UnionAdjacency):
    __slots__ = ...  # Still uses UnionAdjacency slots names _succ, _pred

    def __getitem__(self, node): ...

class FilterAtlas(Mapping):  # nodedict, nbrdict, keydict
    def __init__(self, d, NODE_OK): ...
    def __len__(self): ...
    def __iter__(self): ...
    def __getitem__(self, key): ...

    # FIXME should this just be removed? we don't use it, but someone might
    def copy(self): ...
    def __str__(self): ...
    def __repr__(self): ...

class FilterAdjacency(Mapping):  # edgedict
    def __init__(self, d, NODE_OK, EDGE_OK): ...
    def __len__(self): ...
    def __iter__(self): ...
    def __getitem__(self, node): ...

    # FIXME should this just be removed? we don't use it, but someone might
    def copy(self): ...
    def __str__(self): ...
    def __repr__(self): ...

class FilterMultiInner(FilterAdjacency):  # muliedge_seconddict
    def __iter__(self): ...
    def __getitem__(self, nbr): ...

    # FIXME should this just be removed? we don't use it, but someone might
    def copy(self): ...

class FilterMultiAdjacency(FilterAdjacency):  # multiedgedict
    def __getitem__(self, node): ...

    # FIXME should this just be removed? we don't use it, but someone might
    def copy(self): ...
