from copy import deepcopy
from functools import cached_property

import networkx.convert as convert

from ..classes.coreviews import AdjacencyView
from ..classes.graph import Graph
from ..classes.reportviews import DiDegreeView, InDegreeView, InEdgeView, OutDegreeView, OutEdgeView
from ..exception import NetworkXError

__all__ = ["DiGraph"]

class _CachedPropertyResetterAdjAndSucc:
    def __set__(self, obj, value): ...

class _CachedPropertyResetterPred:
    def __set__(self, obj, value): ...

class DiGraph(Graph):
    graph = ...
    _adj = ...  # type: ignore
    _succ = ...  # type: ignore
    _pred = ...

    def __init__(self, incoming_graph_data=None, **attr): ...
    @cached_property
    def adj(self): ...
    @cached_property
    def succ(self): ...
    @cached_property
    def pred(self): ...
    def add_node(self, node_for_adding, **attr): ...
    def add_nodes_from(self, nodes_for_adding, **attr): ...
    def remove_node(self, n): ...
    def remove_nodes_from(self, nodes): ...
    def add_edge(self, u_of_edge, v_of_edge, **attr): ...
    def add_edges_from(self, ebunch_to_add, **attr): ...
    def remove_edge(self, u, v): ...
    def remove_edges_from(self, ebunch): ...
    def has_successor(self, u, v): ...
    def has_predecessor(self, u, v): ...
    def successors(self, n): ...

    # digraph definitions
    neighbors = successors

    def predecessors(self, n): ...
    @cached_property
    def edges(self) -> OutEdgeView: ...

    # alias out_edges to edges
    @cached_property
    def out_edges(self) -> OutEdgeView: ...
    @cached_property
    def in_edges(self) -> InEdgeView: ...
    @cached_property
    def degree(self) -> DiDegreeView | int: ...
    @cached_property
    def in_degree(self): ...
    @cached_property
    def out_degree(self): ...
    def clear(self): ...
    def clear_edges(self): ...
    def is_multigraph(self): ...
    def is_directed(self): ...
    def to_undirected(self, reciprocal=False, as_view=False) -> Graph: ...
    def reverse(self, copy=True): ...
