from collections.abc import Iterable, Mapping
from copy import deepcopy
from functools import cached_property

import networkx.convert as convert
from numpy.typing import ArrayLike

from ..classes.coreviews import AdjacencyView
from ..classes.digraph import DiGraph
from ..classes.reportviews import DegreeView, EdgeView, NodeView
from ..exception import NetworkXError

__all__ = ["Graph"]

class _CachedPropertyResetterAdj:
    def __set__(self, obj, value): ...

class _CachedPropertyResetterNode:
    def __set__(self, obj, value): ...

class Graph:
    graph = ...
    _adj = ...
    _node = ...

    node_dict_factory = ...
    node_attr_dict_factory = ...
    adjlist_outer_dict_factory = ...
    adjlist_inner_dict_factory = ...
    edge_attr_dict_factory = ...
    graph_attr_dict_factory = ...

    def to_directed_class(self): ...
    def to_undirected_class(self): ...
    def __init__(self, incoming_graph_data=None, **attr): ...
    @cached_property
    def adj(self): ...
    @property
    def name(self): ...
    @name.setter
    def name(self, s): ...
    def __iter__(self): ...
    def __contains__(self, n): ...
    def __len__(self) -> int: ...
    def __getitem__(self, n) -> Mapping: ...
    def add_node(self, node_for_adding, **attr): ...
    def add_nodes_from(self, nodes_for_adding, **attr): ...
    def remove_node(self, n): ...
    def remove_nodes_from(self, nodes): ...
    @cached_property
    def nodes(self) -> NodeView: ...
    def number_of_nodes(self) -> int: ...
    def order(self) -> int: ...
    def has_node(self, n): ...
    def add_edge(self, u_of_edge, v_of_edge, **attr): ...
    def add_edges_from(self, ebunch_to_add, **attr): ...
    def add_weighted_edges_from(self, ebunch_to_add, weight="weight", **attr): ...
    def remove_edge(self, u, v): ...
    def remove_edges_from(self, ebunch): ...
    def update(self, edges=None, nodes=None): ...
    def has_edge(self, u, v) -> bool: ...
    def neighbors(self, n): ...
    @cached_property
    def edges(self) -> EdgeView: ...
    def get_edge_data(self, u, v, default=None) -> Mapping: ...
    def adjacency(self): ...
    @cached_property
    def degree(self) -> DegreeView | int: ...
    def clear(self): ...
    def clear_edges(self): ...
    def is_multigraph(self): ...
    def is_directed(self): ...
    def copy(self, as_view=False) -> Graph: ...
    def to_directed(self, as_view=False) -> DiGraph: ...
    def to_undirected(self, as_view=False): ...
    def subgraph(self, nodes: ArrayLike | Iterable): ...
    def edge_subgraph(self, edges: Iterable) -> Graph: ...
    def size(self, weight=None): ...
    def number_of_edges(self, u=None, v=None) -> int: ...
    def nbunch_iter(self, nbunch=None): ...
