import itertools
import numbers
from collections.abc import Iterable

from ..classes import Graph
from ..exception import NetworkXError
from ..utils import nodes_or_number, pairwise

__all__ = [
    "balanced_tree",
    "barbell_graph",
    "binomial_tree",
    "complete_graph",
    "complete_multipartite_graph",
    "circular_ladder_graph",
    "circulant_graph",
    "cycle_graph",
    "dorogovtsev_goltsev_mendes_graph",
    "empty_graph",
    "full_rary_tree",
    "ladder_graph",
    "lollipop_graph",
    "null_graph",
    "path_graph",
    "star_graph",
    "trivial_graph",
    "turan_graph",
    "wheel_graph",
]

# -------------------------------------------------------------------
#   Some Classic Graphs
# -------------------------------------------------------------------

def full_rary_tree(r: int, n: int, create_using=None): ...
def balanced_tree(r: int, h: int, create_using=None): ...
def barbell_graph(m1, m2, create_using=None): ...
def binomial_tree(n: int, create_using=None): ...
@nodes_or_number(0)
def complete_graph(n, create_using=None): ...
def circular_ladder_graph(n, create_using=None): ...
def circulant_graph(n, offsets, create_using=None): ...
@nodes_or_number(0)
def cycle_graph(n, create_using=None): ...
def dorogovtsev_goltsev_mendes_graph(n, create_using=None): ...
@nodes_or_number(0)
def empty_graph(n=0, create_using=None, default=...): ...
def ladder_graph(n, create_using=None): ...
def lollipop_graph(m, n, create_using=None): ...
def null_graph(create_using=None): ...
@nodes_or_number(0)
def path_graph(n: int | Iterable, create_using=None): ...
@nodes_or_number(0)
def star_graph(n: int | Iterable, create_using=None): ...
def trivial_graph(create_using=None): ...
def turan_graph(n: int, r: int): ...
@nodes_or_number(0)
def wheel_graph(n: int | Iterable, create_using=None): ...
def complete_multipartite_graph(*subset_sizes): ...
