__all__ = [
    "make_small_graph",
    "LCF_graph",
    "bull_graph",
    "chvatal_graph",
    "cubical_graph",
    "desargues_graph",
    "diamond_graph",
    "dodecahedral_graph",
    "frucht_graph",
    "heawood_graph",
    "hoffman_singleton_graph",
    "house_graph",
    "house_x_graph",
    "icosahedral_graph",
    "krackhardt_kite_graph",
    "moebius_kantor_graph",
    "octahedral_graph",
    "pappus_graph",
    "petersen_graph",
    "sedgewick_maze_graph",
    "tetrahedral_graph",
    "truncated_cube_graph",
    "truncated_tetrahedron_graph",
    "tutte_graph",
]

from functools import wraps

from ..classes.graph import Graph
from ..exception import NetworkXError
from ..generators.classic import complete_graph, cycle_graph, empty_graph, path_graph

def make_small_undirected_graph(graph_description, create_using=None): ...
def make_small_graph(graph_description, create_using=None): ...
def LCF_graph(n, shift_list, repeats, create_using=None): ...

# -------------------------------------------------------------------------------
#   Various small and named graphs
# -------------------------------------------------------------------------------

def bull_graph(create_using=None): ...
def chvatal_graph(create_using=None): ...
def cubical_graph(create_using=None): ...
def desargues_graph(create_using=None): ...
def diamond_graph(create_using=None): ...
def dodecahedral_graph(create_using=None): ...
def frucht_graph(create_using=None): ...
def heawood_graph(create_using=None): ...
def hoffman_singleton_graph(): ...
def house_graph(create_using=None): ...
def house_x_graph(create_using=None): ...
def icosahedral_graph(create_using=None): ...
def krackhardt_kite_graph(create_using=None): ...
def moebius_kantor_graph(create_using=None): ...
def octahedral_graph(create_using=None): ...
def pappus_graph(): ...
def petersen_graph(create_using=None): ...
def sedgewick_maze_graph(create_using=None): ...
def tetrahedral_graph(create_using=None): ...
def truncated_cube_graph(create_using=None): ...
def truncated_tetrahedron_graph(create_using=None): ...
def tutte_graph(create_using=None): ...
