These stubs were generated by:

- Running `pyright --createstub sympy` after installing sympy into a venv
- Running a script that uncommented all of the return values in the generated stubs
- Running Ruff (`tests/run_hygiene.py`) to cleanup stubs and remove all doc strings from the stubs (as sympy has docstrings itself)
- Adding a `partial` py.typed file
- Fixing all import errors one at a time (using Pylance and `tests/run_tests.py`)

The last part took the longest. It might be quicker to just add any changes by hand, rather than regenerating from scratch.

Scripts for future use:

### Uncomment return values

```python
import os
import re
import shutil

SOURCE_DIR = "typings\\sympy"
DEST_DIR = "typings\\sympy-returnvalues"

def read_file(file_path: str) -> list[str]:
    with open(file_path, "r") as file:
        return file.readlines()

def write_file(file_path: str, lines: list[str]) -> None:
    try:
        os.makedirs(os.path.dirname(file_path))
    except FileExistsError:
        pass
    with open(file_path, "w") as file:
       file.writelines(lines)

def fix_file(file_path: str, dest_path: str, sub_package: str) -> None:
    lines = read_file(file_path)[4:]

    # Turn the return type comments into actual return types
    changed = [re.sub(r":\s+#(.*)", r"\1", line) for line in lines]

    # Replace `from .` imports with `from sympy.<subpackage>.`
    replace_str = f"from sympy.{sub_package + '.' if sub_package else ''}"
    changed = [re.sub(r"from \.", replace_str, line) for line in changed]
    any_changes = [line for line in changed if line not in lines]

    if len(any_changes) > 0:
        # Find this same file in the '.venv/lib/site-packages/sympy' directory and see if it has typing information in it.
        site_packages_file = file_path.replace(SOURCE_DIR, ".venv\\lib\\site-packages\\sympy").replace(".pyi", ".py")
        if os.path.exists(site_packages_file):
            site_packages_lines = read_file(site_packages_file)
            if "->" in site_packages_lines:
                return
            else:
                print(f"Writing {dest_path}")
                write_file(dest_path, changed)

def fix_all_stubs() -> None:
    stubs_dir = SOURCE_DIR
    dest_dir = DEST_DIR
    shutil.rmtree(dest_dir, ignore_errors=True)
    os.makedirs(dest_dir, exist_ok=True)
    # First write a partial py.typed file to the destination directory
    write_file(os.path.join(dest_dir, "py.typed"), ["partial"])

    # Then iterate over all of the generated files and fix them up so they're valid
    for root, dirs, files in os.walk(stubs_dir):
        for file in files:
            if file.endswith(".pyi"):
                file_path = os.path.join(root, file)
                dest_path = file_path.replace(stubs_dir, dest_dir)
                sub_dir_pos = root.index(stubs_dir) + len(stubs_dir) + 1
                sub_dir = root[sub_dir_pos:]
                sub_package = sub_dir.replace("\\", ".")
                fix_file(file_path, dest_path, sub_package)

fix_all_stubs()
```