from typing import Any, Literal
from typing_extensions import Self

from sympy.core.basic import Atom, Basic
from sympy.core.cache import cacheit
from sympy.core.expr import AtomicExpr
from sympy.core.function import FunctionClass, UndefinedFunction
from sympy.core.kind import _NumberKind, _UndefinedKind
from sympy.logic.boolalg import Boolean

class Str(Atom):
    __slots__ = ...
    def __new__(cls, name, **kwargs) -> Self: ...
    def __getnewargs__(self) -> tuple[Any]: ...

def uniquely_named_symbol(xname, exprs=..., compare=..., modify=..., **assumptions) -> Symbol: ...

_uniquely_named_symbol = ...

class Symbol(AtomicExpr, Boolean):
    is_comparable = ...
    __slots__ = ...
    name: str
    is_Symbol = ...
    is_symbol = ...
    @property
    def kind(self) -> _NumberKind | _UndefinedKind: ...
    def __new__(cls, name, **assumptions): ...
    @staticmethod
    def __xnew__(cls, name, **assumptions): ...
    def __getnewargs_ex__(self) -> tuple[tuple[str], Any]: ...
    def __setstate__(self, state) -> None: ...
    @property
    def assumptions0(self): ...
    @cacheit
    def sort_key(self, order=...) -> tuple[tuple[Literal[2], Literal[0], str], tuple[Literal[1], tuple[str]], Any, Any]: ...
    def as_dummy(self) -> Dummy: ...
    def as_real_imag(self, deep=..., **hints) -> tuple[type[UndefinedFunction] | Any, type[UndefinedFunction] | Any] | None: ...
    def is_constant(self, *wrt, **flags) -> bool: ...
    @property
    def free_symbols(self) -> set[Self]: ...

    binary_symbols = ...
    def as_set(self): ...

class Dummy(Symbol):
    _count = ...
    _prng = ...
    _base_dummy_index = ...
    __slots__ = ...
    is_Dummy = ...
    def __new__(cls, name=..., dummy_index=..., **assumptions): ...
    def __getnewargs_ex__(self) -> tuple[tuple[str, Any], Any]: ...
    @cacheit
    def sort_key(self, order=...) -> tuple[tuple[Literal[2], Literal[0], str], tuple[Literal[2], tuple[str, Any]], Any, Any]: ...

class Wild(Symbol):
    is_Wild = ...
    __slots__ = ...
    def __new__(cls, name, exclude=..., properties=..., **assumptions): ...
    def __getnewargs__(self) -> tuple[str, Any, Any]: ...
    @staticmethod
    @cacheit
    def __xnew__(cls, name, exclude, properties, **assumptions): ...
    def matches(self, expr, repl_dict=..., old=...) -> dict[Any, Any] | None: ...

_range = ...

def symbols(names, *, cls=..., **args) -> Any: ...
def var(names, **args) -> Basic | FunctionClass | Any: ...
def disambiguate(*iter) -> tuple: ...
