from typing import Any

from sympy.core.logic import FuzzyBool

class _MatrixDeprecatedMeta(type):
    def __instancecheck__(cls, instance): ...

class MatrixRequired(metaclass=_MatrixDeprecatedMeta):
    rows: int
    cols: int
    def __init_subclass__(cls, **kwargs) -> None: ...
    def __eq__(self, other): ...
    def __getitem__(self, key) -> None: ...
    def __len__(self) -> int: ...
    @property
    def shape(self) -> None: ...

class MatrixShaping(MatrixRequired):
    def col_del(self, col): ...
    def col_insert(self, pos, other): ...
    def col_join(self, other): ...
    def col(self, j): ...
    def extract(self, rowsList, colsList): ...
    def get_diag_blocks(self): ...
    @classmethod
    def hstack(cls, *args): ...
    def reshape(self, rows, cols): ...
    def row_del(self, row): ...
    def row_insert(self, pos, other): ...
    def row_join(self, other): ...
    def diagonal(self, k: int = 0): ...
    def row(self, i): ...
    @property
    def shape(self): ...
    def todok(self): ...
    def tolist(self): ...
    def todod(M): ...
    def vec(self): ...
    def vech(self, diagonal: bool = True, check_symmetry: bool = True): ...
    @classmethod
    def vstack(cls, *args): ...

class MatrixSpecial(MatrixRequired):
    @classmethod
    def diag(
        kls,
        *args,
        strict: bool = False,
        unpack: bool = True,
        rows: Any | None = None,
        cols: Any | None = None,
        **kwargs,
    ): ...
    @classmethod
    def eye(kls, rows, cols: Any | None = None, **kwargs): ...
    @classmethod
    def jordan_block(kls, size: Any | None = None, eigenvalue: Any | None = None, *, band: str = "upper", **kwargs): ...
    @classmethod
    def ones(kls, rows, cols: Any | None = None, **kwargs): ...
    @classmethod
    def zeros(kls, rows, cols: Any | None = None, **kwargs): ...
    @classmethod
    def companion(kls, poly): ...
    @classmethod
    def wilkinson(kls, n, **kwargs): ...

class MatrixProperties(MatrixRequired):
    def atoms(self, *types): ...
    @property
    def free_symbols(self): ...
    def has(self, *patterns): ...
    def is_anti_symmetric(self, simplify: bool = True): ...
    def is_diagonal(self): ...
    @property
    def is_weakly_diagonally_dominant(self): ...
    @property
    def is_strongly_diagonally_dominant(self): ...
    @property
    def is_hermitian(self): ...
    @property
    def is_Identity(self) -> FuzzyBool: ...
    @property
    def is_lower_hessenberg(self): ...
    @property
    def is_lower(self): ...
    @property
    def is_square(self): ...
    def is_symbolic(self): ...
    def is_symmetric(self, simplify: bool = True): ...
    @property
    def is_upper_hessenberg(self): ...
    @property
    def is_upper(self): ...
    @property
    def is_zero_matrix(self): ...
    def values(self): ...

class MatrixOperations(MatrixRequired):
    def adjoint(self): ...
    def applyfunc(self, f): ...
    def as_real_imag(self, deep: bool = True, **hints): ...
    def conjugate(self): ...
    def doit(self, **hints): ...
    def evalf(
        self,
        n: int = 15,
        subs: Any | None = None,
        maxn: int = 100,
        chop: bool = False,
        strict: bool = False,
        quad: Any | None = None,
        verbose: bool = False,
    ): ...
    def expand(
        self,
        deep: bool = True,
        modulus: Any | None = None,
        power_base: bool = True,
        power_exp: bool = True,
        mul: bool = True,
        log: bool = True,
        multinomial: bool = True,
        basic: bool = True,
        **hints,
    ): ...
    @property
    def H(self): ...
    def permute(self, perm, orientation: str = "rows", direction: str = "forward"): ...
    def permute_cols(self, swaps, direction: str = "forward"): ...
    def permute_rows(self, swaps, direction: str = "forward"): ...
    def refine(self, assumptions: bool = True): ...
    def replace(self, F, G, map: bool = False, simultaneous: bool = True, exact: Any | None = None): ...
    def rot90(self, k: int = 1): ...
    def simplify(self, **kwargs): ...
    def subs(self, *args, **kwargs): ...
    def trace(self): ...
    def transpose(self): ...
    @property
    def T(self): ...
    @property
    def C(self): ...
    def n(self, *args, **kwargs): ...
    def xreplace(self, rule): ...
    def upper_triangular(self, k: int = 0): ...
    def lower_triangular(self, k: int = 0): ...

class MatrixArithmetic(MatrixRequired):
    def __abs__(self): ...
    def __add__(self, other): ...
    def __truediv__(self, other): ...
    def __matmul__(self, other): ...
    def __mod__(self, other): ...
    def __mul__(self, other): ...
    def multiply(self, other, dotprodsimp: Any | None = None): ...
    def multiply_elementwise(self, other): ...
    def __neg__(self): ...
    def __pow__(self, exp): ...
    def pow(self, exp, method: Any | None = None): ...
    def __radd__(self, other): ...
    def __rmatmul__(self, other): ...
    def __rmul__(self, other): ...
    def rmultiply(self, other, dotprodsimp: Any | None = None): ...
    def __rsub__(self, a): ...
    def __sub__(self, a): ...

class MatrixCommon(MatrixArithmetic, MatrixOperations, MatrixProperties, MatrixSpecial, MatrixShaping): ...

class _MinimalMatrix:
    is_MatrixLike: bool
    zero: Any
    one: Any
    is_Matrix: bool
    is_MatrixExpr: bool
    mat: Any
    def __init__(self, rows, cols: Any | None = None, mat: Any | None = None, copy: bool = False) -> None: ...
    def __getitem__(self, key): ...
    def __eq__(self, other): ...
    def __len__(self) -> int: ...
    @property
    def shape(self): ...

class _CastableMatrix:
    def as_mutable(self): ...
    def as_immutable(self): ...

class _MatrixWrapper:
    is_Matrix: bool
    is_MatrixLike: bool
    mat: Any
    shape: Any
    def __init__(self, mat, shape) -> None: ...
    def __getitem__(self, key): ...
    def __iter__(self): ...

def a2idx(j, n: Any | None = None): ...
def classof(A, B): ...
