from collections.abc import Generator
from typing import Any, Literal
from typing_extensions import LiteralString

from sympy import Function
from sympy.core.numbers import Integer
from sympy.series.order import Order

MERSENNE_PRIME_EXPONENTS = ...
PERFECT = ...
MERSENNES = ...
small_trailing = ...

def smoothness(n) -> tuple[Literal[1], Literal[1]] | tuple[Any, Any]: ...
def smoothness_p(
    n, m=..., power=..., visual=...
) -> str | dict[Any, Any] | tuple[Any, ...] | tuple[int, list[tuple[Any, tuple[Any, ...]]]] | LiteralString: ...
def multiplicity(p, n) -> int: ...
def multiplicity_in_factorial(p, n): ...
def perfect_power(n, candidates=..., big=..., factor=...): ...
def pollard_rho(n, s=..., a=..., retries=..., seed=..., max_steps=..., F=...) -> int | None: ...
def pollard_pm1(n, B=..., a=..., retries=..., seed=...) -> int | None: ...

trial_int_msg = ...
trial_msg = ...
rho_msg = ...
pm1_msg = ...
ecm_msg = ...
factor_msg = ...
fermat_msg = ...
complete_msg = ...

def factorint(n, limit=..., use_trial=..., use_rho=..., use_pm1=..., use_ecm=..., verbose=..., visual=..., multiple=...): ...
def factorrat(
    rat, limit=..., use_trial=..., use_rho=..., use_pm1=..., verbose=..., visual=..., multiple=...
) -> list[Any] | dict[Any, int] | Order: ...
def primefactors(n, limit=..., verbose=...) -> list[Any]: ...
def divisors(
    n, generator=..., proper=...
) -> list[int] | list[Any] | list[Any | Literal[1]] | Generator[Any | Literal[1], Any, None]: ...
def divisor_count(n, modulus=..., proper=...) -> Order | Literal[0]: ...
def proper_divisors(
    n, generator=...
) -> list[int] | list[Any] | list[Any | Literal[1]] | Generator[Any | Literal[1], Any, None]: ...
def proper_divisor_count(n, modulus=...) -> Order | Literal[0]: ...
def udivisors(n, generator=...) -> list[int] | list[Any] | list[Any | Literal[1]] | Generator[Any | Literal[1], Any, None]: ...
def udivisor_count(n) -> Any | Literal[0]: ...
def antidivisors(n, generator=...) -> list[Any] | list[Any | int] | Generator[Any | int, Any, None]: ...
def antidivisor_count(n) -> Literal[0]: ...

class totient(Function):
    @classmethod
    def eval(cls, n) -> Literal[1] | None: ...

class reduced_totient(Function):
    @classmethod
    def eval(cls, n) -> Literal[1, 0] | None: ...

class divisor_sigma(Function):
    @classmethod
    def eval(cls, n, k=...) -> Integer | Order | None: ...

def core(n, t=...) -> Literal[1]: ...

class udivisor_sigma(Function):
    @classmethod
    def eval(cls, n, k=...) -> Order | None: ...

class primenu(Function):
    @classmethod
    def eval(cls, n) -> int | None: ...

class primeomega(Function):
    @classmethod
    def eval(cls, n) -> int | None: ...

def mersenne_prime_exponent(
    nth,
) -> Literal[
    2,
    3,
    5,
    7,
    13,
    17,
    19,
    31,
    61,
    89,
    107,
    127,
    521,
    607,
    1279,
    2203,
    2281,
    3217,
    4253,
    4423,
    9689,
    9941,
    11213,
    19937,
    21701,
    23209,
    44497,
    86243,
    110503,
    132049,
    216091,
    756839,
    859433,
    1257787,
    1398269,
    2976221,
    3021377,
    6972593,
    13466917,
    20996011,
    24036583,
    25964951,
    30402457,
    32582657,
    37156667,
    42643801,
    43112609,
    57885161,
    74207281,
    77232917,
    82589933,
]: ...
def is_perfect(n) -> bool | None: ...
def abundance(n): ...
def is_abundant(n) -> bool: ...
def is_deficient(n) -> bool: ...
def is_amicable(m, n) -> bool: ...
def dra(n, b) -> int: ...
def drm(n, b) -> int: ...
