import os
from collections import OrderedDict
from collections.abc import Callable, Iterator, KeysView, ValuesView
from typing import Any, TypeVar

from transformers.configuration_utils import PretrainedConfig

_F = TypeVar("_F", bound=Callable[..., Any])

CONFIG_MAPPING_NAMES: OrderedDict[str, str]
CONFIG_ARCHIVE_MAP_MAPPING_NAMES: OrderedDict[str, str]
MODEL_NAMES_MAPPING: OrderedDict[str, str]
SPECIAL_MODEL_TYPE_TO_MODULE_NAME: OrderedDict[str, str]

def model_type_to_module_name(key) -> str: ...
def config_class_to_model_type(config) -> str | None: ...

class _LazyConfigMapping(OrderedDict[str, type[PretrainedConfig]]):
    def __init__(self, mapping) -> None: ...
    def __getitem__(self, key: str) -> type[PretrainedConfig]: ...
    def keys(self) -> list[str]: ...
    def values(self) -> list[type[PretrainedConfig]]: ...
    def items(self) -> list[tuple[str, type[PretrainedConfig]]]: ...
    def __iter__(self) -> Iterator[str]: ...
    def __contains__(self, item: object) -> bool: ...
    def register(self, key: str, value: type[PretrainedConfig]) -> None: ...

CONFIG_MAPPING: _LazyConfigMapping

class _LazyLoadAllMappings(OrderedDict[str, str]):
    def __init__(self, mapping) -> None: ...
    def __getitem__(self, key: str) -> str: ...
    def keys(self) -> KeysView[str]: ...
    def values(self) -> ValuesView[str]: ...
    def items(self) -> KeysView[str]: ...
    def __iter__(self) -> Iterator[str]: ...
    def __contains__(self, item: object) -> bool: ...

ALL_PRETRAINED_CONFIG_ARCHIVE_MAP: _LazyLoadAllMappings

def replace_list_option_in_docstrings(config_to_class=None, use_model_types: bool = True) -> Callable[[_F], _F]: ...

class AutoConfig:
    def __init__(self) -> None: ...
    @classmethod
    def for_model(cls, model_type: str, *args, **kwargs) -> PretrainedConfig: ...
    @classmethod
    def from_pretrained(cls, pretrained_model_name_or_path: str | os.PathLike[str], **kwargs): ...
    @staticmethod
    def register(model_type, config) -> None: ...
