from typing import Literal

import numpy as np
from numpy.typing import ArrayLike

from ..util.fourier import fft_freqs, stft
from .image import ImageVisual

# -----------------------------------------------------------------------------
# Copyright (c) Vispy Development Team. All Rights Reserved.
# Distributed under the (new) BSD License. See LICENSE.txt for more info.
# -----------------------------------------------------------------------------

class SpectrogramVisual(ImageVisual):
    def __init__(
        self,
        x: ArrayLike | None = None,
        n_fft: int = 256,
        step: None | int = None,
        fs: float = 1.0,
        window: str | None = "hann",
        normalize: bool = False,
        color_scale: Literal["linear", "log"] = "log",
        cmap: str = "cubehelix",
        clim: str | tuple = "auto",
    ): ...
    @property
    def freqs(self): ...
    @property
    def x(self): ...
    @x.setter
    def x(self, x): ...
    @property
    def n_fft(self): ...
    @n_fft.setter
    def n_fft(self, n_fft): ...
    @property
    def step(self): ...
    @step.setter
    def step(self, step): ...
    @property
    def fs(self): ...
    @fs.setter
    def fs(self, fs): ...
    @property
    def window(self): ...
    @window.setter
    def window(self, window): ...
    @property
    def color_scale(self): ...
    @color_scale.setter
    def color_scale(self, color_scale): ...
    @property
    def normalize(self): ...
    @normalize.setter
    def normalize(self, normalize): ...
    def _calculate_spectrogram(self): ...
    def _update_image(self): ...
