import numpy as np
from numpy.typing import ArrayLike

from ... import gloo
from ._util import arg_to_array, arg_to_vec4, as_vec4
from .base_transform import BaseTransform

# Copyright (c) Vispy Development Team. All Rights Reserved.
# Distributed under the (new) BSD License. See LICENSE.txt for more info.

class LogTransform(BaseTransform):
    # TODO: Evaluate the performance costs of using conditionals.
    # An alternative approach is to transpose the vector before
    # log-transforming, and then transpose back afterward.
    glsl_map: str = ...

    glsl_imap = ...

    Linear: bool = ...
    Orthogonal: bool = ...
    NonScaling: bool = ...
    Isometric: bool = ...

    def __init__(self, base: ArrayLike | None = None): ...
    @property
    def base(self): ...
    @base.setter
    def base(self, s): ...
    @arg_to_array
    def map(self, coords, base=None): ...
    @arg_to_array
    def imap(self, coords): ...
    def shader_map(self): ...
    def shader_imap(self): ...
    def __repr__(self): ...

class PolarTransform(BaseTransform):
    glsl_map: str = ...

    glsl_imap: str = ...

    Linear: bool = ...
    Orthogonal: bool = ...
    NonScaling: bool = ...
    Isometric: bool = ...

    @arg_to_array
    def map(self, coords): ...
    @arg_to_array
    def imap(self, coords): ...

# class BilinearTransform(BaseTransform):
#    # TODO
#    pass

# class WarpTransform(BaseTransform):
#    """ Multiple bilinear transforms in a grid arrangement.
#    """
#    # TODO

class MagnifyTransform(BaseTransform):
    glsl_map: str = ...

    glsl_imap = ...

    Linear: bool = ...

    _trans_resolution: int = ...

    def __init__(
        self,
        mag: float = 3,
        radii: tuple[float, float] = ...,
        center: tuple[float, float] = ...,
    ): ...
    @property
    def center(self): ...
    @center.setter
    def center(self, center): ...
    @property
    def mag(self): ...
    @mag.setter
    def mag(self, mag): ...
    @property
    def radii(self): ...
    @radii.setter
    def radii(self, radii): ...
    def shader_map(self): ...
    def shader_imap(self): ...
    @arg_to_vec4
    def map(self, x, _inverse=False): ...
    def imap(self, coords): ...
    def _get_transition(self): ...

class Magnify1DTransform(MagnifyTransform):
    glsl_map: str = ...

    glsl_imap = ...
