const getFileExtension = (filename: string, pureSuffix: boolean): string => {
  filename = filename.toLowerCase()
  let pos: number = filename.lastIndexOf('.')
  if (pos === -1) { // 无后缀文件
    return ''
  }

  let parts: string[] = filename.split('.')
  let penultimate: string = parts[parts.length - 2]
  if (parts.length >= 3 && penultimate === 'tar') { // 双后缀压缩文件
    if (pureSuffix) return 'tar.' + parts[parts.length - 1]
    else return '.tar.' + parts[parts.length - 1]
  }

  // 其他文件
  if (pureSuffix) return filename.substring(pos + 1)
  else return filename.substring(pos)
}
let a = getFileExtension('wemm.mp4', true)
console.log(a)
