/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingType;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetSampleProvider;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDocumentContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskInfoCollector;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.serialize.DTObjectSerializer;
import org.jkiss.dbeaver.tools.transfer.serialize.SerializerContext;
import org.jkiss.dbeaver.tools.transfer.serialize.SerializerRegistry;
import org.jkiss.utils.CommonUtils;

public class DTUtils {
    private static final Log log = Log.getLog(DTUtils.class);
    private static final int MAX_SAMPLE_ROWS = 1000;

    public static void addSummary(StringBuilder summary, String option, Object value) {
        summary.append("\t").append(option).append(": ").append(value).append("\n");
    }

    public static void addSummary(StringBuilder summary, String option, boolean value) {
        summary.append("\t").append(option).append(": ").append(value ? "Yes" : "No").append("\n");
    }

    public static void addSummary(StringBuilder summary, DataTransferProcessorDescriptor processor, Map<?, ?> props) {
        summary.append(NLS.bind((String)DTMessages.data_transfer_summary_title, (Object)processor.getName())).append(":\n");
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = processor.getProperties();
        int n = dBPPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
            Object propValue = props.get(prop.getId());
            if (propValue == null) {
                propValue = prop.getDefaultValue();
            }
            if (propValue != null) {
                DTUtils.addSummary(summary, prop.getDisplayName(), propValue);
            }
            ++n2;
        }
    }

    public static String getTableName(DBPDataSource dataSource, DBPNamedObject source, boolean shortName) {
        DBSDataContainer dataContainer;
        SQLQueryContainer queryContainer;
        if (source instanceof DBSEntity) {
            return shortName ? DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)source)) : DBUtils.getObjectFullName((DBPNamedObject)source, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        String tableName = null;
        if (source instanceof SQLQueryContainer) {
            tableName = DTUtils.getTableNameFromQuery(dataSource, (SQLQueryContainer)source, shortName);
        } else if (source instanceof IAdaptable && (queryContainer = (SQLQueryContainer)((IAdaptable)source).getAdapter(SQLQueryContainer.class)) != null) {
            tableName = DTUtils.getTableNameFromQuery(dataSource, queryContainer, shortName);
        }
        if (tableName == null && source instanceof IAdaptable && (dataContainer = (DBSDataContainer)((IAdaptable)source).getAdapter(DBSDataContainer.class)) instanceof DBSEntity) {
            String string = tableName = shortName ? DBUtils.getQuotedIdentifier((DBSObject)dataContainer) : DBUtils.getObjectFullName((DBPNamedObject)dataContainer, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        if (tableName == null) {
            return shortName ? DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)source.getName()) : DBUtils.getObjectFullName((DBPNamedObject)source, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        return tableName;
    }

    @Nullable
    public static String getTableNameFromQueryContainer(DBPDataSource dataSource, @NotNull SQLQueryContainer queryContainer) {
        if (dataSource == null) {
            return null;
        }
        String nameFromQuery = DTUtils.getTableNameFromQuery(dataSource, queryContainer, true);
        if (CommonUtils.isEmpty((String)nameFromQuery)) {
            return null;
        }
        return nameFromQuery;
    }

    public static String getTableNameFromQuery(DBPDataSource dataSource, SQLQueryContainer queryContainer, boolean shortName) {
        DBCEntityMetaData singleSource;
        SQLScriptElement query = queryContainer.getQuery();
        if (query instanceof SQLQuery && (singleSource = ((SQLQuery)query).getEntityMetadata(true)) != null) {
            SQLDialect dialect = dataSource.getSQLDialect();
            String entity = DTUtils.transformName(dialect, singleSource.getEntityName());
            if (shortName) {
                return entity;
            }
            String schema = DTUtils.transformName(dialect, singleSource.getSchemaName());
            String catalog = DTUtils.transformName(dialect, singleSource.getCatalogName());
            String structSeparator = String.valueOf(dialect.getStructSeparator());
            StringBuilder nameBuilder = new StringBuilder();
            if (catalog != null) {
                nameBuilder.append(catalog).append(structSeparator);
            }
            if (schema != null) {
                nameBuilder.append(schema).append(structSeparator);
            }
            nameBuilder.append(entity);
            return nameBuilder.toString();
        }
        return null;
    }

    @Nullable
    public static String getTargetContainersNameFromQuery(@NotNull SQLQueryContainer queryContainer) {
        List selectEntitiesNames;
        SQLScriptElement query = queryContainer.getQuery();
        if (query instanceof SQLQuery && !CommonUtils.isEmpty((Collection)(selectEntitiesNames = ((SQLQuery)query).getAllSelectEntitiesNames()))) {
            StringJoiner names = new StringJoiner("_");
            selectEntitiesNames.forEach(names::add);
            return names.toString();
        }
        return null;
    }

    @Nullable
    private static String transformName(@NotNull SQLDialect dialect, @Nullable String name) {
        if (name == null) {
            return null;
        }
        if (dialect.isQuotedIdentifier(name)) {
            return name;
        }
        DBPIdentifierCase identifierCase = dialect.storesUnquotedCase();
        return identifierCase.transform(name);
    }

    public static void closeContents(@NotNull DBCResultSet resultSet, @NotNull DBDContent content) {
        if (resultSet.getFeature("local") != null) {
            return;
        }
        content.release();
    }

    @NotNull
    public static <T extends DBSAttributeBase & DBSObject> List<T> getAttributes(@NotNull DBRProgressMonitor monitor, @NotNull DBSDataContainer container, @NotNull Object controller) throws DBException {
        ArrayList<DBSEntityAttribute> attributes = new ArrayList<DBSEntityAttribute>();
        if (container instanceof DBSEntity && !(container instanceof DBSDocumentContainer)) {
            for (DBSEntityAttribute attr : CommonUtils.safeList((List)((DBSEntity)container).getAttributes(monitor))) {
                if (DBUtils.isHiddenObject((Object)attr)) continue;
                attributes.add(attr);
            }
        } else {
            DBCExecutionContext context;
            DBCExecutionContext dBCExecutionContext = context = container instanceof DBPContextProvider ? ((DBPContextProvider)container).getExecutionContext() : DBUtils.getDefaultContext((DBSObject)container, (boolean)false);
            if (context == null) {
                throw new DBCException("No execution context");
            }
            DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)context.getDataSource(), monitor1 -> {
                MetadataReceiver receiver = new MetadataReceiver(container);
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (DBCSession session = context.openSession(monitor1, DBCExecutionPurpose.META, "Read query meta data");){
                        AbstractExecutionSource executionSource = new AbstractExecutionSource(container, session.getExecutionContext(), controller);
                        container.readData((DBCExecutionSource)executionSource, session, (DBDDataReceiver)receiver, null, 0L, 1L, 0L, 1);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
                if (receiver.attributes == null) {
                    throw new InvocationTargetException(new DBCException("Query does not contain any attributes"));
                }
                DBDAttributeBinding[] dBDAttributeBindingArray = receiver.attributes;
                int n = receiver.attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
                    if (!DBUtils.isHiddenObject((Object)attr)) {
                        attributes.add((DBSEntityAttribute)attr);
                    }
                    ++n2;
                }
            });
        }
        return attributes;
    }

    public static <OBJECT_CONTEXT, OBJECT_TYPE> Object deserializeObject(@NotNull DBRRunnableContext runnableContext, SerializerContext serializeContext, OBJECT_CONTEXT objectContext, @NotNull Map<String, Object> objectConfig) throws DBCException {
        String typeID = CommonUtils.toString((Object)objectConfig.get("type"));
        DTObjectSerializer serializer = SerializerRegistry.getInstance().createSerializerByType(typeID);
        if (serializer == null) {
            return null;
        }
        Map location = JSONUtils.getObject(objectConfig, (String)"location");
        try {
            return serializer.deserializeObject(runnableContext, serializeContext, objectContext, location);
        }
        catch (DBException e) {
            throw new RuntimeException(e);
        }
    }

    public static <OBJECT_CONTEXT, OBJECT_TYPE> Map<String, Object> serializeObject(DBRRunnableContext runnableContext, OBJECT_CONTEXT context, @NotNull OBJECT_TYPE object) throws DBException {
        DTObjectSerializer serializer = SerializerRegistry.getInstance().createSerializer(object);
        if (serializer == null) {
            return null;
        }
        LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> location = new LinkedHashMap<String, Object>();
        serializer.serializeObject(runnableContext, context, object, location);
        state.put("type", SerializerRegistry.getInstance().getObjectType(object));
        state.put("location", location);
        return state;
    }

    public static void collectTaskInfo(DBTTask task, Map<String, Object> objectConfig, DBTTaskInfoCollector.TaskInformation information) {
    }

    @NotNull
    public static DBDAttributeBinding[] makeLeafAttributeBindings(@NotNull DBCSession session, @NotNull DBSDataContainer dataContainer, @NotNull DBCResultSet resultSet) throws DBCException {
        boolean isDocumentAttribute;
        ArrayList<DBDAttributeBinding> metaColumns = new ArrayList<DBDAttributeBinding>();
        List attributes = resultSet.getMeta().getAttributes();
        boolean bl = isDocumentAttribute = attributes.size() == 1 && ((DBCAttributeMetaData)attributes.get(0)).getDataKind() == DBPDataKind.DOCUMENT;
        if (isDocumentAttribute) {
            DTUtils.bindDocumentAttribute(session, dataContainer, resultSet, attributes, metaColumns);
        }
        if (metaColumns.isEmpty()) {
            for (DBCAttributeMetaData attribute : attributes) {
                DBDAttributeBindingMeta columnBinding = DBUtils.getAttributeBinding((DBSDataContainer)dataContainer, (DBCSession)session, (DBCAttributeMetaData)attribute);
                metaColumns.add((DBDAttributeBinding)columnBinding);
            }
        }
        ArrayList<DBDAttributeBinding> result = new ArrayList<DBDAttributeBinding>(metaColumns.size());
        for (DBDAttributeBinding binding : metaColumns) {
            DTUtils.addLeafBindings(result, binding);
        }
        if (!isDocumentAttribute) {
            try {
                DBSEntity entity;
                DBExecUtils.bindAttributes((DBCSession)session, (DBSEntity)(dataContainer instanceof DBSEntity ? (entity = (DBSEntity)dataContainer) : null), (DBCResultSet)resultSet, (DBDAttributeBinding[])metaColumns.toArray(new DBDAttributeBinding[0]), null);
            }
            catch (Exception e) {
                log.debug((Object)"Error binding attributes", (Throwable)e);
            }
        }
        return DBUtils.injectAndFilterAttributeBindings((DBPDataSource)session.getDataSource(), (DBSDataContainer)dataContainer, (DBDAttributeBinding[])result.toArray(new DBDAttributeBinding[0]), (boolean)true);
    }

    private static void bindDocumentAttribute(@NotNull DBCSession session, @NotNull DBSDataContainer dataContainer, @NotNull DBCResultSet resultSet, List<? extends DBCAttributeMetaData> attributes, List<DBDAttributeBinding> metaColumns) {
        DBCAttributeMetaData attributeMeta = attributes.get(0);
        DBDAttributeBindingMeta docBinding = DBUtils.getAttributeBinding((DBSDataContainer)dataContainer, (DBCSession)session, (DBCAttributeMetaData)attributeMeta);
        try {
            List sampleRows = Collections.emptyList();
            if (resultSet instanceof DBCResultSetSampleProvider) {
                DBCResultSetSampleProvider rssp = (DBCResultSetSampleProvider)resultSet;
                session.getProgressMonitor().subTask("Read sample rows");
                sampleRows = rssp.getSampleRows(session, 1000);
            }
            session.getProgressMonitor().subTask("Discover attribute structure");
            docBinding.lateBinding(session, sampleRows);
        }
        catch (Exception e) {
            log.error((Object)("Document attribute '" + docBinding.getName() + "' binding error"), (Throwable)e);
        }
        List nested = docBinding.getNestedBindings();
        if (!CommonUtils.isEmpty((Collection)nested)) {
            metaColumns.addAll(nested);
        } else {
            try {
                List entityAttrs;
                DBSEntity docEntity = DBUtils.getEntityFromMetaData((DBRProgressMonitor)session.getProgressMonitor(), (DBCExecutionContext)session.getExecutionContext(), (DBCEntityMetaData)attributeMeta.getEntityMetaData());
                if (docEntity != null && !CommonUtils.isEmpty((Collection)(entityAttrs = docEntity.getAttributes(session.getProgressMonitor())))) {
                    for (DBSEntityAttribute ea : entityAttrs) {
                        metaColumns.add((DBDAttributeBinding)new DBDAttributeBindingType((DBDAttributeBinding)docBinding, (DBSAttributeBase)ea, metaColumns.size()));
                    }
                }
            }
            catch (Exception e) {
                log.debug((Object)"Error getting attributes from document entity", (Throwable)e);
            }
        }
    }

    private static void addLeafBindings(List<DBDAttributeBinding> result, DBDAttributeBinding binding) {
        List nestedBindings = binding.getNestedBindings();
        if (CommonUtils.isEmpty((Collection)nestedBindings)) {
            result.add(binding);
        } else {
            for (DBDAttributeBinding nested : nestedBindings) {
                DTUtils.addLeafBindings(result, nested);
            }
        }
    }

    private static class MetadataReceiver
    implements DBDDataReceiver {
        private final DBSDataContainer container;
        private DBDAttributeBinding[] attributes;

        public MetadataReceiver(DBSDataContainer container) {
            this.container = container;
        }

        public void fetchStart(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
            this.attributes = DTUtils.makeLeafAttributeBindings(session, this.container, resultSet);
        }

        public void fetchRow(@NotNull DBCSession session, @NotNull DBCResultSet resultSet) {
        }

        public void fetchEnd(@NotNull DBCSession session, @NotNull DBCResultSet resultSet) {
        }

        public void close() {
        }
    }
}

