/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.MySQLUtils;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DatabaseURL;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.connection.LocalNativeClientLocation;
import org.jkiss.dbeaver.model.connection.NativeClientLocationUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.registry.LocalSystemRegistry;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class MySQLDataSourceProvider
extends JDBCDataSourceProvider
implements DBPNativeClientLocationManager {
    private static final Log log = Log.getLog(MySQLDataSourceProvider.class);
    private static final String REGISTRY_ROOT_MYSQL_64 = "SOFTWARE\\Wow6432Node\\MYSQL AB";
    private static final String REGISTRY_ROOT_MARIADB = "SOFTWARE\\Monty Program AB";
    private static final String SERER_LOCATION_KEY = "Location";
    private static final String INSTALLDIR_KEY = "INSTALLDIR";
    @Nullable
    private static Map<String, DBPNativeClientLocation> localClients;
    private static Map<String, String> connectionsProps;

    static {
        connectionsProps = new HashMap<String, String>();
        connectionsProps.put("characterEncoding", GeneralUtils.UTF8_ENCODING);
        connectionsProps.put("tinyInt1isBit", "false");
        connectionsProps.put("interactiveClient", "true");
    }

    public static Map<String, String> getConnectionsProps() {
        return connectionsProps;
    }

    protected String getConnectionPropertyDefaultValue(String name, String value) {
        String ovrValue = connectionsProps.get(name);
        return ovrValue != null ? ovrValue : super.getConnectionPropertyDefaultValue(name, value);
    }

    public long getFeatures() {
        return 1L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        if (connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL) {
            return connectionInfo.getUrl();
        }
        if (driver.isSampleURLApplicable()) {
            return DatabaseURL.generateUrlByTemplate((DBPDriver)driver, (DBPConnectionConfiguration)connectionInfo);
        }
        StringBuilder url = new StringBuilder();
        boolean needMariDBString = false;
        if (MySQLUtils.isMariaDB(driver)) {
            try {
                Object driverInstance = driver.getDriverInstance((DBRProgressMonitor)new VoidProgressMonitor());
                if (driverInstance instanceof Driver && ((Driver)driverInstance).getMajorVersion() >= 3) {
                    needMariDBString = true;
                }
            }
            catch (DBException e) {
                log.error((Object)"Can't recognize MariaDB driver version", (Throwable)e);
            }
        }
        if (needMariDBString) {
            url.append("jdbc:mariadb://");
        } else {
            url.append("jdbc:mysql://");
        }
        url.append(connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            url.append(":").append(connectionInfo.getHostPort());
        }
        url.append("/");
        if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            url.append(connectionInfo.getDatabaseName());
        }
        return url.toString();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new MySQLDataSource(monitor, container);
    }

    public List<DBPNativeClientLocation> findLocalClientLocations() {
        return new ArrayList<DBPNativeClientLocation>(MySQLDataSourceProvider.findLocalClients().values());
    }

    public DBPNativeClientLocation getDefaultLocalClientLocation() {
        return (DBPNativeClientLocation)CommonUtils.getFirstOrNull(MySQLDataSourceProvider.findLocalClients().values());
    }

    public String getProductName(DBPNativeClientLocation location) {
        return "MySQL/MariaDB";
    }

    public String getProductVersion(DBPNativeClientLocation location) {
        return MySQLDataSourceProvider.getFullServerVersion(location.getPath());
    }

    public static DBPNativeClientLocation getServerHome(String homeId) {
        return MySQLDataSourceProvider.findLocalClients().getOrDefault(homeId, (DBPNativeClientLocation)new LocalNativeClientLocation(homeId, homeId, homeId));
    }

    @NotNull
    private static synchronized Map<String, DBPNativeClientLocation> findLocalClients() {
        if (localClients != null) {
            return localClients;
        }
        localClients = RuntimeUtils.isWindows() ? MySQLDataSourceProvider.findWindowsLocalClients() : MySQLDataSourceProvider.findUnixLocalClients();
        return localClients;
    }

    @NotNull
    private static Map<String, DBPNativeClientLocation> findWindowsLocalClients() {
        HashMap<String, DBPNativeClientLocation> result = new HashMap<String, DBPNativeClientLocation>();
        String path = System.getenv("PATH");
        if (path != null) {
            String[] stringArray = path.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                File binFolder;
                String token = stringArray[n2];
                File mysqlFile = new File(CommonUtils.removeTrailingSlash((String)token), MySQLUtils.getMySQLConsoleBinaryName());
                if (mysqlFile.exists() && (binFolder = mysqlFile.getAbsoluteFile().getParentFile()).getName().equalsIgnoreCase("bin")) {
                    String homeId = CommonUtils.removeTrailingSlash((String)binFolder.getParentFile().getAbsolutePath());
                    log.trace((Object)"Found a MySQL location in PATH. token=%s mysqlFile=%s binFolder=%s homeId=%s".formatted(token, mysqlFile, binFolder, homeId));
                    result.put(homeId, (DBPNativeClientLocation)new LocalNativeClientLocation(homeId, homeId));
                }
                ++n2;
            }
        }
        MySQLDataSourceProvider.searchInWindowsRegistry(result, REGISTRY_ROOT_MYSQL_64, SERER_LOCATION_KEY);
        MySQLDataSourceProvider.searchInWindowsRegistry(result, REGISTRY_ROOT_MARIADB, INSTALLDIR_KEY);
        return result;
    }

    private static void searchInWindowsRegistry(Map<? super String, ? super DBPNativeClientLocation> locationMap, String registryRoot, String installDirKey) {
        try {
            LocalSystemRegistry.Registry registry = LocalSystemRegistry.getInstance();
            if (!registry.registryKeyExists("HKEY_LOCAL_MACHINE", registryRoot)) {
                return;
            }
            for (String homeKey : ArrayUtils.safeArray((Object[])registry.registryGetKeys("HKEY_LOCAL_MACHINE", registryRoot))) {
                for (Map.Entry entry : registry.registryGetValues("HKEY_LOCAL_MACHINE", registryRoot + "\\" + homeKey).entrySet()) {
                    String serverPath;
                    if (!installDirKey.equalsIgnoreCase((String)entry.getKey()) || !new File(serverPath = CommonUtils.removeTrailingSlash((String)CommonUtils.toString(entry.getValue())), "bin").exists()) continue;
                    log.trace((Object)"Found a MySQL location in registry. homeKey=%s entry.key=%s entry.value=%s serverPath=%s registryRoot=%s installDirKey=%s".formatted(homeKey, entry.getKey(), entry.getValue(), serverPath, registryRoot, installDirKey));
                    locationMap.put(serverPath, (DBPNativeClientLocation)new LocalNativeClientLocation(homeKey, serverPath));
                }
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error reading Windows registry", e);
        }
    }

    @NotNull
    private static Map<String, DBPNativeClientLocation> findUnixLocalClients() {
        return NativeClientLocationUtils.findLocalClientsOnUnix(List.of(), List.of("bin/mysql", "bin/mariadb"), p -> {
            File file = p.toFile();
            String absolutePath = file.getAbsolutePath();
            return new LocalNativeClientLocation(absolutePath, file, absolutePath);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getFullServerVersion(File path) {
        File binPath = path;
        File binSubfolder = new File(binPath, "bin");
        if (binSubfolder.exists()) {
            binPath = binSubfolder;
        }
        String cmd = new File(binPath, MySQLUtils.getMySQLConsoleBinaryName()).getAbsolutePath();
        try {
            Process p = Runtime.getRuntime().exec(new String[]{cmd, "-V"});
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String line;
                    int pos;
                    do {
                        if ((line = input.readLine()) == null) {
                            return null;
                        }
                        pos = line.indexOf("Distrib ");
                        if (pos == -1) continue;
                        int pos2 = line.indexOf(",", pos += 8);
                        String string = line.substring(pos, pos2);
                        return string;
                    } while ((pos = line.indexOf("Ver ")) == -1);
                    int pos2 = line.indexOf(" for ", pos += 4);
                    String string = line.substring(pos, pos2);
                    return string;
                }
                finally {
                    IOUtils.close((Closeable)input);
                }
            }
            finally {
                p.destroy();
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Error reading MySQL server version from " + cmd), (Throwable)ex);
        }
        return null;
    }
}

