/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.google.gson.Gson;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBInfoUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceAcquirer;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPDataSourceOriginExternal;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPDataSourceProviderSynchronizable;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPExclusiveResource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.access.DBAAuthModelExternal;
import org.jkiss.dbeaver.model.access.DBACredentialsProvider;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionEventType;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.connection.DBPDriverSubstitutionDescriptor;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.dpi.DPIController;
import org.jkiss.dbeaver.model.dpi.DPIDataSourceParameters;
import org.jkiss.dbeaver.model.dpi.DPIProcessController;
import org.jkiss.dbeaver.model.dpi.DPIProvider;
import org.jkiss.dbeaver.model.dpi.DPISession;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.SimpleExclusiveLock;
import org.jkiss.dbeaver.model.impl.data.DefaultValueHandler;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfigurator;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.net.DBWTunnel;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.rm.RMProjectType;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecret;
import org.jkiss.dbeaver.model.secret.DBSSecretBrowser;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.secret.DBSSecretObject;
import org.jkiss.dbeaver.model.secret.DBSSecretValue;
import org.jkiss.dbeaver.model.security.SMObjectType;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManagerBuffer;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourceHandlerDescriptor;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.registry.DataSourceOriginLazy;
import org.jkiss.dbeaver.registry.DataSourceOriginLocal;
import org.jkiss.dbeaver.registry.DataSourcePersistentRegistry;
import org.jkiss.dbeaver.registry.DataSourcePreferenceStore;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.DataSourceUtils;
import org.jkiss.dbeaver.registry.FilterMapping;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.formatter.DataFormatterProfile;
import org.jkiss.dbeaver.registry.internal.RegistryMessages;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataSourceDescriptor
implements DBPDataSourceContainer,
DBPImageProvider,
IAdaptable,
DBPStatefulObject,
DBPRefreshableObject,
DBSSecretObject {
    private static final Log log = Log.getLog(DataSourceDescriptor.class);
    public static final String CATEGORY_CONNECTIONS = "Connections";
    public static final String CATEGORY_SERVER = "Server";
    public static final String CATEGORY_DRIVER = "Driver";
    public static final String CATEGORY_DRIVER_FILES = "Driver Files";
    public static final String DATASOURCE_KEY_PREFIX = "/datasources/";
    @NotNull
    private final DBPDataSourceRegistry registry;
    @NotNull
    private final DBPDataSourceConfigurationStorage storage;
    @NotNull
    private DBPDataSourceOrigin origin;
    @NotNull
    private DBPDriver driver;
    @NotNull
    private final DBPDriver originalDriver;
    @Nullable
    private DBPDriverSubstitutionDescriptor driverSubstitution;
    @NotNull
    private DBPConnectionConfiguration connectionInfo;
    private DBPConnectionConfiguration resolvedConnectionInfo;
    @NotNull
    private String id;
    private String name;
    private String description;
    private boolean savePassword;
    private boolean sharedCredentials;
    private transient boolean originalShareCredentials;
    @Nullable
    private transient List<DBSSecretValue> availableSharedCredentials;
    @Nullable
    private transient DBSSecretValue selectedSharedCredentials;
    private boolean connectionReadOnly;
    private boolean forceUseSingleConnection;
    private List<DBPDataSourcePermission> connectionModifyRestrictions;
    private final Map<String, FilterMapping> filterMap = new HashMap<String, FilterMapping>();
    private DBDDataFormatterProfile formatterProfile;
    @Nullable
    private DBPNativeClientLocation clientHome;
    @Nullable
    private String lockPasswordHash;
    @Nullable
    private DataSourceFolder folder;
    @NotNull
    private final DataSourcePreferenceStore preferenceStore;
    @NotNull
    private final Map<String, String> tags;
    @NotNull
    private final Map<String, String> extensions;
    @Nullable
    private DBPDataSource dataSource;
    @Nullable
    private String lastConnectionError;
    private boolean temporary;
    private boolean hidden;
    private boolean template;
    private boolean dpiEnabled;
    @NotNull
    private DataSourceNavigatorSettings navigatorSettings;
    @NotNull
    private DBVModel virtualModel;
    private final boolean manageable;
    private boolean accessCheckRequired = true;
    private volatile boolean connectFailed = false;
    private volatile Date connectTime = null;
    private volatile boolean disposed = false;
    private volatile boolean connecting = false;
    private volatile boolean secretsResolved = false;
    private volatile boolean secretsContainsDatabaseCreds = false;
    private final List<DBRProcessDescriptor> childProcesses = new ArrayList<DBRProcessDescriptor>();
    private transient DBWNetworkHandler proxyHandler;
    private transient DBWTunnel tunnelHandler;
    private final List<DBPDataSourceTask> users = new ArrayList<DBPDataSourceTask>();
    private transient DPIProcessController dpiController;
    private final transient DBPExclusiveResource exclusiveLock = new SimpleExclusiveLock();

    public DataSourceDescriptor(@NotNull DBPDataSourceRegistry registry, @NotNull String id, @NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        this(registry, ((DataSourceRegistry)registry).getDefaultStorage(), DataSourceOriginLocal.INSTANCE, id, driver, connectionInfo);
    }

    public DataSourceDescriptor(@NotNull DBPDataSourceRegistry registry, @NotNull DBPDataSourceConfigurationStorage storage, @NotNull DBPDataSourceOrigin origin, @NotNull String id, @NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        this(registry, storage, origin, id, driver, driver, connectionInfo);
    }

    public DataSourceDescriptor(@NotNull DBPDataSourceRegistry registry, @NotNull DBPDataSourceConfigurationStorage storage, @NotNull DBPDataSourceOrigin origin, @NotNull String id, @NotNull DBPDriver originalDriver, @NotNull DBPDriver substitutedDriver, @NotNull DBPConnectionConfiguration connectionInfo) {
        this.registry = registry;
        this.storage = storage;
        this.origin = origin;
        this.manageable = storage.isDefault();
        this.id = id;
        this.originalDriver = originalDriver;
        this.driver = substitutedDriver;
        this.connectionInfo = connectionInfo;
        this.tags = new LinkedHashMap<String, String>();
        this.extensions = new LinkedHashMap<String, String>();
        this.preferenceStore = new DataSourcePreferenceStore(registry.getPreferenceStore(), this);
        this.virtualModel = new DBVModel((DBPDataSourceContainer)this);
        this.navigatorSettings = new DataSourceNavigatorSettings(DataSourceNavigatorSettings.getDefaultSettings());
        this.forceUseSingleConnection = this.driver.isSingleConnection();
    }

    public DataSourceDescriptor(@NotNull DataSourceDescriptor source, @NotNull DBPDataSourceRegistry registry) {
        this(source, registry, true);
    }

    public DataSourceDescriptor(@NotNull DataSourceDescriptor source, @NotNull DBPDataSourceRegistry registry, boolean setDefaultStorage) {
        this.registry = registry;
        this.storage = setDefaultStorage ? ((DataSourceRegistry)registry).getDefaultStorage() : source.storage;
        this.origin = source.origin;
        this.accessCheckRequired = this.manageable = setDefaultStorage && ((DataSourceRegistry)registry).getDefaultStorage().isDefault();
        this.id = source.id;
        this.name = source.name;
        this.description = source.description;
        this.savePassword = source.savePassword;
        this.originalShareCredentials = this.sharedCredentials = source.sharedCredentials;
        this.navigatorSettings = new DataSourceNavigatorSettings(source.navigatorSettings);
        this.connectionReadOnly = source.connectionReadOnly;
        this.forceUseSingleConnection = source.forceUseSingleConnection;
        this.driver = source.driver;
        this.originalDriver = source.originalDriver;
        this.driverSubstitution = source.driverSubstitution;
        this.clientHome = source.clientHome;
        this.connectionModifyRestrictions = source.connectionModifyRestrictions == null ? null : new ArrayList<DBPDataSourcePermission>(source.connectionModifyRestrictions);
        this.connectionInfo = new DBPConnectionConfiguration(source.connectionInfo);
        for (Map.Entry<String, FilterMapping> fe : source.filterMap.entrySet()) {
            this.filterMap.put(fe.getKey(), new FilterMapping(fe.getValue()));
        }
        this.lockPasswordHash = source.lockPasswordHash;
        if (source.getRegistry() == registry) {
            this.folder = source.folder;
        } else if (source.folder != null) {
            this.folder = (DataSourceFolder)registry.getFolder(source.folder.getFolderPath());
        }
        this.tags = new LinkedHashMap<String, String>(source.tags);
        this.extensions = new LinkedHashMap<String, String>(source.extensions);
        this.preferenceStore = new DataSourcePreferenceStore(this);
        this.preferenceStore.setProperties(source.preferenceStore.getProperties());
        this.preferenceStore.setDefaultProperties(source.preferenceStore.getDefaultProperties());
        this.formatterProfile = source.formatterProfile == null || source.formatterProfile.getProfileName().equals(source.getId()) ? null : new DataFormatterProfile(source.formatterProfile.getProfileName(), (DBPPreferenceStore)this.preferenceStore);
        this.virtualModel = new DBVModel((DBPDataSourceContainer)this, source.virtualModel);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.disposed) {
            log.warn((Object)"Dispose of already disposed data source");
            return;
        }
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            this.users.clear();
        }
        this.virtualModel.dispose();
        this.disposed = true;
    }

    @Property(name="ID", viewable=false, order=0)
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(@NotNull String id) {
        this.id = id;
    }

    @NotNull
    public DBPDriver getDriver() {
        return this.driver;
    }

    @Nullable
    public DBPDriverSubstitutionDescriptor getDriverSubstitution() {
        return this.driverSubstitution;
    }

    public void setDriverSubstitution(@Nullable DBPDriverSubstitutionDescriptor driverSubstitution) {
        this.driverSubstitution = driverSubstitution;
    }

    @NotNull
    public DBPDriver getOriginalDriver() {
        return this.originalDriver;
    }

    @NotNull
    public DBPDataSourceConfigurationStorage getConfigurationStorage() {
        return this.storage;
    }

    @Property(viewable=true, order=3)
    @NotNull
    public DBPDataSourceOrigin getOrigin() {
        if (this.origin instanceof DataSourceOriginLazy) {
            DBPDataSourceOrigin realOrigin;
            try {
                realOrigin = ((DataSourceOriginLazy)this.origin).resolveRealOrigin();
            }
            catch (DBException e) {
                log.debug((Object)"Error reading datasource origin", (Throwable)e);
                realOrigin = null;
            }
            if (realOrigin != null) {
                this.origin = realOrigin;
            } else {
                return DataSourceOriginLocal.INSTANCE;
            }
        }
        return this.origin;
    }

    @NotNull
    DBPDataSourceOrigin getOriginSource() {
        return this.origin;
    }

    public void setDriver(@NotNull DriverDescriptor driver) {
        this.driver = driver;
        this.forceUseSingleConnection = driver.isSingleConnection();
    }

    @NotNull
    public DBPConnectionConfiguration getConnectionConfiguration() {
        return this.connectionInfo;
    }

    public void setConnectionInfo(@NotNull DBPConnectionConfiguration connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    @NotNull
    public DBPConnectionConfiguration getActualConnectionConfiguration() {
        return this.resolvedConnectionInfo != null ? this.resolvedConnectionInfo : this.connectionInfo;
    }

    @NotNull
    public DataSourceNavigatorSettings getNavigatorSettings() {
        return this.navigatorSettings;
    }

    public void setNavigatorSettings(DBNBrowseSettings copyFrom) {
        this.navigatorSettings = new DataSourceNavigatorSettings(copyFrom);
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=2)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public boolean isCredentialsSaved() throws DBException {
        if (!this.getProject().isUseSecretStorage()) {
            return this.savePassword;
        }
        this.resolveSecretsIfNeeded();
        if (this.isSharedCredentials() && !this.isSharedCredentialsSelected()) {
            return false;
        }
        if (this.secretsResolved && this.secretsContainsDatabaseCreds) {
            return true;
        }
        if (this.savePassword) {
            DBAAuthCredentials authCreds = this.getConnectionConfiguration().getAuthModel().loadCredentials((DBPDataSourceContainer)this, this.getConnectionConfiguration());
            return authCreds.isComplete();
        }
        return false;
    }

    public boolean isSharedCredentials() {
        return this.sharedCredentials;
    }

    public void forceSetSharedCredentials(boolean sharedCredentials) {
        this.sharedCredentials = sharedCredentials;
        this.originalShareCredentials = sharedCredentials;
    }

    public void setSharedCredentials(boolean sharedCredentials) {
        this.sharedCredentials = sharedCredentials;
    }

    public boolean isConnectionReadOnly() {
        return this.connectionReadOnly;
    }

    public void setConnectionReadOnly(boolean connectionReadOnly) {
        this.connectionReadOnly = connectionReadOnly;
    }

    public boolean hasModifyPermission(DBPDataSourcePermission permission) {
        if ((permission == DBPDataSourcePermission.PERMISSION_EDIT_DATA || permission == DBPDataSourcePermission.PERMISSION_EDIT_METADATA) && this.connectionReadOnly) {
            return false;
        }
        if (CommonUtils.isEmpty(this.connectionModifyRestrictions)) {
            return this.getConnectionConfiguration().getConnectionType().hasModifyPermission(permission);
        }
        return !this.connectionModifyRestrictions.contains(permission);
    }

    public List<DBPDataSourcePermission> getModifyPermission() {
        if (CommonUtils.isEmpty(this.connectionModifyRestrictions)) {
            return Collections.emptyList();
        }
        return new ArrayList<DBPDataSourcePermission>(this.connectionModifyRestrictions);
    }

    public void setModifyPermissions(@Nullable Collection<DBPDataSourcePermission> permissions) {
        this.connectionModifyRestrictions = CommonUtils.isEmpty(permissions) ? null : new ArrayList<DBPDataSourcePermission>(permissions);
    }

    public boolean isDefaultAutoCommit() {
        if (this.connectionInfo.getBootstrap().getDefaultAutoCommit() != null) {
            return this.connectionInfo.getBootstrap().getDefaultAutoCommit();
        }
        return this.getConnectionConfiguration().getConnectionType().isAutocommit();
    }

    public void setDefaultAutoCommit(boolean autoCommit) {
        if (autoCommit == this.getConnectionConfiguration().getConnectionType().isAutocommit()) {
            this.connectionInfo.getBootstrap().setDefaultAutoCommit(null);
        } else {
            this.connectionInfo.getBootstrap().setDefaultAutoCommit(Boolean.valueOf(autoCommit));
        }
    }

    public void resetAllSecrets() {
        this.secretsResolved = false;
        this.secretsContainsDatabaseCreds = false;
        this.availableSharedCredentials = null;
        this.selectedSharedCredentials = null;
        if (this.sharedCredentials) {
            this.connectionInfo.setUserName(null);
            this.connectionInfo.setUserPassword(null);
        }
    }

    @Nullable
    public DBPTransactionIsolation getActiveTransactionsIsolation() {
        DBCTransactionManager txnManager;
        DBSInstance defaultInstance;
        if (this.dataSource != null && (defaultInstance = this.dataSource.getDefaultInstance()) != null && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)DBUtils.getDefaultContext((DBSObject)defaultInstance, (boolean)false))) != null) {
            try {
                return txnManager.getTransactionIsolation();
            }
            catch (DBCException e) {
                log.debug((Object)"Can't determine isolation level", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public Integer getDefaultTransactionsIsolation() {
        return this.connectionInfo.getBootstrap().getDefaultTransactionIsolation();
    }

    public void setDefaultTransactionsIsolation(@Nullable DBPTransactionIsolation isolationLevel) {
        if (isolationLevel == null) {
            this.connectionInfo.getBootstrap().setDefaultTransactionIsolation(null);
        } else {
            this.connectionInfo.getBootstrap().setDefaultTransactionIsolation(Integer.valueOf(isolationLevel.getCode()));
        }
    }

    public boolean isExtraMetadataReadEnabled() {
        return !this.preferenceStore.getBoolean("database.meta.disableAdditionalRead");
    }

    public Collection<FilterMapping> getObjectFilters() {
        return this.filterMap.values();
    }

    @Nullable
    public DBSObjectFilter getObjectFilter(Class<?> type, @Nullable DBSObject parentObject, boolean firstMatch) {
        FilterMapping filterMapping = this.getFilterMapping(type, parentObject, firstMatch);
        if (filterMapping != null) {
            return filterMapping.getFilter(parentObject, firstMatch);
        }
        return null;
    }

    @Nullable
    private FilterMapping getFilterMapping(@NotNull Class<?> type, @Nullable DBSObject parentObject, boolean firstMatch) {
        Class<?> testType;
        if (this.filterMap.isEmpty()) {
            return null;
        }
        Class<?>[] classArray = type.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            testType = classArray[n2];
            FilterMapping filterMapping = this.getTypeFilterMapping(parentObject, firstMatch, testType);
            if (filterMapping != null) {
                return filterMapping;
            }
            ++n2;
        }
        testType = type;
        while (testType != null) {
            FilterMapping filterMapping = this.getTypeFilterMapping(parentObject, firstMatch, testType);
            if (filterMapping != null) {
                return filterMapping;
            }
            testType = testType.getSuperclass();
        }
        return null;
    }

    private FilterMapping getTypeFilterMapping(@Nullable DBSObject parentObject, boolean firstMatch, Class<?> testType) {
        DBSObjectFilter filter;
        FilterMapping filterMapping = this.filterMap.get(testType.getName());
        if (filterMapping == null) {
            Class<?>[] classArray = testType.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> it = classArray[n2];
                filterMapping = this.filterMap.get(it.getName());
                if (filterMapping != null && (filter = filterMapping.getFilter(parentObject, firstMatch)) != null && (firstMatch || filter.isEnabled())) {
                    return filterMapping;
                }
                ++n2;
            }
        }
        if (filterMapping != null && (filter = filterMapping.getFilter(parentObject, firstMatch)) != null && (firstMatch || filter.isEnabled())) {
            return filterMapping;
        }
        return null;
    }

    public void setObjectFilter(Class<?> type, DBSObject parentObject, DBSObjectFilter filter) {
        FilterMapping filterMapping = this.getFilterMapping(type, parentObject, true);
        if (filterMapping != null) {
            if (parentObject == null) {
                filterMapping.defaultFilter = filter;
            } else {
                filterMapping.customFilters.put(FilterMapping.getFilterContainerUniqueID(parentObject), filter);
            }
        }
        this.updateObjectFilter(type.getName(), parentObject == null ? null : FilterMapping.getFilterContainerUniqueID(parentObject), filter);
    }

    void clearFilters() {
        this.filterMap.clear();
    }

    void updateObjectFilter(String typeName, @Nullable String objectID, DBSObjectFilter filter) {
        FilterMapping filterMapping = this.filterMap.get(typeName);
        if (filterMapping == null) {
            filterMapping = new FilterMapping(typeName);
            this.filterMap.put(typeName, filterMapping);
        }
        if (objectID == null) {
            filterMapping.defaultFilter = filter;
        } else {
            filterMapping.customFilters.put(objectID, filter);
        }
    }

    @NotNull
    public DBVModel getVirtualModel() {
        return this.virtualModel;
    }

    public boolean hasSharedVirtualModel() {
        return !CommonUtils.equalObjects((Object)this.virtualModel.getId(), (Object)this.getId());
    }

    public void setVirtualModel(@NotNull DBVModel virtualModel) {
        this.virtualModel.dispose();
        if (virtualModel.getId().equals(this.getId())) {
            this.virtualModel = virtualModel;
            this.virtualModel.setDataSourceContainer((DBPDataSourceContainer)this);
        } else {
            this.virtualModel = new DBVModel((DBPDataSourceContainer)this, virtualModel);
            this.virtualModel.setId(virtualModel.getId());
        }
    }

    public DBPNativeClientLocation getClientHome() {
        if (this.clientHome == null && !CommonUtils.isEmpty((String)this.connectionInfo.getClientHomeId())) {
            this.clientHome = (DBPNativeClientLocation)DBUtils.findObject((Collection)this.driver.getNativeClientLocations(), (String)this.connectionInfo.getClientHomeId());
        }
        return this.clientHome;
    }

    @NotNull
    public DBWNetworkHandler[] getActiveNetworkHandlers() {
        DBWNetworkHandler[] dBWNetworkHandlerArray;
        if (this.proxyHandler == null && this.tunnelHandler == null) {
            return new DBWNetworkHandler[0];
        }
        if (this.proxyHandler == null) {
            DBWNetworkHandler[] dBWNetworkHandlerArray2 = new DBWNetworkHandler[1];
            dBWNetworkHandlerArray = dBWNetworkHandlerArray2;
            dBWNetworkHandlerArray2[0] = this.tunnelHandler;
        } else if (this.tunnelHandler == null) {
            DBWNetworkHandler[] dBWNetworkHandlerArray3 = new DBWNetworkHandler[1];
            dBWNetworkHandlerArray = dBWNetworkHandlerArray3;
            dBWNetworkHandlerArray3[0] = this.proxyHandler;
        } else {
            DBWNetworkHandler[] dBWNetworkHandlerArray4 = new DBWNetworkHandler[2];
            dBWNetworkHandlerArray4[0] = this.proxyHandler;
            dBWNetworkHandlerArray = dBWNetworkHandlerArray4;
            dBWNetworkHandlerArray4[1] = this.tunnelHandler;
        }
        return dBWNetworkHandlerArray;
    }

    @NotNull
    DBPDataSourceConfigurationStorage getStorage() {
        return this.storage;
    }

    public boolean isDetached() {
        return this.hidden || this.temporary;
    }

    public boolean isManageable() {
        return this.manageable;
    }

    public boolean isAccessCheckRequired() {
        return this.isManageable() && this.accessCheckRequired;
    }

    public void setAccessCheckRequired(boolean accessCheckRequired) {
        this.accessCheckRequired = accessCheckRequired;
    }

    public boolean isProvided() {
        return !this.storage.isDefault();
    }

    public boolean isExternallyProvided() {
        return this.getOrigin().isDynamic();
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(boolean template) {
        this.template = template;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public DBSObject getParentObject() {
        return null;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.dataSource instanceof DBPRefreshableObject) {
            this.dataSource = (DBPDataSource)((DBPRefreshableObject)this.dataSource).refreshObject(monitor);
        } else {
            this.reconnect(monitor, false);
        }
        this.getRegistry().notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)this));
        return this;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Date getConnectTime() {
        return this.connectTime;
    }

    @NotNull
    public SQLDialectMetadata getScriptDialect() {
        return this.driver.getScriptDialect();
    }

    public boolean isLocked() {
        return !CommonUtils.isEmpty((String)this.lockPasswordHash);
    }

    @Nullable
    public String getLockPasswordHash() {
        return this.lockPasswordHash;
    }

    void setLockPasswordHash(@Nullable String lockPasswordHash) {
        this.lockPasswordHash = lockPasswordHash;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @Nullable
    public DataSourceFolder getFolder() {
        return this.folder;
    }

    public void setFolder(@Nullable DBPDataSourceFolder folder) {
        this.folder = (DataSourceFolder)folder;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public DBPDataSourceRegistry getRegistry() {
        return this.registry;
    }

    @NotNull
    public DBPProject getProject() {
        return this.registry.getProject();
    }

    public boolean persistConfiguration() {
        try {
            this.registry.updateDataSource((DBPDataSourceContainer)this);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Datasource update error", "Error updating datasource", (Throwable)e);
            return false;
        }
        Throwable lastError = this.registry.getLastError();
        if (lastError != null) {
            DBWorkbench.getPlatformUI().showError("Save error", "Error saving datasource configuration", lastError);
            return false;
        }
        return true;
    }

    boolean persistSecretIfNeeded(boolean force, boolean isNewDataSource) throws DBException {
        DBSSecretController secretController;
        if (this.isDetached()) {
            return false;
        }
        if (this.shouldRemoveExistsSecrets()) {
            secretController = DBSSecretController.getProjectSecretController((DBPProject)this.getProject());
            secretController.deleteObjectSecrets((DBSSecretObject)this);
            this.originalShareCredentials = this.isSharedCredentials();
        }
        if (this.secretsResolved || force && this.getProject().isUseSecretStorage()) {
            secretController = DBSSecretController.getProjectSecretController((DBPProject)this.getProject());
            this.persistSecrets(secretController, isNewDataSource);
        }
        return true;
    }

    void removeSecretIfNeeded() throws DBException {
        if (this.getProject().isUseSecretStorage()) {
            DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)this.getProject());
            secretController.deleteObjectSecrets((DBSSecretObject)this);
        }
    }

    public void persistSecrets(DBSSecretController secretController) throws DBException {
        this.persistSecrets(secretController, false);
    }

    void persistSecrets(DBSSecretController secretController, boolean isNewDataSource) throws DBException {
        if (!CommonUtils.isBitSet((long)secretController.getSupportedFeatures(), (long)(this.isSharedCredentials() ? 8L : 2L))) {
            log.debug((Object)"Secret save is disabled in secret controller. Auth settings won't be saved.");
            return;
        }
        String secret = this.saveToSecret();
        if (!this.isSharedCredentials()) {
            if (!isNewDataSource || secret != null) {
                secretController.setPrivateSecretValue((DBSSecretObject)this, new DBSSecretValue(this.getSecretValueId(), "", secret));
            }
            this.secretsResolved = true;
        } else if (this.selectedSharedCredentials != null) {
            String subjectId = DataSourceUtils.getSubjectFromSecret(this.selectedSharedCredentials);
            DBSSecretValue selectedSharedCredentialsCopy = this.selectedSharedCredentials;
            selectedSharedCredentialsCopy.setValue(secret);
            try {
                secretController.setSubjectSecretValue(subjectId, (DBSSecretObject)this, new DBSSecretValue(subjectId, this.getSecretValueId(), "", secret));
                this.resetAllSecrets();
                this.setSelectedSharedCredentials(selectedSharedCredentialsCopy);
            }
            catch (DBException e) {
                throw new DBException("Cannot set team '" + subjectId + "' credentials: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @NotNull
    public synchronized List<DBSSecretValue> listSharedCredentials() throws DBException {
        if (!this.isSharedCredentials()) {
            return List.of();
        }
        this.resetAllSecrets();
        this.resolveSecretsIfNeeded();
        if (this.availableSharedCredentials == null) {
            this.availableSharedCredentials = List.of();
        }
        return this.availableSharedCredentials;
    }

    private synchronized List<DBSSecretValue> listSharedCredentialFromCache() throws DBException {
        if (this.availableSharedCredentials != null) {
            return this.availableSharedCredentials;
        }
        return this.listSharedCredentials();
    }

    @Nullable
    public DBSSecretValue getSelectedSharedCredentials() {
        return this.selectedSharedCredentials;
    }

    public synchronized void setSelectedSharedCredentials(@NotNull DBSSecretValue secretValue) {
        this.selectedSharedCredentials = secretValue;
        this.loadFromSecret(this.selectedSharedCredentials.getValue());
    }

    public synchronized boolean isSharedCredentialsSelected() {
        return this.selectedSharedCredentials != null;
    }

    private boolean shouldRemoveExistsSecrets() {
        return this.isSharedCredentials() ^ this.originalShareCredentials;
    }

    public void resolveSecrets(DBSSecretController secretController) throws DBException {
        try {
            if (!this.isSharedCredentials()) {
                String secretValue = secretController.getPrivateSecretValue(this.getSecretValueId());
                this.loadFromSecret(secretValue);
                if (secretValue == null && !DBWorkbench.isDistributed()) {
                    this.loadFromLegacySecret(secretController);
                }
            } else {
                this.availableSharedCredentials = secretController.discoverCurrentUserSecrets((DBSSecretObject)this);
                if (this.availableSharedCredentials.size() == 1) {
                    this.setSelectedSharedCredentials(this.availableSharedCredentials.get(0));
                }
            }
        }
        finally {
            this.secretsResolved = true;
        }
    }

    public boolean isConnected() {
        return this.dataSource != null && !this.connecting;
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    @Nullable
    public String getConnectionError() {
        return this.lastConnectionError;
    }

    public boolean connect(DBRProgressMonitor monitor, boolean initialize, boolean reflect) throws DBException {
        if (this.connecting) {
            log.debug((Object)"Can't connect - connect/disconnect is in progress");
            return false;
        }
        if (this.isConnected()) {
            log.debug((Object)"Can't connect - already connected");
            return false;
        }
        boolean detachedProcess = DBWorkbench.getPlatform().getApplication().isDetachedProcess();
        boolean succeeded = false;
        this.connecting = true;
        try {
            this.getDriver().downloadRequiredDependencies(monitor);
            if (this.isDetachedProcessEnabled() && !detachedProcess) {
                succeeded = this.openDetachedConnection(monitor);
            }
            if (!succeeded) {
                if (!detachedProcess) {
                    this.updateDataSourceObject(succeeded, DBPEvent.Action.BEFORE_CONNECT);
                }
                try {
                    succeeded = this.connect0(monitor, initialize, reflect);
                }
                finally {
                    if (!detachedProcess) {
                        this.updateDataSourceObject(succeeded, DBPEvent.Action.AFTER_CONNECT);
                    }
                }
            }
            boolean bl = succeeded;
            return bl;
        }
        finally {
            this.connecting = false;
            if (!detachedProcess) {
                this.updateDataSourceObject(succeeded, DBPEvent.Action.OBJECT_UPDATE);
            }
        }
    }

    public boolean isDetachedProcessEnabled() {
        return this.dpiEnabled;
    }

    public void setDetachedProcessEnabled(boolean enabled) {
        this.dpiEnabled = enabled;
    }

    /*
     * WARNING - void declaration
     */
    private boolean openDetachedConnection(DBRProgressMonitor monitor) {
        void persistentRegistry;
        DPIProvider provider;
        block5: {
            try {
                provider = (DPIProvider)GeneralUtils.adapt((Object)this, DPIProvider.class);
                if (provider != null) break block5;
                log.debug((Object)"DPI provider not available");
                return false;
            }
            catch (Exception e) {
                log.debug((Object)"Error starting DPI child process", (Throwable)e);
                this.closeDetachedProcess();
                return false;
            }
        }
        this.dpiController = provider.detachDatabaseProcess(monitor, (DBPDataSourceContainer)this);
        LinkedHashMap credentials = new LinkedHashMap();
        DPIController dpiClient = this.dpiController.getClient();
        DPISession session = dpiClient.openSession();
        if (session == null) {
            throw new IllegalStateException("No session");
        }
        log.debug((Object)("New DPI session: " + session.getSessionId()));
        DBPDataSourceRegistry dBPDataSourceRegistry = this.getRegistry();
        if (!(dBPDataSourceRegistry instanceof DataSourcePersistentRegistry)) {
            throw new IllegalStateException("Illegal registry " + String.valueOf(this.getRegistry().getClass()));
        }
        DataSourcePersistentRegistry dataSourcePersistentRegistry = (DataSourcePersistentRegistry)dBPDataSourceRegistry;
        DataSourceConfigurationManagerBuffer buffer = new DataSourceConfigurationManagerBuffer();
        persistentRegistry.saveConfigurationToManager((DBRProgressMonitor)new VoidProgressMonitor(), buffer, dsc -> dsc.equals(this));
        String[] driverLibraries = (String[])this.getDriver().getDriverLibraries().stream().map(DBPDriverLibrary::getLocalFile).filter(Objects::nonNull).map(path -> path.toAbsolutePath().toString()).toArray(String[]::new);
        this.dataSource = dpiClient.openDataSource(new DPIDataSourceParameters(session.getSessionId(), new String(buffer.getData(), StandardCharsets.UTF_8), driverLibraries, credentials));
        log.debug((Object)("Opened data source: " + String.valueOf(this.dataSource)));
        return true;
    }

    private void closeDetachedProcess() {
        if (this.dpiController != null) {
            this.dpiController.close();
            this.dpiController = null;
        }
    }

    private boolean connect0(DBRProgressMonitor monitor, boolean initialize, boolean reflect) throws DBException {
        DBSSecretController secretController = null;
        log.debug((Object)("Connect with '" + this.getName() + "' (" + this.getId() + ")"));
        if (this.getProject().isUseSecretStorage()) {
            secretController = DBSSecretController.getProjectSecretController((DBPProject)this.getProject());
        }
        this.resolveSecretsIfNeeded();
        if (this.isSharedCredentials() && !this.isSharedCredentialsSelected()) {
            List<DBSSecretValue> sharedCreds = this.listSharedCredentialFromCache();
            if (!CommonUtils.isEmpty(sharedCreds)) {
                log.debug((Object)("Shared credentials not selected - use first one: " + sharedCreds.get(0).getDisplayName()));
                this.setSelectedSharedCredentials(sharedCreds.get(0));
                monitor.subTask("Use first available shared credentials");
            } else {
                log.debug((Object)"Shared credentials not found - attempt to connect as is");
            }
        }
        this.resolvedConnectionInfo = new DBPConnectionConfiguration(this.connectionInfo);
        this.lastConnectionError = null;
        try {
            this.processEvents(monitor, DBPConnectionEventType.BEFORE_CONNECT);
            boolean authProvidedFromOrigin = false;
            DBPDataSourceOrigin dsOrigin = this.getOrigin();
            if (dsOrigin instanceof DBACredentialsProvider) {
                DBACredentialsProvider cp = (DBACredentialsProvider)dsOrigin;
                String originID = dsOrigin.getType() + (String)(dsOrigin.getSubType() == null ? "" : "/" + dsOrigin.getSubType());
                monitor.beginTask("Read auth parameters from " + originID, 1);
                try {
                    authProvidedFromOrigin = cp.provideAuthParameters(monitor, (DBPDataSourceContainer)this, this.resolvedConnectionInfo);
                    if (authProvidedFromOrigin) {
                        log.debug((Object)("Auth parameters were provided by origin " + originID));
                    }
                }
                finally {
                    monitor.done();
                }
            }
            if (!authProvidedFromOrigin) {
                boolean authProvidedFromCredProvider = true;
                DBACredentialsProvider authProvider = this.registry.getAuthCredentialsProvider();
                if (authProvider != null) {
                    authProvidedFromCredProvider = authProvider.provideAuthParameters(monitor, (DBPDataSourceContainer)this, this.resolvedConnectionInfo);
                } else if (!this.isSavePassword() && !this.getDriver().isAnonymousAccess()) {
                    authProvidedFromCredProvider = DataSourceDescriptor.askForPassword(this, null, DBWTunnel.AuthCredentials.CREDENTIALS);
                }
                if (!authProvidedFromCredProvider) {
                    return false;
                }
            }
            this.resolveConnectVariables(secretController);
            this.proxyHandler = null;
            this.tunnelHandler = null;
            DBWHandlerConfiguration tunnelConfiguration = null;
            DBWHandlerConfiguration proxyConfiguration = null;
            for (DBWHandlerConfiguration handler : this.resolvedConnectionInfo.getHandlers()) {
                if (!handler.isEnabled()) continue;
                handler.setDataSource((DBPDataSourceContainer)this);
                if (handler.getType() == DBWHandlerType.TUNNEL) {
                    tunnelConfiguration = handler;
                    continue;
                }
                if (handler.getType() != DBWHandlerType.PROXY) continue;
                proxyConfiguration = handler;
            }
            String target = this.getActualConnectionConfiguration().getUrl();
            if (CommonUtils.isEmpty((String)target)) {
                target = this.getName();
            }
            monitor.beginTask("Connect to " + target, tunnelConfiguration != null ? 3 : 2);
            Object dsLock = this.exclusiveLock.acquireExclusiveLock();
            try {
                if (proxyConfiguration != null) {
                    monitor.subTask("Initialize proxy");
                    this.proxyHandler = proxyConfiguration.createHandler(DBWNetworkHandler.class);
                    this.proxyHandler.initializeHandler(monitor, proxyConfiguration, this.resolvedConnectionInfo);
                }
                if (tunnelConfiguration != null) {
                    block52: {
                        monitor.subTask("Initialize tunnel");
                        this.tunnelHandler = (DBWTunnel)tunnelConfiguration.createHandler(DBWTunnel.class);
                        try {
                            DBWTunnel.AuthCredentials rc;
                            if (tunnelConfiguration.isSavePassword() || (rc = this.tunnelHandler.getRequiredCredentials(tunnelConfiguration)) == DBWTunnel.AuthCredentials.NONE || DataSourceDescriptor.askForPassword(this, tunnelConfiguration, rc)) break block52;
                            this.tunnelHandler = null;
                            return false;
                        }
                        catch (Exception e) {
                            throw new DBCException("Can't initialize tunnel", (Throwable)e);
                        }
                    }
                    DBExecUtils.startContextInitiation((DBPDataSourceContainer)this);
                    try {
                        DBPDataSourceProvider dataSourceProvider = this.driver.getDataSourceProvider();
                        if (dataSourceProvider instanceof DBWHandlerConfigurator) {
                            ((DBWHandlerConfigurator)dataSourceProvider).activateHandler((DBWNetworkHandler)this.tunnelHandler, this.resolvedConnectionInfo, tunnelConfiguration);
                        }
                        this.resolvedConnectionInfo = this.tunnelHandler.initializeHandler(monitor, tunnelConfiguration, this.resolvedConnectionInfo);
                    }
                    finally {
                        DBExecUtils.finishContextInitiation((DBPDataSourceContainer)this);
                    }
                    monitor.worked(1);
                }
                monitor.subTask("Connect to data source");
                this.openDataSource(monitor, initialize);
                try {
                    log.debug((Object)("Connected (" + this.getId() + ", " + this.getPropertyDriver() + ")"));
                }
                catch (Throwable throwable) {
                    log.debug((Object)("Connected (" + this.getId() + ", driver unknown)"));
                }
                this.connectFailed = false;
            }
            finally {
                this.exclusiveLock.releaseExclusiveLock(dsLock);
            }
            this.processEvents(monitor, DBPConnectionEventType.AFTER_CONNECT);
            return true;
        }
        catch (Throwable e) {
            block58: {
                block56: {
                    this.terminateChildProcesses();
                    this.lastConnectionError = e.getMessage();
                    if (this.dataSource != null) {
                        try {
                            try {
                                this.dataSource.shutdown(monitor);
                            }
                            catch (Exception e1) {
                                log.debug((Object)"Error closing failed connection", (Throwable)e1);
                                this.dataSource = null;
                                break block56;
                            }
                        }
                        catch (Throwable throwable) {
                            this.dataSource = null;
                            throw throwable;
                        }
                        this.dataSource = null;
                    }
                }
                if (this.tunnelHandler != null) {
                    try {
                        try {
                            this.tunnelHandler.closeTunnel(monitor);
                        }
                        catch (Exception e1) {
                            log.error((Object)"Error closing tunnel", (Throwable)e1);
                            this.tunnelHandler = null;
                            break block58;
                        }
                    }
                    catch (Throwable throwable) {
                        this.tunnelHandler = null;
                        throw throwable;
                    }
                    this.tunnelHandler = null;
                }
            }
            if (this.isSharedCredentials()) {
                this.resetAllSecrets();
            }
            this.proxyHandler = null;
            this.connectFailed = true;
            if (e instanceof DBException) {
                throw (DBException)e;
            }
            throw new DBException("Internal error connecting to " + this.getName(), e);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateChildProcesses() {
        List<DBRProcessDescriptor> list = this.childProcesses;
        synchronized (list) {
            Iterator<DBRProcessDescriptor> iter = this.childProcesses.iterator();
            while (iter.hasNext()) {
                DBRProcessDescriptor process = iter.next();
                if (process.isRunning() && process.getCommand().isTerminateAtDisconnect()) {
                    process.terminate();
                }
                iter.remove();
            }
        }
    }

    private void resolveConnectVariables(DBSSecretController secretController) throws DBException {
        if (this.preferenceStore.getBoolean("database.connect.processEnvVars") || !CommonUtils.isEmpty((String)this.resolvedConnectionInfo.getConfigProfileName())) {
            DBWNetworkProfile profile;
            if (!CommonUtils.isEmpty((String)this.resolvedConnectionInfo.getConfigProfileName()) && (profile = this.registry.getNetworkProfile(this.resolvedConnectionInfo.getConfigProfileSource(), this.resolvedConnectionInfo.getConfigProfileName())) != null) {
                if (secretController != null) {
                    profile.resolveSecrets(secretController);
                }
                for (DBWHandlerConfiguration handlerCfg : profile.getConfigurations()) {
                    if (!handlerCfg.isEnabled()) continue;
                    this.resolvedConnectionInfo.updateHandler(new DBWHandlerConfiguration(handlerCfg));
                }
            }
            if (this.preferenceStore.getBoolean("database.connect.processEnvVars")) {
                DataSourceVariableResolver variableResolver = new DataSourceVariableResolver((DBPDataSourceContainer)this, this.resolvedConnectionInfo);
                this.resolvedConnectionInfo.resolveDynamicVariables((IVariableResolver)variableResolver);
            }
        }
    }

    private void resolveSecretsIfNeeded() throws DBException {
        if (this.secretsResolved || !this.getProject().isUseSecretStorage()) {
            return;
        }
        if (this.registry.getDataSource(this.getId()) == null) {
            return;
        }
        DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)this.getProject());
        this.resolveSecrets(secretController);
    }

    public void openDataSource(DBRProgressMonitor monitor, boolean initialize) throws DBException {
        DBPDataSourceProvider provider = this.driver.getDataSourceProvider();
        DBPDataSourceProviderSynchronizable providerSynchronizable = (DBPDataSourceProviderSynchronizable)GeneralUtils.adapt((Object)provider, DBPDataSourceProviderSynchronizable.class);
        if (providerSynchronizable != null && providerSynchronizable.isSynchronizationEnabled((DBPDataSourceContainer)this)) {
            try {
                try {
                    monitor.beginTask("Synchronize local data source", 1);
                    providerSynchronizable.syncLocalDataSource(monitor, (DBPDataSourceContainer)this);
                    monitor.worked(1);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(RegistryMessages.dialog_data_source_synchronization_fail_title, NLS.bind((String)RegistryMessages.dialog_data_source_synchronization_fail_local_message, (Object)this.getName()), (Throwable)e);
                    throw e;
                }
            }
            finally {
                monitor.done();
            }
        }
        this.dataSource = provider.openDataSource(monitor, (DBPDataSourceContainer)this);
        this.connectTime = new Date();
        monitor.worked(1);
        if (initialize) {
            monitor.subTask("Initialize data source");
            boolean revertMetaToManualCommit = false;
            Throwable throwable = null;
            Object var7_10 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read server information");){
                DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
                if (txnManager != null && !txnManager.isAutoCommit()) {
                    txnManager.setAutoCommit(monitor, true);
                    revertMetaToManualCommit = true;
                }
                try {
                    this.dataSource.initialize(monitor);
                    this.dataSource.getSQLDialect().afterDataSourceInitialization(this.dataSource);
                }
                catch (Throwable e) {
                    log.error((Object)"Error initializing datasource", e);
                    throw e;
                }
                if (revertMetaToManualCommit) {
                    txnManager.setAutoCommit(monitor, false);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void processEvents(DBRProgressMonitor monitor, DBPConnectionEventType eventType) throws DBException {
        DBPConnectionConfiguration info = this.getActualConnectionConfiguration();
        DBRShellCommand command = info.getEvent(eventType);
        if (command != null && command.isEnabled()) {
            final DBRProcessDescriptor processDescriptor = new DBRProcessDescriptor(command, this.getVariablesResolver(true));
            monitor.subTask("Execute process " + processDescriptor.getName());
            DBWorkbench.getPlatformUI().executeProcess(processDescriptor);
            new AbstractJob(processDescriptor.getName() + ": output reader"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        String output = processDescriptor.dumpErrors();
                        log.debug((Object)("Process error output:\n" + output));
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
            if (command.isWaitProcessFinish()) {
                int resultCode = command.getWaitProcessTimeoutMs() >= 0 ? processDescriptor.waitFor(command.getWaitProcessTimeoutMs()) : processDescriptor.waitFor();
                log.debug((Object)(processDescriptor.getName() + " result code: " + resultCode));
            }
            this.addChildProcess(processDescriptor);
        }
        for (DataSourceHandlerDescriptor handlerDesc : DataSourceProviderRegistry.getInstance().getDataSourceHandlers()) {
            switch (eventType) {
                case BEFORE_CONNECT: {
                    handlerDesc.getInstance().beforeConnect(monitor, (DBPDataSourceContainer)this);
                    break;
                }
                case AFTER_DISCONNECT: {
                    handlerDesc.getInstance().beforeDisconnect(monitor, (DBPDataSourceContainer)this);
                }
            }
        }
    }

    public boolean disconnect(DBRProgressMonitor monitor) {
        return this.disconnect(monitor, true);
    }

    private boolean disconnect(DBRProgressMonitor monitor, boolean reflect) {
        if (this.dataSource == null) {
            log.error((Object)"Datasource is not connected");
            return true;
        }
        if (this.connecting) {
            log.error((Object)"Connect/disconnect is in progress");
            return false;
        }
        this.connecting = true;
        this.releaseDataSourceUsers(monitor);
        try {
            if (this.dpiController != null) {
                this.closeDetachedProcess();
                return true;
            }
            monitor.beginTask("Disconnect from '" + this.getName() + "'", 5 + this.dataSource.getAvailableInstances().size());
            this.processEvents(monitor, DBPConnectionEventType.BEFORE_DISCONNECT);
            monitor.worked(1);
            DBPDataSourceProvider provider = this.driver.getDataSourceProvider();
            DBPDataSourceProviderSynchronizable providerSynchronizable = (DBPDataSourceProviderSynchronizable)GeneralUtils.adapt((Object)provider, DBPDataSourceProviderSynchronizable.class);
            if (providerSynchronizable != null && providerSynchronizable.isSynchronizationEnabled((DBPDataSourceContainer)this) && !providerSynchronizable.isLocalDataSourceSynchronized(monitor, (DBPDataSourceContainer)this)) {
                try {
                    try {
                        monitor.beginTask("Synchronize remote data source", 1);
                        providerSynchronizable.syncRemoteDataSource(monitor, (DBPDataSourceContainer)this);
                        monitor.worked(1);
                    }
                    catch (DBException e) {
                        DBWorkbench.getPlatformUI().showError(RegistryMessages.dialog_data_source_synchronization_fail_title, NLS.bind((String)RegistryMessages.dialog_data_source_synchronization_fail_remote_message, (Object)this.dataSource.getName()), (Throwable)e);
                        throw e;
                    }
                }
                finally {
                    monitor.done();
                }
            }
            monitor.subTask("Close connection");
            if (this.dataSource != null) {
                this.dataSource.shutdown(monitor);
            }
            monitor.worked(1);
            if (this.tunnelHandler != null) {
                monitor.subTask("Close tunnel");
                try {
                    this.tunnelHandler.closeTunnel(monitor);
                }
                catch (Throwable e) {
                    log.error((Object)"Error closing tunnel", e);
                }
            }
            monitor.worked(1);
            this.proxyHandler = null;
            this.processEvents(monitor, DBPConnectionEventType.AFTER_DISCONNECT);
            monitor.worked(1);
            monitor.done();
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error during datasource disconnect", (Throwable)e);
            return false;
        }
        finally {
            this.terminateChildProcesses();
            this.dataSource = null;
            this.resolvedConnectionInfo = null;
            this.resetAllSecrets();
            this.connectTime = null;
            if (reflect) {
                this.updateDataSourceObject(false, DBPEvent.Action.OBJECT_UPDATE);
            }
            this.connecting = false;
            log.debug((Object)("Disconnected (" + this.getId() + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDataSourceUsers(DBRProgressMonitor monitor) {
        ArrayList<DBPDataSourceTask> usersStamp;
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            usersStamp = new ArrayList<DBPDataSourceTask>(this.users);
        }
        int jobCount = 0;
        for (DBPDataSourceTask user : usersStamp) {
            if (user instanceof Job) {
                ++jobCount;
            }
            if (!(user instanceof DBPDataSourceAcquirer)) continue;
            ((DBPDataSourceAcquirer)user).beforeDisconnect();
        }
        if (jobCount > 0) {
            monitor.beginTask("Waiting for all active tasks to finish", jobCount);
            for (DBPDataSourceTask user : usersStamp) {
                if (!(user instanceof Job)) continue;
                Job job = (Job)user;
                monitor.subTask("Stop '" + job.getName() + "'");
                if (job.getState() == 4) {
                    job.cancel();
                    try {
                        int i = 0;
                        while (i < 30) {
                            Thread.sleep(100L);
                            if (job.getState() == 4) {
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                monitor.worked(1);
            }
            monitor.done();
        }
    }

    public boolean reconnect(DBRProgressMonitor monitor) throws DBException {
        return this.reconnect(monitor, true);
    }

    public boolean reconnect(DBRProgressMonitor monitor, boolean reflect) throws DBException {
        if (this.connecting) {
            log.debug((Object)"Can't reconnect - connect/disconnect is in progress");
            return false;
        }
        if (this.isConnected() && !this.disconnect(monitor, reflect)) {
            return false;
        }
        return this.connect(monitor, true, reflect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DBPDataSourceTask> getTasks() {
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            return new ArrayList<DBPDataSourceTask>(this.users);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(DBPDataSourceTask user) {
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            if (this.users.contains(user)) {
                log.warn((Object)("Datasource user '" + String.valueOf(user) + "' already registered in datasource '" + this.getName() + "'"));
            } else {
                this.users.add(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(DBPDataSourceTask user) {
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            if (!this.users.remove(user) && !this.isDisposed()) {
                log.warn((Object)("Datasource user '" + String.valueOf(user) + "' is not registered in datasource '" + this.getName() + "'"));
            }
        }
    }

    public void fireEvent(DBPEvent event) {
        this.registry.notifyDataSourceListeners(event);
    }

    public Map<String, String> getTags() {
        return new LinkedHashMap<String, String>(this.tags);
    }

    public void setTags(Map<String, String> tags) {
        this.tags.clear();
        this.tags.putAll(tags);
    }

    public String getTagValue(String tagName) {
        return this.tags.get(tagName);
    }

    public void setTagValue(String tagName, String tagValue) {
        this.tags.put(tagName, tagValue);
    }

    @Nullable
    public String getExtension(@NotNull String name) {
        return this.extensions.get(name);
    }

    public void setExtension(@NotNull String name, @Nullable String value) {
        if (value == null) {
            this.extensions.remove(name);
        } else {
            this.extensions.put(name, value);
        }
    }

    @NotNull
    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, String> extensions) {
        this.extensions.clear();
        this.extensions.putAll(extensions);
    }

    public DBDDataFormatterProfile getDataFormatterProfile() {
        if (this.formatterProfile == null) {
            this.formatterProfile = new DataFormatterProfile(this.getId(), (DBPPreferenceStore)this.preferenceStore);
        }
        return this.formatterProfile;
    }

    public boolean isUseNativeDateTimeFormat() {
        return this.getPreferenceStore().getBoolean("resultset.format.datetime.native");
    }

    public boolean isUseNativeNumericFormat() {
        return this.getPreferenceStore().getBoolean("resultset.format.numeric.native");
    }

    public boolean isUseScientificNumericFormat() {
        return this.getPreferenceStore().getBoolean("resultset.format.numeric.scientific");
    }

    @NotNull
    public DBDValueHandler getDefaultValueHandler() {
        if (this.dataSource instanceof DBDFormatSettings) {
            return ((DBDFormatSettings)this.dataSource).getDefaultValueHandler();
        }
        return DefaultValueHandler.INSTANCE;
    }

    @NotNull
    public DataSourcePreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void resetPassword() {
        this.connectionInfo.setUserPassword(null);
        ObjectPropertyDescriptor.extractAnnotations(null, (Class)ObjectPropertyDescriptor.getObjectClass((Object)this.connectionInfo.getAuthModel().createCredentials()), (o, p) -> true, null).stream().filter(ObjectPropertyDescriptor::isPassword).forEach(passwordProperty -> this.connectionInfo.setAuthProperty(passwordProperty.getKeyName(), null));
    }

    @Nullable
    public <T> T getAdapter(Class<T> adapter) {
        if (DBPDataSourceContainer.class.isAssignableFrom(adapter)) {
            return adapter.cast(this);
        }
        if (adapter == DBPPropertySource.class) {
            PropertyCollector coll = new PropertyCollector((Object)this, true);
            coll.collectProperties();
            if (this.dataSource != null) {
                int conIndex = 0;
                for (DBSInstance instance : this.dataSource.getAvailableInstances()) {
                    DBCExecutionContext[] dBCExecutionContextArray = instance.getAllContexts();
                    int n = dBCExecutionContextArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBCExecutionContext context = dBCExecutionContextArray[n2];
                        coll.addProperty(CATEGORY_CONNECTIONS, "context-" + context.getContextId(), String.valueOf(++conIndex), (Object)context.getContextName());
                        ++n2;
                    }
                }
            }
            if (this.driver.getClassLoader() instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)this.driver.getClassLoader()).getURLs();
                int urlIndex = 0;
                while (urlIndex < urls.length) {
                    Object path = urls[urlIndex];
                    try {
                        path = Paths.get(((URL)path).toURI());
                    }
                    catch (Exception exception) {}
                    coll.addProperty(CATEGORY_DRIVER_FILES, "driver-file-" + urlIndex, String.valueOf(urlIndex), path);
                    ++urlIndex;
                }
            }
            return adapter.cast(coll);
        }
        return null;
    }

    @NotNull
    public DBPImage getObjectImage() {
        return this.driver.getPlainIcon();
    }

    @NotNull
    public DBSObjectState getObjectState() {
        if (this.isConnected()) {
            return DBSObjectState.ACTIVE;
        }
        if (this.connectFailed) {
            return DBSObjectState.INVALID;
        }
        return DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) {
    }

    public static String generateNewId(DBPDriver driver) {
        long rnd = new Random().nextLong();
        if (rnd < 0L) {
            rnd = -rnd;
        }
        return driver.getId() + "-" + Long.toHexString(System.currentTimeMillis()) + "-" + Long.toHexString(rnd);
    }

    @Property(viewable=true, order=20, category="Driver")
    public String getPropertyDriverType() {
        return this.driver.getName();
    }

    @Property(order=30, category="Server")
    public String getPropertyAddress() {
        StringBuilder addr = new StringBuilder();
        if (!CommonUtils.isEmpty((String)this.connectionInfo.getHostName())) {
            addr.append(this.connectionInfo.getHostName());
        }
        if (!CommonUtils.isEmpty((String)this.connectionInfo.getHostPort())) {
            addr.append(':').append(this.connectionInfo.getHostPort());
        }
        return addr.toString();
    }

    @Property(order=31, category="Server")
    public String getPropertyDatabase() {
        return this.connectionInfo.getDatabaseName();
    }

    @Property(order=32, category="Server")
    public String getPropertyURL() {
        return this.connectionInfo.getUrl();
    }

    @Property(order=33, category="Server")
    @Nullable
    public String getPropertyServerName() {
        if (this.dataSource != null) {
            String serverName = this.dataSource.getInfo().getDatabaseProductName();
            String serverVersion = this.dataSource.getInfo().getDatabaseProductVersion();
            if (serverName != null) {
                return serverName + (String)(serverVersion == null ? "" : " [" + serverVersion + "]");
            }
        }
        return null;
    }

    @Property(order=34, category="Server")
    @Nullable
    public Map<String, Object> getPropertyServerDetails() {
        if (this.dataSource != null) {
            return this.dataSource.getInfo().getDatabaseProductDetails();
        }
        return null;
    }

    @Property(order=21, category="Driver")
    @Nullable
    public String getPropertyDriver() {
        if (this.dataSource != null) {
            String driverName = this.dataSource.getInfo().getDriverName();
            String driverVersion = this.dataSource.getInfo().getDriverVersion();
            if (driverName != null) {
                return driverName + (String)(driverVersion == null ? "" : " [" + driverVersion + "]");
            }
        }
        return null;
    }

    @Property(order=8)
    @Nullable
    public String getPropertyConnectTime() {
        if (this.connectTime != null) {
            return DateFormat.getDateTimeInstance(3, 3).format(this.connectTime);
        }
        return null;
    }

    @Property(order=9)
    public String getPropertyConnectType() {
        return this.connectionInfo.getConnectionType().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildProcess(DBRProcessDescriptor process) {
        List<DBRProcessDescriptor> list = this.childProcesses;
        synchronized (list) {
            this.childProcesses.add(process);
        }
    }

    public void copyFrom(DataSourceDescriptor descriptor) {
        this.origin = descriptor.origin;
        this.filterMap.clear();
        for (FilterMapping mapping : descriptor.getObjectFilters()) {
            this.filterMap.put(mapping.typeName, new FilterMapping(mapping));
        }
        this.virtualModel.copyFrom(descriptor.getVirtualModel());
        this.description = descriptor.description;
        this.tags.putAll(descriptor.tags);
        this.extensions.putAll(descriptor.extensions);
        this.savePassword = descriptor.savePassword;
        this.connectionReadOnly = descriptor.connectionReadOnly;
        this.forceUseSingleConnection = descriptor.forceUseSingleConnection;
        this.dpiEnabled = descriptor.dpiEnabled;
        this.navigatorSettings = new DataSourceNavigatorSettings(descriptor.getNavigatorSettings());
    }

    public String toString() {
        return this.name + " [" + String.valueOf(this.driver) + "]";
    }

    /*
     * WARNING - void declaration
     */
    public boolean equalSettings(Object obj) {
        void source;
        if (!(obj instanceof DataSourceDescriptor)) {
            return false;
        }
        DataSourceDescriptor dataSourceDescriptor = (DataSourceDescriptor)obj;
        return CommonUtils.equalOrEmptyStrings((String)this.name, (String)source.name) && CommonUtils.equalOrEmptyStrings((String)this.description, (String)source.description) && this.equalConfiguration((DataSourceDescriptor)source);
    }

    public boolean equalConfiguration(DataSourceDescriptor source) {
        return CommonUtils.equalObjects((Object)this.savePassword, (Object)source.savePassword) && CommonUtils.equalObjects((Object)this.sharedCredentials, (Object)source.sharedCredentials) && CommonUtils.equalObjects((Object)this.connectionReadOnly, (Object)source.connectionReadOnly) && CommonUtils.equalObjects((Object)this.forceUseSingleConnection, (Object)source.forceUseSingleConnection) && CommonUtils.equalObjects((Object)this.navigatorSettings, (Object)source.navigatorSettings) && CommonUtils.equalObjects((Object)this.driver, (Object)source.driver) && CommonUtils.equalObjects((Object)this.originalDriver, (Object)source.originalDriver) && CommonUtils.equalObjects((Object)this.driverSubstitution, (Object)source.driverSubstitution) && CommonUtils.equalObjects((Object)this.connectionInfo, (Object)source.connectionInfo) && this.dpiEnabled == source.dpiEnabled && CommonUtils.equalObjects(this.filterMap, source.filterMap) && CommonUtils.equalObjects((Object)this.formatterProfile, (Object)source.formatterProfile) && CommonUtils.equalObjects((Object)this.clientHome, (Object)source.clientHome) && CommonUtils.equalObjects((Object)this.lockPasswordHash, (Object)source.lockPasswordHash) && CommonUtils.equalObjects((Object)this.folder, (Object)source.folder) && CommonUtils.equalObjects(this.extensions, source.extensions) && CommonUtils.equalObjects((Object)((Object)this.preferenceStore), (Object)((Object)source.preferenceStore)) && CommonUtils.equalsContents(this.connectionModifyRestrictions, source.connectionModifyRestrictions);
    }

    @NotNull
    public String getProjectId() {
        return this.getProject().getId();
    }

    @NotNull
    public String getSecretObjectId() {
        return this.getId();
    }

    @NotNull
    public String getSecretValueId() {
        return RMProjectType.getPlainProjectId((DBPProject)this.getProject()) + DATASOURCE_KEY_PREFIX + this.getId();
    }

    @NotNull
    public String getSecretObjectType() {
        return SMObjectType.datasource.name();
    }

    public IVariableResolver getVariablesResolver(boolean actualConfig) {
        DBPConnectionConfiguration configuration = actualConfig ? this.getActualConnectionConfiguration() : this.getConnectionConfiguration();
        return new DataSourceVariableResolver((DBPDataSourceContainer)this, configuration);
    }

    public DBPDataSourceContainer createCopy(DBPDataSourceRegistry forRegistry) {
        DataSourceDescriptor copy = new DataSourceDescriptor(this, forRegistry, true);
        copy.setId(DataSourceDescriptor.generateNewId(copy.getDriver()));
        return copy;
    }

    public DBPExclusiveResource getExclusiveLock() {
        return this.exclusiveLock;
    }

    public boolean isForceUseSingleConnection() {
        return this.forceUseSingleConnection;
    }

    public void setForceUseSingleConnection(boolean value) {
        this.forceUseSingleConnection = value;
    }

    @Nullable
    public String getRequiredExternalAuth() {
        DBPDataSourceOrigin dsOrigin = this.getOrigin();
        if (dsOrigin instanceof DBPDataSourceOriginExternal) {
            DBPDataSourceOriginExternal externalOrigin = (DBPDataSourceOriginExternal)dsOrigin;
            return externalOrigin.getSubType();
        }
        String reqAuthProvider = this.getConnectionConfiguration().getAuthModelDescriptor().getRequiredAuthProviderId();
        if (!CommonUtils.isEmpty((String)reqAuthProvider)) {
            return reqAuthProvider;
        }
        DBAAuthModel dBAAuthModel = this.getConnectionConfiguration().getAuthModel();
        if (dBAAuthModel instanceof DBAAuthModelExternal) {
            DBAAuthModelExternal authModelExternal = (DBAAuthModelExternal)dBAAuthModel;
            return authModelExternal.getRequiredExternalAuth(this.getConnectionConfiguration());
        }
        return CommonUtils.isEmpty((String)reqAuthProvider) ? null : reqAuthProvider;
    }

    public static boolean askForPassword(@NotNull DataSourceDescriptor dataSourceContainer, @Nullable DBWHandlerConfiguration networkHandler, @NotNull DBWTunnel.AuthCredentials authType) {
        DBPAuthInfo authInfo;
        DBPConnectionConfiguration actualConfig = dataSourceContainer.getActualConnectionConfiguration();
        DBPConnectionConfiguration connConfig = dataSourceContainer.getConnectionConfiguration();
        Object prompt = networkHandler != null ? NLS.bind((String)RegistryMessages.dialog_connection_auth_title_for_handler, (Object)networkHandler.getTitle()) : "'" + dataSourceContainer.getName() + RegistryMessages.dialog_connection_auth_title;
        String user = networkHandler != null ? networkHandler.getUserName() : actualConfig.getUserName();
        String password = networkHandler != null ? networkHandler.getPassword() : actualConfig.getUserPassword();
        try {
            authInfo = DataSourceDescriptor.askCredentials(dataSourceContainer, authType, (String)prompt, user, password, !dataSourceContainer.isTemporary());
        }
        catch (Exception e) {
            log.debug((Object)e);
            authInfo = new DBPAuthInfo(user, password, false);
        }
        if (authInfo == null) {
            return false;
        }
        if (networkHandler != null) {
            networkHandler.setUserName(authInfo.getUserName());
            networkHandler.setPassword(authInfo.getUserPassword());
            networkHandler.setSavePassword(authInfo.isSavePassword());
            actualConfig.updateHandler(networkHandler);
            if (authInfo.isSavePassword() && connConfig != actualConfig) {
                connConfig.updateHandler(networkHandler);
            }
        } else {
            if (authType == DBWTunnel.AuthCredentials.CREDENTIALS) {
                actualConfig.setUserName(authInfo.getUserName());
            }
            actualConfig.setUserPassword(authInfo.getUserPassword());
            dataSourceContainer.setSavePassword(authInfo.isSavePassword());
        }
        if (authInfo.isSavePassword()) {
            if (authInfo.isSavePassword() && connConfig != actualConfig) {
                if (authType == DBWTunnel.AuthCredentials.CREDENTIALS) {
                    if (networkHandler != null) {
                        networkHandler.setUserName(authInfo.getUserName());
                    } else {
                        connConfig.setUserName(authInfo.getUserName());
                    }
                }
                if (networkHandler != null) {
                    networkHandler.setPassword(authInfo.getUserPassword());
                } else {
                    connConfig.setUserPassword(authInfo.getUserPassword());
                }
            }
            try {
                dataSourceContainer.getRegistry().updateDataSource((DBPDataSourceContainer)dataSourceContainer);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error saving datasource", null, (Throwable)e);
            }
        }
        return true;
    }

    private static DBPAuthInfo askCredentials(@NotNull DataSourceDescriptor dataSourceContainer, @NotNull DBWTunnel.AuthCredentials authType, String prompt, String user, String password, boolean canSavePassword) {
        DBPAuthInfo authInfo = DBWorkbench.getPlatformUI().promptUserCredentials(prompt, RegistryMessages.dialog_connection_auth_username, user, authType == DBWTunnel.AuthCredentials.PASSWORD ? RegistryMessages.dialog_connection_auth_passphrase : RegistryMessages.dialog_connection_auth_password, password, false, canSavePassword);
        return authInfo;
    }

    private void updateDataSourceObject(boolean succeeded, DBPEvent.Action action) {
        this.getRegistry().notifyDataSourceListeners(new DBPEvent(action, (DBSObject)this, succeeded));
    }

    @Nullable
    public String saveToSecret() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        if (this.isSavePassword()) {
            if (!CommonUtils.isEmpty((String)this.connectionInfo.getUserName())) {
                props.put("user", this.connectionInfo.getUserName());
            }
            if (!CommonUtils.isEmpty((String)this.connectionInfo.getUserPassword())) {
                props.put("password", this.connectionInfo.getUserPassword());
            }
            if (!CommonUtils.isEmpty((Map)this.connectionInfo.getAuthProperties())) {
                props.put("properties", this.connectionInfo.getAuthProperties());
            }
            if (props.isEmpty()) {
                props.put("empty-credentials", true);
            }
            this.secretsContainsDatabaseCreds = true;
        } else {
            this.secretsContainsDatabaseCreds = false;
        }
        if (!this.isSharedCredentials() && CommonUtils.isEmpty((String)this.connectionInfo.getConfigProfileName())) {
            ArrayList<Map> handlersConfigs = new ArrayList<Map>();
            for (DBWHandlerConfiguration hc : this.connectionInfo.getHandlers()) {
                Map handlerProps = hc.saveToSecret();
                if (handlerProps.isEmpty()) continue;
                handlerProps.put("id", hc.getId());
                handlersConfigs.add(handlerProps);
            }
            if (!handlersConfigs.isEmpty()) {
                props.put("handlers", handlersConfigs);
            }
        }
        if (props.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> propsFull = new LinkedHashMap<String, Object>();
        propsFull.put("datasource-name", this.getName());
        propsFull.put("datasource-driver", this.getDriver().getFullId());
        propsFull.putAll(props);
        return DBInfoUtils.SECRET_GSON.toJson(propsFull);
    }

    public void loadFromSecret(@Nullable String secretValue) {
        Map props;
        if (secretValue == null) {
            if (DBWorkbench.isDistributed()) {
                this.connectionInfo.getHandlers().forEach(handler -> handler.setSavePassword(false));
                this.savePassword = false;
            }
            return;
        }
        try {
            props = JSONUtils.parseMap((Gson)DBInfoUtils.SECRET_GSON, (Reader)new StringReader(secretValue));
        }
        catch (Exception e) {
            log.error((Object)"Error parsing secret value", (Throwable)e);
            return;
        }
        String dbUserName = JSONUtils.getString((Map)props, (String)"user");
        String dbPassword = JSONUtils.getString((Map)props, (String)"password");
        Map dbAuthProperties = JSONUtils.deserializeStringMapOrNull((Map)props, (String)"properties");
        this.connectionInfo.setUserName(dbUserName);
        this.connectionInfo.setUserPassword(dbPassword);
        if (!CommonUtils.isEmpty((Map)dbAuthProperties)) {
            for (Map.Entry ap : dbAuthProperties.entrySet()) {
                this.connectionInfo.setAuthProperty((String)ap.getKey(), (String)ap.getValue());
            }
        }
        boolean emptyDatabaseCredsSaved = CommonUtils.toBoolean((Object)props.getOrDefault("empty-credentials", false));
        boolean bl = this.secretsContainsDatabaseCreds = props.containsKey("user") || props.containsKey("password") || props.containsKey("properties") || emptyDatabaseCredsSaved;
        if (DBWorkbench.isDistributed()) {
            this.savePassword = this.secretsContainsDatabaseCreds;
        }
        List handlerList = JSONUtils.getObjectList((Map)props, (String)"handlers");
        HashSet<String> handlersFromSecret = new HashSet<String>();
        if (!CommonUtils.isEmpty((Collection)handlerList)) {
            for (Map handlerMap : handlerList) {
                String handlerId = JSONUtils.getString((Map)handlerMap, (String)"id");
                DBWHandlerConfiguration hc = this.connectionInfo.getHandler(handlerId);
                if (hc == null) {
                    log.warn((Object)("Handler '" + handlerId + "' not found in datasource '" + this.getId() + "'. Secret configuration will be lost."));
                    continue;
                }
                handlersFromSecret.add(handlerId);
                String hcUsername = JSONUtils.getString((Map)handlerMap, (String)"user");
                String hcPassword = JSONUtils.getString((Map)handlerMap, (String)"password");
                Map hcProperties = JSONUtils.deserializeStringMap((Map)handlerMap, (String)"properties");
                hc.setUserName(hcUsername);
                hc.setPassword(hcPassword);
                hc.setSecureProperties(hcProperties);
                hc.setSavePassword(CommonUtils.isNotEmpty((String)hcUsername) || CommonUtils.isNotEmpty((String)hcPassword) || !CommonUtils.isEmpty((Map)hcProperties));
            }
        }
        if (!this.isSharedCredentials()) {
            this.connectionInfo.getHandlers().forEach(handler -> {
                if (!handlersFromSecret.contains(handler.getId())) {
                    handler.setSavePassword(false);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadFromLegacySecret(DBSSecretController secretController) {
        if (!(secretController instanceof DBSSecretBrowser)) {
            return;
        }
        DBSSecretBrowser dBSSecretBrowser = (DBSSecretBrowser)secretController;
        String keyPrefix = "datasources/" + this.getId();
        Path itemPath = Path.of(keyPrefix, new String[0]);
        try {
            void sBrowser;
            for (DBSSecret secret : sBrowser.listSecrets(itemPath.toString())) {
                String secretId = secret.getId();
                String secretValue = secretController.getPrivateSecretValue(secretId);
                switch (secret.getName()) {
                    case "user": {
                        this.connectionInfo.setUserName(secretValue);
                        break;
                    }
                    case "password": {
                        this.connectionInfo.setUserPassword(secretValue);
                        break;
                    }
                    default: {
                        this.connectionInfo.setAuthProperty(secretId, secretValue);
                    }
                }
            }
            for (DBWHandlerConfiguration hc : this.connectionInfo.getHandlers()) {
                itemPath = Path.of(keyPrefix + "/network/" + hc.getId(), new String[0]);
                for (DBSSecret secret : sBrowser.listSecrets(itemPath.toString())) {
                    String secretId = secret.getId();
                    switch (secret.getName()) {
                        case "user": {
                            hc.setUserName(secretController.getPrivateSecretValue(secretId));
                            break;
                        }
                        case "password": {
                            hc.setPassword(secretController.getPrivateSecretValue(secretId));
                            break;
                        }
                        default: {
                            hc.setProperty(secretId, (Object)secretController.getPrivateSecretValue(secretId));
                        }
                    }
                }
            }
        }
        catch (DBException e) {
            log.error((Object)("Error reading datasource '" + this.getId() + "' legacy secrets"), (Throwable)e);
        }
    }

    public static class ContextInfo
    implements DBPObject {
        private final DBCExecutionContext context;

        public ContextInfo(DBCExecutionContext context) {
            this.context = context;
        }

        @Property(viewable=true, order=1)
        public String getName() {
            return this.context.getContextName();
        }

        public String toString() {
            return this.getName();
        }
    }
}

