/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskEvent;
import org.jkiss.dbeaver.model.task.DBTTaskFolder;
import org.jkiss.dbeaver.model.task.DBTTaskRun;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.RunStatistics;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.registry.task.TaskRunImpl;
import org.jkiss.dbeaver.registry.task.TaskUtils;

public class TaskImpl
implements DBTTask,
DBPNamedObject2 {
    public static String META_FILE_NAME = "meta.json";
    private static final Log log = Log.getLog(TaskImpl.class);
    private static final int MAX_RUNS_IN_STATS = 100;
    private static final Gson gson = new GsonBuilder().setLenient().setDateFormat("yyyyMMddHHmm").create();
    private final DBPProject project;
    private final String id;
    private String label;
    private String description;
    private Date createTime;
    private Date updateTime;
    private DBTTaskType type;
    private Map<String, Object> properties;
    private volatile List<DBTTaskRun> runs;
    private DBTTaskFolder taskFolder;
    private int maxExecutionTime;

    protected TaskImpl(@NotNull DBPProject project, @NotNull DBTTaskType type, @NotNull String id, @NotNull String label, @Nullable String description, @NotNull Date createTime, @Nullable Date updateTime, @Nullable DBTTaskFolder folder) {
        this.project = project;
        this.id = id;
        this.label = label;
        this.description = description;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.type = type;
        this.taskFolder = folder;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public DBPProject getProject() {
        return this.project;
    }

    @NotNull
    public String getName() {
        return this.label;
    }

    public void setName(@NotNull String label) {
        this.label = label;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@NotNull String description) {
        this.description = description;
    }

    @Nullable
    public DBTTaskFolder getTaskFolder() {
        return this.taskFolder;
    }

    public void setTaskFolder(@Nullable DBTTaskFolder taskFolder) {
        this.taskFolder = taskFolder;
    }

    @NotNull
    public Date getCreateTime() {
        return this.createTime;
    }

    @NotNull
    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @NotNull
    public DBTTaskType getType() {
        return this.type;
    }

    public void setType(DBTTaskType type) {
        this.type = type;
    }

    @NotNull
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Nullable
    public DBTTaskRun getLastRun() {
        this.loadRunsIfNeeded();
        return this.runs.isEmpty() ? null : this.runs.get(this.runs.size() - 1);
    }

    @NotNull
    public DBTTaskRun[] getAllRuns() {
        this.loadRunsIfNeeded();
        return (DBTTaskRun[])this.runs.toArray(DBTTaskRun[]::new);
    }

    @Nullable
    public Path getRunLog(@NotNull DBTTaskRun run) {
        return this.getTaskStatsFolder(false).resolve(TaskUtils.buildRunLogFileName(run.getId()));
    }

    @NotNull
    public InputStream getRunLogInputStream(@NotNull DBTTaskRun run) throws DBException, IOException {
        return Files.newInputStream(Objects.requireNonNull(this.getRunLog(run)), new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRun(DBTTaskRun taskRun) {
        TaskImpl taskImpl = this;
        synchronized (taskImpl) {
            this.loadRunsIfNeeded();
            if (!this.runs.remove(taskRun)) {
                return;
            }
            Path runLog = this.getRunLog(taskRun);
            if (runLog != null) {
                try {
                    Files.deleteIfExists(runLog);
                }
                catch (IOException e) {
                    log.error((Object)("Can't delete log file '" + String.valueOf(runLog.toAbsolutePath()) + "'"), (Throwable)e);
                }
            }
            this.flushRunStatistics(this.runs);
        }
        TaskRegistry.getInstance().notifyTaskListeners(new DBTTaskEvent((DBTTask)this, DBTTaskEvent.Action.TASK_UPDATE));
    }

    public void cleanRunStatistics() {
        Path statsFolder = this.getTaskStatsFolder(false);
        if (Files.exists(statsFolder, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Stream<Path> list = Files.list(statsFolder);){
                    List<Path> taskFiles = list.toList();
                    for (Path file : taskFiles) {
                        try {
                            Files.delete(file);
                        }
                        catch (IOException e) {
                            log.error((Object)("Can't delete log item '" + String.valueOf(file.toAbsolutePath()) + "'"), (Throwable)e);
                        }
                    }
                    Files.delete(statsFolder);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.error((Object)("Can't delete logs folder '" + String.valueOf(statsFolder.toAbsolutePath()) + "'"), (Throwable)e);
            }
        }
        if (this.runs != null) {
            this.runs.clear();
        }
        this.flushRunStatistics(List.of());
        TaskRegistry.getInstance().notifyTaskListeners(new DBTTaskEvent((DBTTask)this, DBTTaskEvent.Action.TASK_UPDATE));
    }

    public void refreshRunStatistics() {
        this.runs = new ArrayList<DBTTaskRun>(this.loadRunStatistics());
    }

    public void setProperties(@NotNull Map<String, Object> properties) {
        this.properties = new LinkedHashMap<String, Object>(properties);
    }

    public boolean isTemporary() {
        return "#temp".equals(this.id);
    }

    public int getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public void setMaxExecutionTime(int maxExecutionTime) {
        this.maxExecutionTime = maxExecutionTime;
    }

    protected Path getTaskStatsFolder(boolean create) {
        Path taskStatsFolder = this.project.getTaskManager().getStatisticsFolder().resolve(this.id);
        if (create && !Files.exists(taskStatsFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(taskStatsFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error((Object)("Can't create task log folder '" + String.valueOf(taskStatsFolder.toAbsolutePath()) + "'"), (Throwable)e);
            }
        }
        return taskStatsFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNewRun(@NotNull DBTTaskRun taskRun) {
        TaskImpl taskImpl = this;
        synchronized (taskImpl) {
            this.loadRunsIfNeeded();
            this.runs.add(taskRun);
            while (this.runs.size() > 100) {
                this.runs.remove(0);
            }
            this.flushRunStatistics(this.runs);
        }
        TaskRegistry.getInstance().notifyTaskListeners(new DBTTaskEvent((DBTTask)this, DBTTaskEvent.Action.TASK_UPDATE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRun(@NotNull TaskRunImpl taskRun) {
        TaskImpl taskImpl = this;
        synchronized (taskImpl) {
            this.loadRunsIfNeeded();
            int i = 0;
            while (i < this.runs.size()) {
                if (this.runs.get(i).getId().equals(taskRun.getId())) {
                    this.runs.set(i, taskRun);
                    break;
                }
                ++i;
            }
            this.flushRunStatistics(this.runs);
        }
        TaskRegistry.getInstance().notifyTaskListeners(new DBTTaskEvent((DBTTask)this, DBTTaskEvent.Action.TASK_UPDATE));
    }

    public String toString() {
        return this.id + " " + this.label + " (" + this.type.getName() + ")";
    }

    @NotNull
    protected List<? extends DBTTaskRun> loadRunStatistics() {
        return TaskUtils.loadRunStatistics(this.getTaskStatsFolder(false).resolve(META_FILE_NAME), gson);
    }

    protected void flushRunStatistics(@NotNull List<? extends DBTTaskRun> runs) {
        Path metaFile = this.getTaskStatsFolder(true).resolve(META_FILE_NAME);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(metaFile, new OpenOption[0]);){
                List<TaskRunImpl> filteredRuns = runs.stream().filter(run -> run instanceof TaskRunImpl).map(run -> (TaskRunImpl)run).collect(Collectors.toList());
                writer.write(gson.toJson((Object)new RunStatistics(filteredRuns)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)"Error writing task run statistics", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRunsIfNeeded() {
        if (this.runs == null) {
            TaskImpl taskImpl = this;
            synchronized (taskImpl) {
                if (this.runs == null) {
                    this.runs = new ArrayList<DBTTaskRun>(this.loadRunStatistics());
                }
            }
        }
    }
}

