/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.import_config.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.connection.DBPDriver;

public class ImportDriverInfo {
    private String id;
    private String name;
    private String sampleURL;
    private String driverClass;
    private List<String> libraries = new ArrayList<String>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private String defaultPort;
    private String defaultDatabase;
    private String defaultServer;
    private String defaultUser;
    private String description;

    public ImportDriverInfo(String id, String name, String sampleURL, String driverClass) {
        this.id = id;
        this.name = name;
        this.sampleURL = sampleURL;
        this.driverClass = driverClass;
    }

    public ImportDriverInfo(@Nullable DBPDriver driver) {
        if (driver == null) {
            this.id = "";
            this.name = "";
            this.sampleURL = "";
            this.driverClass = "";
            return;
        }
        this.id = driver.getId();
        this.name = driver.getName();
        this.sampleURL = driver.getSampleURL();
        this.driverClass = driver.getDriverClassName();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSampleURL() {
        return this.sampleURL;
    }

    public void setSampleURL(String sampleURL) {
        this.sampleURL = sampleURL;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(String defaultPort) {
        this.defaultPort = defaultPort;
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public void setDefaultDatabase(String defaultDatabase) {
        this.defaultDatabase = defaultDatabase;
    }

    public String getDefaultServer() {
        return this.defaultServer;
    }

    public void setDefaultServer(String defaultServer) {
        this.defaultServer = defaultServer;
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public void setDefaultUser(String defaultUser) {
        this.defaultUser = defaultUser;
    }

    public List<String> getLibraries() {
        return this.libraries;
    }

    public void addLibrary(String path) {
        this.libraries.add(path);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return this.name + " - " + this.driverClass + " - " + this.sampleURL;
    }
}

