/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.import_config.wizards.dbvis;

import java.io.File;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.import_config.Activator;
import org.jkiss.dbeaver.ext.import_config.ImportConfigMessages;
import org.jkiss.dbeaver.ext.import_config.dbvis.DbvisConfigurationImporter;
import org.jkiss.dbeaver.ext.import_config.wizards.ConfigImportWizardPage;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportData;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class ConfigImportWizardPageDbvis
extends ConfigImportWizardPage {
    public static final String DBVIS_HOME_FOLDER = ".dbvis";

    protected ConfigImportWizardPageDbvis() {
        super("DBVisualizer");
        this.setTitle("DBVisualizer");
        this.setDescription("Import DBVisualizer connections");
        this.setImageDescriptor(Activator.getImageDescriptor("icons/dbvis_big.png"));
    }

    @Override
    protected void loadConnections(ImportData importData) throws DBException {
        File homeFolder = RuntimeUtils.getUserHomeDir();
        File dbvisConfigHome = new File(homeFolder, DBVIS_HOME_FOLDER);
        if (!dbvisConfigHome.exists()) {
            throw new DBException(ImportConfigMessages.config_import_wizard_page_dbvis_label_installation_not_found);
        }
        DbvisConfigurationImporter configurationImporter = new DbvisConfigurationImporter();
        importData = configurationImporter.importConfiguration(importData, dbvisConfigHome);
    }

    @Override
    public boolean isPageComplete() {
        if (this.getConnectionTable() == null) {
            return false;
        }
        this.setErrorMessage(null);
        boolean isCompleted = false;
        TableItem[] tableItemArray = this.getConnectionTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            TableItem item = tableItemArray[n2];
            if (item.getChecked() && (object = item.getData()) instanceof ImportConnectionInfo) {
                ImportConnectionInfo importConnection = (ImportConnectionInfo)object;
                if (importConnection.getDriverInfo() == null) {
                    isCompleted = false;
                    this.setErrorMessage(NLS.bind((String)ImportConfigMessages.config_import_wizard_error, (Object)importConnection.getAlias()));
                    break;
                }
                isCompleted = true;
            }
            ++n2;
        }
        return isCompleted;
    }
}

