/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.import_config.wizards.sqlworkbench;

import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class ConfigImportWizardPageSqlWorkbenchSettings
extends WizardPage {
    private TextWithOpenFile filePathText;
    private File inputFile;

    protected ConfigImportWizardPageSqlWorkbenchSettings() {
        super("Settings");
        this.setTitle("Input settings");
        this.setDescription("Connections file settings");
    }

    public void createControl(Composite parent) {
        Composite placeholder = new Composite(parent, 0);
        placeholder.setLayout((Layout)new GridLayout(1, true));
        UIUtils.createControlLabel((Composite)placeholder, (String)"Input file (e.g. connections.xml)");
        this.filePathText = new TextWithOpenFile(placeholder, "Configuration Input File", new String[]{"*.xml"});
        this.filePathText.setLayoutData((Object)new GridData(768));
        this.filePathText.setText(this.getDefaultPathToFile());
        this.setInputFileAndUpdateButtons();
        this.filePathText.getTextControl().addModifyListener(e -> this.setInputFileAndUpdateButtons());
        this.setControl((Control)placeholder);
    }

    public boolean isPageComplete() {
        return this.inputFile != null && this.inputFile.exists();
    }

    public File getInputFile() {
        return this.inputFile;
    }

    private String getDefaultPathToFile() {
        if (RuntimeUtils.isWindows()) {
            return RuntimeUtils.getWorkingDirectory((String)"MySQL\\Workbench\\connections.xml");
        }
        return "";
    }

    private void setInputFileAndUpdateButtons() {
        if (this.filePathText.getText().trim().isEmpty()) {
            return;
        }
        this.inputFile = new File(this.filePathText.getText());
        if (!this.inputFile.exists()) {
            this.setErrorMessage("Folder '" + this.inputFile.getAbsolutePath() + "' doesn't exist");
        } else {
            this.setErrorMessage(null);
            this.getWizard().getContainer().updateButtons();
        }
    }
}

