/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.edit.SQLServerBaseTableManager;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExternalTable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SQLServerExternalTableManager
extends SQLServerBaseTableManager<SQLServerExternalTable> {
    private static final Log log = Log.getLog(SQLServerExternalTableManager.class);
    private static final Class<? extends DBSObject>[] CHILD_TYPES = (Class[])CommonUtils.array((Object[])new Class[]{SQLServerTableColumn.class});

    protected SQLServerExternalTable createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        SQLServerSchema schema = (SQLServerSchema)container;
        SQLServerExternalTable table = new SQLServerExternalTable(schema);
        this.setNewObjectName(monitor, schema, table);
        return table;
    }

    public boolean canCreateObject(@NotNull Object container) {
        return false;
    }

    protected void appendTableModifiers(DBRProgressMonitor monitor, SQLServerExternalTable table, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
        try {
            SQLServerExternalTable.AdditionalInfo info = table.getAdditionalInfo(monitor);
            ddl.append(" WITH (\n\tLOCATION = ").append(SQLUtils.quoteString((DBSObject)table, (String)info.getExternalLocation()));
            ddl.append(",\n\tDATA_SOURCE = ").append(DBUtils.getQuotedIdentifier((DBPDataSource)table.getDataSource(), (String)info.getExternalDataSource()));
            if (CommonUtils.isNotEmpty((String)info.getExternalFileFormat())) {
                ddl.append(",\n\tFILE_FORMAT = ").append(SQLUtils.quoteString((DBSObject)table, (String)info.getExternalFileFormat()));
            }
            ddl.append("\n)");
        }
        catch (DBCException dBCException) {
            log.error((Object)"Error retrieving external table info");
        }
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull SQLServerExternalTable object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    @NotNull
    public Class<? extends DBSObject>[] getChildTypes() {
        return CHILD_TYPES;
    }

    protected String getCreateTableType(SQLServerExternalTable table) {
        return "EXTERNAL TABLE";
    }
}

