/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExtendedPropertyOwner;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectClass;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class SQLServerExtendedProperty
implements SQLServerObject,
DBPUniqueObject,
DBPRefreshableObject,
DBPScriptObject,
DBPNamedObject2 {
    private static final Log log = Log.getLog(SQLServerExtendedProperty.class);
    private final SQLServerExtendedPropertyOwner owner;
    private String name;
    private String value;
    private SQLServerDataType type;
    private final boolean persisted;

    public SQLServerExtendedProperty(@NotNull DBRProgressMonitor monitor, @NotNull SQLServerExtendedPropertyOwner owner, @NotNull ResultSet dbResult) throws DBException {
        SQLServerObjectClass objectClass = (SQLServerObjectClass)CommonUtils.valueOf(SQLServerObjectClass.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"class_desc"));
        long majorId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"major_id");
        long minorId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"minor_id");
        if (objectClass != owner.getExtendedPropertyObjectClass() || majorId != owner.getMajorObjectId() || minorId != owner.getMinorObjectId()) {
            throw new DBException("Extended property owner mismatch");
        }
        this.owner = owner;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        this.value = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"value");
        this.persisted = true;
        SQLServerDataType type = owner.getDatabase().getDataTypeByUserTypeId(monitor, JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"value_type"));
        if (type == null) {
            type = this.getDataSource().getLocalDataType("nvarchar");
        }
        this.type = type;
    }

    public SQLServerExtendedProperty(@NotNull SQLServerExtendedPropertyOwner owner, @NotNull SQLServerDataType type, @NotNull String name, @NotNull String value) {
        this.owner = owner;
        this.name = name;
        this.value = value;
        this.type = type;
        this.persisted = false;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Property(viewable=true, editable=true, updatable=true, order=2)
    @Nullable
    public String getValue() {
        return CommonUtils.toString((Object)this.value, null);
    }

    public void setValue(@Nullable String value) {
        this.value = value;
    }

    @Property(viewable=true, editable=true, updatable=true, order=3, listProvider=DataTypeListProvider.class)
    @NotNull
    public SQLServerDataType getValueType() {
        return this.type;
    }

    public void setValueType(@NotNull SQLServerDataType type) {
        this.type = type;
    }

    @Override
    @NotNull
    public SQLServerDataSource getDataSource() {
        return this.owner.getDataSource();
    }

    @NotNull
    public SQLServerExtendedPropertyOwner getParentObject() {
        return this.owner;
    }

    @Override
    @NotNull
    public SQLServerDatabase getDatabase() {
        return this.owner.getDatabase();
    }

    public long getObjectId() {
        return this.owner.getMinorObjectId();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @NotNull
    public String getUniqueName() {
        return this.name + ":" + this.owner.getMajorObjectId() + ":" + this.owner.getMinorObjectId();
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.owner.getExtendedPropertyCache().refreshObject(monitor, this.owner, this);
    }

    @Nullable
    public String getObjectDefinitionText(DBRProgressMonitor monitor, boolean update, boolean delete) throws DBException {
        if (update && delete) {
            throw new DBException("Can't get object definition text for both 'update' and 'delete'");
        }
        Pair<String, SQLServerObject> level0 = this.owner.getExtendedPropertyObject(monitor, 0);
        Pair<String, SQLServerObject> level1 = this.owner.getExtendedPropertyObject(monitor, 1);
        Pair<String, SQLServerObject> level2 = this.owner.getExtendedPropertyObject(monitor, 2);
        if (level0 == null || level1 == null && level2 == null) {
            log.debug((Object)("Can't get definition for extended property of class '" + this.owner.getExtendedPropertyObjectClass().getClassName() + "'"));
            return null;
        }
        SQLDialect dialect = SQLUtils.getDialectFromObject((DBPObject)this);
        StringBuilder ddl = new StringBuilder("EXEC ");
        ddl.append(SQLServerUtils.getSystemTableName(this.owner.getDatabase(), update ? "sp_updateextendedproperty" : (delete ? "sp_dropextendedproperty" : "sp_addextendedproperty")));
        ddl.append(" @name=").append(dialect.getQuotedString(this.name));
        if (!delete) {
            ddl.append(", @value=").append(SQLUtils.convertValueToSQL((DBPDataSource)this.getDataSource(), (DBSTypedObject)this.type, (Object)this.value));
        }
        SQLServerExtendedProperty.appendLevelDefinitionText(ddl, dialect, level0, 0);
        if (level1 != null) {
            SQLServerExtendedProperty.appendLevelDefinitionText(ddl, dialect, level1, 1);
        }
        if (level2 != null) {
            SQLServerExtendedProperty.appendLevelDefinitionText(ddl, dialect, level2, 2);
        }
        return ddl.toString();
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return this.getObjectDefinitionText(monitor, false, false);
    }

    private static void appendLevelDefinitionText(@NotNull StringBuilder ddl, @NotNull SQLDialect dialect, @NotNull Pair<String, SQLServerObject> level, int index) {
        ddl.append(", @level").append(index).append("type=").append(dialect.getQuotedString((String)level.getFirst()));
        ddl.append(", @level").append(index).append("name=").append(dialect.getQuotedString(((SQLServerObject)level.getSecond()).getName()));
    }

    public static class DataTypeListProvider
    implements IPropertyValueListProvider<SQLServerExtendedProperty> {
        private static final Set<String> RESTRICTED_TYPE_NAMES = new HashSet<String>();

        static {
            RESTRICTED_TYPE_NAMES.add("datetimeoffset");
            RESTRICTED_TYPE_NAMES.add("geography");
            RESTRICTED_TYPE_NAMES.add("geometry");
            RESTRICTED_TYPE_NAMES.add("hierarchyid");
            RESTRICTED_TYPE_NAMES.add("image");
            RESTRICTED_TYPE_NAMES.add("ntext");
            RESTRICTED_TYPE_NAMES.add("text");
            RESTRICTED_TYPE_NAMES.add("sql_variant");
            RESTRICTED_TYPE_NAMES.add("xml");
        }

        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(SQLServerExtendedProperty object) {
            return object.getDataSource().getLocalDataTypes().stream().filter(type -> !RESTRICTED_TYPE_NAMES.contains(type.getName())).toArray();
        }
    }
}

