/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndex;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndexColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableUniqueKeyColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraintColumn;
import org.jkiss.utils.CommonUtils;

public class SQLServerTableUniqueKey
extends JDBCTableConstraint<SQLServerTableBase, DBSTableConstraintColumn> {
    private final SQLServerTableIndex index;
    private final List<SQLServerTableUniqueKeyColumn> columns = new ArrayList<SQLServerTableUniqueKeyColumn>();

    public SQLServerTableUniqueKey(SQLServerTableBase table, String name, String remarks, DBSEntityConstraintType constraintType, SQLServerTableIndex index, boolean persisted) {
        super((JDBCTable)table, name, remarks, constraintType, persisted);
        this.index = index;
    }

    protected SQLServerTableUniqueKey(DBRProgressMonitor monitor, SQLServerTableBase table, DBSEntityConstraint source) throws DBException {
        super((JDBCTable)table, source, false);
        this.index = table.getIndex(monitor, source.getName());
    }

    @Property(viewable=true, order=10)
    public SQLServerTableIndex getIndex() {
        return this.index;
    }

    public List<DBSTableConstraintColumn> getAttributeReferences(DBRProgressMonitor monitor) {
        if (!CommonUtils.isEmpty(this.columns)) {
            return new ArrayList<SQLServerTableUniqueKeyColumn>(this.columns);
        }
        if (this.index == null) {
            return null;
        }
        List<SQLServerTableIndexColumn> indexAttrs = this.index.getAttributeReferences(monitor);
        return indexAttrs == null ? null : new ArrayList<SQLServerTableIndexColumn>(indexAttrs);
    }

    public void addAttributeReference(DBSTableColumn column) throws DBException {
        this.columns.add(new SQLServerTableUniqueKeyColumn((AbstractTableConstraint<SQLServerTableBase, ? extends DBSTableConstraintColumn>)this, (SQLServerTableColumn)column, this.columns.size()));
    }

    public void setAttributeReferences(List<DBSTableConstraintColumn> columns) {
        this.columns.clear();
        for (DBSEntityAttributeRef dBSEntityAttributeRef : columns) {
            this.columns.add((SQLServerTableUniqueKeyColumn)dBSEntityAttributeRef);
        }
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((SQLServerTableBase)this.getTable()).getDatabase(), ((SQLServerTableBase)this.getTable()).getSchema(), this.getTable(), this});
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return (SQLServerDataSource)((SQLServerTableBase)this.getTable()).getDataSource();
    }

    public void addColumn(SQLServerTableUniqueKeyColumn column) {
        this.columns.add(column);
    }
}

