/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.session;

import java.sql.ResultSet;
import java.util.Date;
import java.util.Objects;
import org.jkiss.dbeaver.model.admin.sessions.AbstractServerSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;

public class PostgreSession
extends AbstractServerSession {
    private static final String CAT_CLIENT = "Client";
    private static final String CAT_TIMING = "Timings";
    private final int pid;
    private String user;
    private String clientHost;
    private String clientPort;
    private final String db;
    private String query;
    private Date backendStart;
    private Date xactStart;
    private Date queryStart;
    private Date stateChange;
    private String state;
    private String appName;

    public PostgreSession(ResultSet dbResult) {
        this.pid = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"pid");
        this.user = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"usename");
        this.clientHost = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"client_hostname");
        if (CommonUtils.isEmpty((String)this.clientHost)) {
            this.clientHost = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"client_addr");
        }
        this.clientPort = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"client_port");
        this.db = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"datname");
        this.query = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"query");
        this.backendStart = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"backend_start");
        this.xactStart = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"xact_start");
        this.queryStart = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"query_start");
        this.stateChange = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"state_change");
        this.state = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"state");
        this.appName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"application_name");
    }

    @Property(viewable=true, order=1)
    public int getPid() {
        return this.pid;
    }

    @Property(viewable=true, category="Client", order=2)
    public String getUser() {
        return this.user;
    }

    @Property(viewable=false, category="Client", order=3)
    public String getClientHost() {
        return this.clientHost;
    }

    @Property(viewable=false, category="Client", order=4)
    public String getClientPort() {
        return this.clientPort;
    }

    @Property(viewable=true, order=5)
    public String getDb() {
        return this.db;
    }

    @Property(viewable=true, category="Client", order=6)
    public String getAppName() {
        return this.appName;
    }

    @Property(viewable=false, category="Timings", order=30)
    public Date getBackendStart() {
        return this.backendStart;
    }

    @Property(viewable=false, category="Timings", order=31)
    public Date getXactStart() {
        return this.xactStart;
    }

    @Property(viewable=true, category="Timings", order=32)
    public Date getQueryStart() {
        return this.queryStart;
    }

    @Property(viewable=false, category="Timings", order=33)
    public Date getStateChange() {
        return this.stateChange;
    }

    @Property(viewable=true, order=7)
    public String getState() {
        return this.state;
    }

    @Property(viewable=true, order=100)
    public String getBriefQuery() {
        if (this.query != null && this.query.length() > 50) {
            return CommonUtils.truncateString((String)this.query, (int)50) + " ...";
        }
        return this.query;
    }

    public String getActiveQuery() {
        return this.query;
    }

    public String toString() {
        if (!CommonUtils.isEmpty((String)this.db)) {
            return this.pid + "@" + this.db;
        }
        return String.valueOf(this.pid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PostgreSession that = (PostgreSession)((Object)o);
        return this.pid == that.pid && Objects.equals(this.db, that.db);
    }

    public int hashCode() {
        return Objects.hash(this.pid, this.db);
    }
}

