/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseGlobalObject;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseReplicationItem;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.utils.CommonUtils;

public class AltibaseReplication
extends AltibaseGlobalObject
implements DBSObjectLazy<AltibaseDataSource>,
DBPRefreshableObject,
DBPScriptObject {
    protected String ddl;
    private String name;
    private String remoteAddr;
    private String remoteConnType;
    private String status;
    private String conflictResolution;
    private String mode;
    private String role;
    private int options;
    private String recoverable;
    private int parallelApplierCount;
    private long xsn;
    private Timestamp giveUpTime;
    private long giveUpXsn;
    private Timestamp remoteFaultDetectTime;

    protected AltibaseReplication(GenericStructContainer owner, JDBCResultSet resultSet) {
        super((AltibaseDataSource)owner.getDataSource(), true);
        this.name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REPLICATION_NAME");
        this.status = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"STATUS");
        this.conflictResolution = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CONFLICT_RESOLUTION");
        this.mode = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REPL_MODE");
        this.role = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ROLE");
        this.options = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"OPTIONS");
        this.recoverable = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"RECOVERABLE");
        this.parallelApplierCount = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"PARALLEL_APPLIER_COUNT");
        this.xsn = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"XSN");
        this.giveUpTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"GIVE_UP_TIME");
        this.giveUpXsn = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"GIVE_UP_XSN");
        this.remoteFaultDetectTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"REMOTE_FAULT_DETECT_TIME");
        this.remoteAddr = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMOTE_ADDR");
        this.remoteConnType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMOTE_CONN_TYPE");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    @Property(viewable=true, order=3)
    public String getRemoteConnType() {
        return this.remoteConnType;
    }

    @Property(viewable=true, order=10)
    public String getStatus() {
        return this.status;
    }

    @Property(viewable=true, order=11)
    public String getConflictResolution() {
        return this.conflictResolution;
    }

    @Property(viewable=true, order=12)
    public String getMode() {
        return this.mode;
    }

    @Property(viewable=true, order=13)
    public String getRole() {
        return this.role;
    }

    @Property(viewable=true, order=14)
    public int getOptions() {
        return this.options;
    }

    @Property(viewable=true, order=15)
    public String getRecoverable() {
        return this.recoverable;
    }

    @Property(viewable=true, order=16)
    public int getParallelApplierCount() {
        return this.parallelApplierCount;
    }

    @Property(viewable=true, order=20)
    public long getXsn() {
        return this.xsn;
    }

    @Property(viewable=true, order=30)
    public Timestamp getGiveUpTime() {
        return this.giveUpTime;
    }

    @Property(viewable=true, order=31)
    public long getGiveUpXsn() {
        return this.giveUpXsn;
    }

    @Property(viewable=true, order=32)
    public Timestamp getRemoteFaultDetectTime() {
        return this.remoteFaultDetectTime;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().getReplicationCache().refreshObject(monitor, (DBSObject)this.getDataSource(), this);
    }

    @Nullable
    public Object getLazyReference(Object propertyId) {
        return null;
    }

    public List<AltibaseReplicationItem> getReplicationItems(DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().getReplicationCache().getChildren(monitor, (DBSObject)this.getDataSource(), this);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)this.ddl)) {
            this.ddl = this.getDataSource().getMetaModel().getReplicationDDL(monitor, this, options);
        }
        return CommonUtils.isEmpty((String)this.ddl) ? "" : this.ddl + ";";
    }
}

