/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseGrantee;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTablespace;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AltibaseUser
extends AltibaseGrantee {
    private Timestamp lockDate;
    private Timestamp passwordexpiryDate;
    private int passwordGraceTime;
    private Object defaultTablespace;
    private Object tempTablespace;
    private Object profile;
    private Timestamp createDate;

    public AltibaseUser(AltibaseDataSource dataSource, JDBCResultSet resultSet) {
        super(dataSource, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"USER_NAME"));
        this.name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"USER_NAME");
        this.lockDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"ACCOUNT_LOCK_DATE");
        this.passwordexpiryDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"PASSWORD_EXPIRY_DATE");
        this.passwordGraceTime = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"PASSWORD_GRACE_TIME");
        this.defaultTablespace = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DEFAULT_TBS_NAME");
        this.tempTablespace = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TEMP_TBS_NAME");
        this.createDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CREATED");
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=5)
    @LazyProperty(cacheValidator=AltibaseTablespace.TablespaceReferenceValidator.class)
    public Object getDefaultTablespace(DBRProgressMonitor monitor) throws DBException {
        return AltibaseTablespace.resolveTablespaceReference(monitor, this, "defaultTablespace");
    }

    @Property(viewable=true, order=6)
    @LazyProperty(cacheValidator=AltibaseTablespace.TablespaceReferenceValidator.class)
    public Object getTempTablespace(DBRProgressMonitor monitor) throws DBException {
        return AltibaseTablespace.resolveTablespaceReference(monitor, this, "tempTablespace");
    }

    @Property(viewable=true, order=9)
    public Timestamp getLockDate() {
        return this.lockDate;
    }

    @Property(viewable=true, order=10)
    public Timestamp getPasswordexpiryDate() {
        return this.passwordexpiryDate;
    }

    @Property(viewable=true, order=11)
    public int getPasswordGraceTime() {
        return this.passwordGraceTime;
    }

    @Property(viewable=true, order=15)
    public Timestamp getCreateDate() {
        return this.createDate;
    }

    @Nullable
    public Object getLazyReference(Object propertyId) {
        if ("defaultTablespace".equals(propertyId)) {
            return this.defaultTablespace;
        }
        if ("tempTablespace".equals(propertyId)) {
            return this.tempTablespace;
        }
        if ("profile".equals(propertyId)) {
            return this.profile;
        }
        return null;
    }
}

