/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class AltibaseUtils {
    private static final Log log = Log.getLog(AltibaseUtils.class);

    static <PARENT extends DBSObject> Object resolveLazyReference(DBRProgressMonitor monitor, PARENT parent, DBSObjectCache<PARENT, ?> cache, DBSObjectLazy<?> referrer, Object propertyId) throws DBException {
        Object reference = referrer.getLazyReference(propertyId);
        if (reference instanceof String) {
            DBSObject object = monitor != null ? cache.getObject(monitor, parent, (String)reference) : cache.getCachedObject((String)reference);
            if (object != null) {
                return object;
            }
            log.warn((Object)("Object '" + String.valueOf(reference) + "' not found"));
            return reference;
        }
        return reference;
    }

    static boolean getViewStatus(JDBCSession session, String tableType, String schemaName, String objName) throws DBCException {
        boolean isValid = false;
        String qry = null;
        qry = "MATERIALIZED VIEW".equals(tableType) ? "SELECT v.status FROM system_.sys_users_ u, system_.sys_materialized_views_ m, system_.sys_views_ v WHERE u.user_id = m.user_id AND u.user_id = v.user_id AND v.view_id = m.view_id AND u.user_name = ? AND m.mview_name = ?" : "SELECT v.status FROM system_.sys_users_ u, system_.sys_tables_ t, system_.sys_views_ v WHERE u.user_id = t.user_id AND u.user_id = v.user_id AND v.view_id = t.table_id AND u.user_name = ? AND t.table_name = ?";
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement(qry);){
                dbStat.setString(1, schemaName);
                dbStat.setString(2, objName);
                dbStat.executeStatement();
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (JDBCResultSet dbResult = dbStat.getResultSet();){
                    if (dbResult != null && dbResult.next()) {
                        isValid = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (int)1, (String)"0");
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
        return isValid;
    }
}

