/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.ExasolSysTablePrefix;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolFunction;
import org.jkiss.dbeaver.ext.exasol.model.ExasolGlobalObject;
import org.jkiss.dbeaver.ext.exasol.model.ExasolScript;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableIndex;
import org.jkiss.dbeaver.ext.exasol.model.ExasolView;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTableCache;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTableForeignKeyCache;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTableIndexCache;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTableUniqueKeyCache;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolViewCache;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolGrantee;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolJDBCObjectSimpleCacheLiterals;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.ByteNumberFormat;

public class ExasolSchema
extends ExasolGlobalObject
implements DBSSchema,
DBPNamedObject2,
DBPRefreshableObject,
DBPSystemObject,
DBSProcedureContainer,
DBPScriptObject {
    private static final List<String> SYSTEM_SCHEMA = Arrays.asList("SYS", "EXA_STATISTICS");
    private static final Log log = Log.getLog(ExasolSchema.class);
    private String name;
    private String owner;
    private Timestamp createTime;
    private String remarks;
    private long objectId;
    private String tablePrefix;
    private BigDecimal rawObjectSize;
    private BigDecimal memObjectSize;
    private BigDecimal rawObjectSizeLimit;
    private Boolean refreshed = false;
    public final DBSObjectCache<ExasolSchema, ExasolScript> scriptCache;
    public final DBSObjectCache<ExasolSchema, ExasolFunction> functionCache;
    private ExasolViewCache viewCache = new ExasolViewCache();
    private ExasolTableCache tableCache = new ExasolTableCache();
    private final ExasolTableUniqueKeyCache constraintCache = new ExasolTableUniqueKeyCache(this.tableCache);
    private final ExasolTableForeignKeyCache associationCache = new ExasolTableForeignKeyCache(this.tableCache);
    private final ExasolTableIndexCache indexCache = new ExasolTableIndexCache(this.tableCache);

    public ExasolSchema(ExasolDataSource exasolDataSource, String name, String owner) {
        super(exasolDataSource, true);
        this.tablePrefix = exasolDataSource.getTablePrefix(ExasolSysTablePrefix.ALL);
        this.name = name;
        this.owner = owner;
        this.scriptCache = new ExasolJDBCObjectSimpleCacheLiterals(ExasolScript.class, "/*snapshot execution*/ select script_name,script_owner,script_language,script_type,script_result_type,script_text,script_comment,b.created from SYS." + this.tablePrefix + "_SCRIPTS a inner join SYS." + this.tablePrefix + "_OBJECTS b on a.SCRIPT_OBJECT_ID  = b.object_id and b.object_type = 'SCRIPT' where a.script_schema = '%s' order by script_name", name);
        this.functionCache = new ExasolJDBCObjectSimpleCacheLiterals(ExasolFunction.class, "/*snapshot execution*/ SELECT\n    F.*,\n    O.CREATED\nFROM\n    SYS." + this.tablePrefix + "_FUNCTIONS F\nINNER JOIN SYS." + this.tablePrefix + "_OBJECTS O ON\n    F.FUNCTION_OBJECT_ID = O.OBJECT_ID\nWHERE\n    F.FUNCTION_SCHEMA = '%s' and O.OBJECT_TYPE = 'FUNCTION' AND o.ROOT_NAME = '%s'\nORDER BY\n    FUNCTION_NAME\n", name, name);
    }

    public ExasolSchema(ExasolDataSource exasolDataSource, ResultSet dbResult) throws DBException {
        this(exasolDataSource, JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"OBJECT_NAME"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER"));
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_COMMENT");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_NAME");
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"SCHEMA_OBJECT_ID");
    }

    @Override
    @Property(viewable=true, editable=false, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<ExasolTableBase> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolTableBase> allChildren = new ArrayList<ExasolTableBase>();
        allChildren.addAll(this.tableCache.getAllObjects(monitor, this));
        allChildren.addAll(this.viewCache.getAllObjects(monitor, this));
        return allChildren;
    }

    public ExasolTableBase getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        ExasolTableBase child = (ExasolTableBase)this.tableCache.getObject(monitor, this, childName);
        if (child == null) {
            child = (ExasolTableBase)this.viewCache.getObject(monitor, this, childName);
        }
        return child;
    }

    @NotNull
    public Class<ExasolTable> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return ExasolTable.class;
    }

    public synchronized void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        if ((scope & 1) != 0) {
            monitor.subTask("Cache tables");
            this.tableCache.getAllObjects(monitor, this);
            monitor.subTask("Cache Views");
            this.viewCache.getAllObjects(monitor, this);
        }
        if ((scope & 2) != 0) {
            monitor.subTask("Cache table columns");
            this.tableCache.loadChildren(monitor, this, null);
            monitor.subTask("Cache Views");
            this.viewCache.loadChildren(monitor, this, null);
        }
        if ((scope & 4) != 0) {
            monitor.subTask("Cache table unique keys");
            this.constraintCache.getObjects(monitor, this, null);
            monitor.subTask("Cache table foreign keys");
            this.associationCache.getObjects(monitor, this, null);
            monitor.subTask("Cache Indexes");
            this.indexCache.getObjects(monitor, this, null);
        }
    }

    @Association
    public Collection<ExasolTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, this, ExasolTable.class);
    }

    public ExasolTable getTable(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolTable)this.tableCache.getObject(monitor, this, name, ExasolTable.class);
    }

    @Association
    public Collection<ExasolView> getViews(DBRProgressMonitor monitor) throws DBException {
        return this.viewCache.getTypedObjects(monitor, this, ExasolView.class);
    }

    public ExasolView getView(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolView)this.viewCache.getObject(monitor, this, name, ExasolView.class);
    }

    public boolean isSystem() {
        return SYSTEM_SCHEMA.contains(this.name);
    }

    public Collection<ExasolScript> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.scriptCache.getAllObjects(monitor, (DBSObject)this).stream().filter(o -> o.getType().equals("SCRIPTING")).collect(Collectors.toCollection(ArrayList::new));
    }

    public Collection<ExasolScript> getUdfs(DBRProgressMonitor monitor) throws DBException {
        return this.scriptCache.getAllObjects(monitor, (DBSObject)this).stream().filter(o -> o.getType().equals("UDF")).collect(Collectors.toCollection(ArrayList::new));
    }

    public ExasolScript getUdf(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolScript)this.scriptCache.getObject(monitor, (DBSObject)this, name);
    }

    public Collection<ExasolScript> getAdapter(DBRProgressMonitor monitor) throws DBException {
        return this.scriptCache.getAllObjects(monitor, (DBSObject)this).stream().filter(o -> o.getType().equals("ADAPTER")).collect(Collectors.toCollection(ArrayList::new));
    }

    public ExasolScript getAdapter(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolScript)this.scriptCache.getObject(monitor, (DBSObject)this, name);
    }

    public ExasolScript getProcedure(DBRProgressMonitor monitor, String uniqueName) throws DBException {
        return (ExasolScript)this.scriptCache.getObject(monitor, (DBSObject)this, uniqueName);
    }

    public Collection<ExasolFunction> getFunctions(DBRProgressMonitor monitor) throws DBException {
        return this.functionCache.getAllObjects(monitor, (DBSObject)this);
    }

    public ExasolFunction getFunction(DBRProgressMonitor monitor, String name) throws DBException {
        return (ExasolFunction)this.functionCache.getObject(monitor, (DBSObject)this, name);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.getDataSource().refreshObject(monitor);
        this.functionCache.clearCache();
        this.scriptCache.clearCache();
        this.tableCache.clearCache();
        this.viewCache.clearCache();
        this.indexCache.clearCache();
        this.constraintCache.clearCache();
        this.associationCache.clearCache();
        this.refreshed = false;
        return this;
    }

    public String toString() {
        return "Schema " + this.name;
    }

    private synchronized void refresh(DBRProgressMonitor monitor) throws DBCException {
        if (!this.refreshed.booleanValue() && this.objectId != 0L) {
            JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)ExasolMessages.read_schema_details);
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCPreparedStatement stmt = session.prepareStatement("/*snapshot execution*/ SELECT * FROM SYS." + this.getDataSource().getTablePrefix(ExasolSysTablePrefix.ALL) + "_OBJECT_SIZES WHERE OBJECT_ID = ?");){
                    stmt.setLong(1, this.objectId);
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCResultSet dbResult = stmt.executeQuery();){
                        if (dbResult.next()) {
                            this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
                            this.rawObjectSize = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"RAW_OBJECT_SIZE");
                            this.memObjectSize = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"MEM_OBJECT_SIZE");
                            this.rawObjectSizeLimit = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"RAW_OBJECT_SIZE_LIMIT");
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    this.refreshed = true;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
    }

    @Property(viewable=true, editable=false, order=2)
    public Timestamp getCreateTime(DBRProgressMonitor monitor) throws DBCException {
        this.refresh(monitor);
        return this.createTime;
    }

    @Override
    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=3)
    public String getDescription() {
        return this.remarks;
    }

    public void setDescription(String newRemarks) {
        this.remarks = newRemarks;
    }

    @Property(viewable=true, editable=false, updatable=true, order=4)
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, editable=false, updatable=false, order=5, formatter=ByteNumberFormat.class)
    public long getRawObjectSize() {
        if (this.rawObjectSize == null) {
            return -1L;
        }
        return this.rawObjectSize.longValue();
    }

    @Property(viewable=true, editable=false, updatable=false, order=6, formatter=ByteNumberFormat.class)
    public long getMemObjectSize() {
        if (this.memObjectSize == null) {
            return -1L;
        }
        return this.memObjectSize.longValue();
    }

    @Property(viewable=true, editable=true, updatable=true, order=7)
    public BigDecimal getRawObjectSizeLimit() {
        return this.rawObjectSizeLimit;
    }

    public void setRawObjectSizeLimit(BigDecimal limit) {
        this.rawObjectSizeLimit = limit;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ExasolTableCache getTableCache() {
        return this.tableCache;
    }

    public ExasolViewCache getViewCache() {
        return this.viewCache;
    }

    public ExasolTableUniqueKeyCache getConstraintCache() {
        return this.constraintCache;
    }

    public ExasolTableForeignKeyCache getAssociationCache() {
        return this.associationCache;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return ExasolUtils.generateDDLforSchema(monitor, this);
    }

    public Boolean isPhysicalSchema() {
        return true;
    }

    public ExasolTableIndexCache getIndexCache() {
        return this.indexCache;
    }

    @Association
    public Collection<ExasolTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return this.indexCache.getObjects(monitor, this, null);
    }

    public static class OwnerListProvider
    implements IPropertyValueListProvider<ExasolSchema> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(ExasolSchema object) {
            ExasolDataSource dataSource = object.getDataSource();
            try {
                Collection<ExasolGrantee> grantees = dataSource.getAllGrantees((DBRProgressMonitor)new VoidProgressMonitor());
                return grantees.toArray(new Object[grantees.size()]);
            }
            catch (DBException e) {
                log.error((Object)e);
                return new Object[0];
            }
        }
    }
}

