/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.wizard;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.DataSourceContextProvider;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.data.SQLQueryDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigPanel;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigPanelProvider;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigurator;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.dialogs.ObjectBrowserDialog;
import org.jkiss.utils.CommonUtils;

public class DataTransferTaskConfigurator
implements DBTTaskConfigurator,
DBTTaskConfigPanelProvider {
    private static final Log log = Log.getLog(DataTransferTaskConfigurator.class);

    public ConfigPanel createInputConfigurator(DBRRunnableContext runnableContext, @NotNull DBTTaskType taskType) {
        return new ConfigPanel(runnableContext, taskType);
    }

    public TaskConfigurationWizard<?> createTaskConfigWizard(@NotNull DBTTask taskConfiguration) {
        return DataTransferWizard.openWizard(taskConfiguration);
    }

    private static class ConfigPanel
    implements DBTTaskConfigPanel {
        private DBRRunnableContext runnableContext;
        private DBTTaskType taskType;
        private Table objectsTable;
        private DBPProject currentProject;
        private DataTransferWizard dtWizard;

        ConfigPanel(DBRRunnableContext runnableContext, DBTTaskType taskType) {
            this.runnableContext = runnableContext;
            this.taskType = taskType;
            this.currentProject = NavigatorUtils.getSelectedProject();
        }

        public DBPDataSource getLastDataSource() {
            int itemCount = this.objectsTable.getItemCount();
            if (itemCount <= 0) {
                return null;
            }
            DataTransferPipe pipe = (DataTransferPipe)this.objectsTable.getItem(itemCount - 1).getData();
            DBSObject databaseObject = this.getTableNode(pipe).getDatabaseObject();
            return databaseObject == null ? null : databaseObject.getDataSource();
        }

        public void createControl(Composite parent, TaskConfigurationWizard wizard, final Runnable propertyChangeListener) {
            this.dtWizard = (DataTransferWizard)wizard;
            final boolean isExport = this.isExport();
            final Group group = UIUtils.createControlGroup((Composite)parent, (String)("dataExport".equals(this.taskType.getId()) ? DTUIMessages.data_transfer_task_configurator_group_label_export_tables : DTUIMessages.data_transfer_task_configurator_group_label_import_into), (int)1, (int)1808, (int)0);
            this.objectsTable = new Table((Composite)group, 67588);
            this.objectsTable.setLayoutData((Object)new GridData(1808));
            this.objectsTable.setHeaderVisible(true);
            UIUtils.createTableColumn((Table)this.objectsTable, (int)0, (String)DTUIMessages.data_transfer_task_configurator_table_column_text_object);
            UIUtils.createTableColumn((Table)this.objectsTable, (int)0, (String)DTUIMessages.data_transfer_task_configurator_table_column_text_data_source);
            UIUtils.createTableContextMenu((Table)this.objectsTable, null);
            Composite buttonsPanel = UIUtils.createComposite((Composite)group, (int)(isExport ? 4 : 3));
            UIUtils.createDialogButton((Composite)buttonsPanel, (String)DTUIMessages.data_transfer_task_configurator_dialog_button_label_add_table, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    List tables;
                    DBPDataSource lastDataSource;
                    Class tableClass = isExport ? DBSDataContainer.class : DBSDataManipulator.class;
                    DBNProjectDatabases rootNode = currentProject.getNavigatorModel().getRoot().getProjectNode(currentProject).getDatabases();
                    DBNDataSource selNode = null;
                    if (objectsTable.getItemCount() > 0 && (lastDataSource = this.getLastDataSource()) != null) {
                        selNode = rootNode.getDataSource(lastDataSource.getContainer().getId());
                    }
                    if ((tables = ObjectBrowserDialog.selectObjects((Shell)group.getShell(), (String)(isExport ? DTUIMessages.data_transfer_task_configurator_tables_title_choose_source : DTUIMessages.data_transfer_task_configurator_tables_title_choose_target), (DBNNode)rootNode, (List)CommonUtils.singletonOrEmpty(selNode), (Class[])new Class[]{DBSInstance.class, DBSObjectContainer.class, tableClass}, (Class[])new Class[]{tableClass}, null)) != null) {
                        for (DBNNode node : tables) {
                            if (!(node instanceof DBNDatabaseNode)) continue;
                            DBSObject object = ((DBNDatabaseNode)node).getObject();
                            DataTransferPipe pipe = new DataTransferPipe((IDataTransferProducer)(isExport ? new DatabaseTransferProducer((DBSDataContainer)object) : null), (IDataTransferConsumer)(isExport ? null : new DatabaseTransferConsumer((DBSDataManipulator)object)));
                            this.addPipeToTable(pipe);
                        }
                        this.updateSettings(propertyChangeListener);
                    }
                }
            });
            if (isExport) {
                UIUtils.createDialogButton((Composite)buttonsPanel, (String)DTUIMessages.data_transfer_task_configurator_dialog_button_label_add_query, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DBNNode node;
                        DBPDataSource lastDataSource;
                        DBPDataSource dataSourceObject = null;
                        DBPDataSource dataSource = null;
                        DBNProjectDatabases rootNode = currentProject.getNavigatorModel().getRoot().getProjectNode(currentProject).getDatabases();
                        DBNDataSource selNode = null;
                        if (objectsTable.getItemCount() > 0 && (lastDataSource = this.getLastDataSource()) != null) {
                            selNode = rootNode.getDataSource(lastDataSource.getContainer().getId());
                        }
                        if ((node = ObjectBrowserDialog.selectObject((Shell)group.getShell(), (String)DTUIMessages.data_transfer_task_configurator_tables_title_choose_source, (DBNNode)rootNode, (DBNNode)selNode, (Class[])new Class[]{DBSInstance.class, DBSObjectContainer.class}, (Class[])new Class[]{DBPDataSource.class, DBSCatalog.class, DBSSchema.class}, null)) != null) {
                            if (node instanceof DBNDataSource) {
                                dataSourceObject = ((DBNDataSource)node).getDataSource();
                                dataSource = ((DBNDataSource)node).getDataSource();
                            } else if (node instanceof DBNDatabaseItem) {
                                dataSourceObject = ((DBNDatabaseItem)node).getObject();
                                dataSource = dataSourceObject.getDataSource();
                            } else {
                                log.debug((Object)("Unhandled node type: " + String.valueOf(node)));
                                return;
                            }
                        }
                        if (dataSource != null) {
                            String query;
                            String newObjectName;
                            String newInstanceName;
                            DBPDataSourceContainer dataSourceContainer = DBUtils.getContainer(dataSource);
                            if (dataSourceContainer != null && !dataSourceContainer.isConnected()) {
                                try {
                                    runnableContext.run(true, true, monitor -> {
                                        try {
                                            dataSourceContainer.connect(monitor, true, true);
                                        }
                                        catch (DBException ex) {
                                            throw new InvocationTargetException(ex);
                                        }
                                    });
                                }
                                catch (InvocationTargetException ex) {
                                    DBWorkbench.getPlatformUI().showError(DTUIMessages.data_transfer_task_configurator_title_error_opening_data_source, DTUIMessages.data_transfer_task_configurator_message_error_while_opening_data_source, (Throwable)ex);
                                    return;
                                }
                                catch (InterruptedException interruptedException) {
                                    return;
                                }
                            }
                            if (dataSourceObject instanceof DBSCatalog) {
                                newInstanceName = dataSourceObject.getName();
                                newObjectName = null;
                            } else if (dataSourceObject instanceof DBSSchema) {
                                DBSObject parentObject = dataSourceObject.getParentObject();
                                newInstanceName = parentObject instanceof DBSCatalog ? parentObject.getName() : null;
                                newObjectName = dataSourceObject.getName();
                            } else {
                                newInstanceName = null;
                                newObjectName = null;
                            }
                            DataSourceContextProvider contextProvider = new DataSourceContextProvider((DBSObject)dataSourceObject);
                            DBCExecutionContext executionContext = contextProvider.getExecutionContext();
                            String oldInstanceName = null;
                            String oldObjectName = null;
                            if (executionContext instanceof DBCExecutionContextDefaults) {
                                DBSSchema defaultSchema;
                                DBCExecutionContextDefaults contextDefaults = (DBCExecutionContextDefaults)executionContext;
                                DBSCatalog defaultCatalog = contextDefaults.getDefaultCatalog();
                                if (defaultCatalog != null) {
                                    oldInstanceName = defaultCatalog.getName();
                                }
                                if ((defaultSchema = contextDefaults.getDefaultSchema()) != null) {
                                    oldObjectName = defaultSchema.getName();
                                }
                            }
                            try {
                                DBExecUtils.setExecutionContextDefaults((DBRProgressMonitor)new VoidProgressMonitor(), (DBPDataSource)dataSource, (DBCExecutionContext)executionContext, (String)newInstanceName, null, (String)newObjectName);
                            }
                            catch (DBException ex) {
                                log.error((Object)"Error setting context defaults", (Throwable)ex);
                                return;
                            }
                            UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
                            if (serviceSQL != null && (query = serviceSQL.openSQLEditor((DBPContextProvider)contextProvider, DTUIMessages.data_transfer_task_configurator_sql_query_title, (DBPImage)DBIcon.TREE_SCRIPT, "")) != null) {
                                SQLScriptContext scriptContext = new SQLScriptContext(null, (DBPContextProvider)contextProvider, null, (Writer)new PrintWriter(System.err, true), null);
                                SQLQueryDataContainer container = new SQLQueryDataContainer((DBPContextProvider)contextProvider, new SQLQuery(dataSource, query), scriptContext, log);
                                DatabaseTransferProducer producer = new DatabaseTransferProducer((DBSDataContainer)container);
                                producer.setDefaultCatalog(newInstanceName);
                                producer.setDefaultSchema(newObjectName);
                                DataTransferPipe pipe = new DataTransferPipe((IDataTransferProducer)producer, null);
                                this.addPipeToTable(pipe);
                                this.updateSettings(propertyChangeListener);
                            }
                            try {
                                DBExecUtils.setExecutionContextDefaults((DBRProgressMonitor)new VoidProgressMonitor(), (DBPDataSource)dataSource, (DBCExecutionContext)executionContext, (String)oldInstanceName, null, (String)oldObjectName);
                            }
                            catch (DBException ex) {
                                log.error((Object)"Error setting context defaults", (Throwable)ex);
                            }
                        }
                    }
                });
            }
            final Button editButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)DTMessages.data_transfer_wizard_settings_button_edit, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem item = objectsTable.getItem(objectsTable.getSelectionIndex());
                    DataTransferPipe pipe = (DataTransferPipe)item.getData();
                    IDataTransferProducer producer = pipe.getProducer();
                    if (producer instanceof DatabaseTransferProducer && producer.getDatabaseObject() instanceof SQLQueryDataContainer) {
                        String query;
                        DBPDataSource dataSource = producer.getDatabaseObject().getDataSource();
                        DataSourceContextProvider contextProvider = new DataSourceContextProvider(producer.getDatabaseObject());
                        UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
                        if (serviceSQL != null && (query = serviceSQL.openSQLEditor((DBPContextProvider)contextProvider, DTUIMessages.data_transfer_task_configurator_sql_query_title, (DBPImage)DBIcon.TREE_SCRIPT, ((SQLQueryDataContainer)producer.getDatabaseObject()).getQuery().getText())) != null) {
                            SQLQueryDataContainer container = (SQLQueryDataContainer)producer.getDatabaseObject();
                            container.setQuery(new SQLQuery(dataSource, query));
                            IDataTransferNode node = this.getTableNode(pipe);
                            item.setText(node.getObjectName());
                        }
                    }
                }
            });
            final Button removeButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)DTUIMessages.data_transfer_task_configurator_dialog_button_label_remove, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DataTransferPipe object = (DataTransferPipe)objectsTable.getItem(objectsTable.getSelectionIndex()).getData();
                    if (UIUtils.confirmAction((String)DTUIMessages.data_transfer_task_configurator_confirm_action_title, (String)NLS.bind((String)DTUIMessages.data_transfer_task_configurator_confirm_action_question, (Object)CommonUtils.truncateString((String)this.getTableNode(object).getObjectName(), (int)255)))) {
                        objectsTable.remove(objectsTable.getSelectionIndex());
                        this.updateSettings(propertyChangeListener);
                    }
                }
            });
            editButton.setEnabled(false);
            removeButton.setEnabled(false);
            this.objectsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int selectionIndex = objectsTable.getSelectionIndex();
                    DataTransferPipe pipe = selectionIndex >= 0 ? (DataTransferPipe)objectsTable.getItem(selectionIndex).getData() : null;
                    editButton.setEnabled(pipe != null && pipe.getProducer() instanceof DatabaseTransferProducer && pipe.getProducer().getDatabaseObject() instanceof SQLQueryDataContainer);
                    removeButton.setEnabled(pipe != null);
                }
            });
        }

        private void updateSettings(Runnable propertyChangeListener) {
            this.saveSettings();
            propertyChangeListener.run();
            UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.objectsTable, (boolean)true));
        }

        private boolean isExport() {
            return this.taskType.getId().equals("dataExport");
        }

        public void loadSettings() {
            this.dtWizard.loadNodeSettings();
            DataTransferSettings settings = this.dtWizard.getSettings();
            for (DataTransferPipe pipe : settings.getDataPipes()) {
                this.addPipeToTable(pipe);
            }
            UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.objectsTable, (boolean)true));
        }

        private void addPipeToTable(DataTransferPipe pipe) {
            IDataTransferNode node = this.getTableNode(pipe);
            TableItem item = new TableItem(this.objectsTable, 0);
            item.setData((Object)pipe);
            item.setImage(0, DBeaverIcons.getImage((DBPImage)node.getObjectIcon()));
            item.setText(0, CommonUtils.getSingleLineString((String)CommonUtils.toString((Object)node.getObjectName(), (String)"?")));
            if (node.getDataSourceContainer() != null) {
                item.setText(1, node.getDataSourceContainer().getName());
                DBPImage dsIcon = node.getObjectContainerIcon();
                if (dsIcon != null) {
                    item.setImage(1, DBeaverIcons.getImage((DBPImage)dsIcon));
                }
            }
            if (node.getDatabaseObject() == null) {
                item.setBackground(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("org.jkiss.dbeaver.txn.color.reverted.background"));
            }
        }

        private IDataTransferNode getTableNode(DataTransferPipe pipe) {
            return this.isExport() ? pipe.getProducer() : pipe.getConsumer();
        }

        public void saveSettings() {
            if (this.objectsTable == null) {
                return;
            }
            DataTransferSettings settings = this.dtWizard.getSettings();
            ArrayList<DataTransferPipe> dataPipes = new ArrayList<DataTransferPipe>();
            TableItem[] tableItemArray = this.objectsTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                dataPipes.add((DataTransferPipe)item.getData());
                ++n2;
            }
            settings.setDataPipes(dataPipes, this.isExport());
            this.dtWizard.loadSettings();
        }

        public boolean isComplete() {
            if (this.objectsTable.getItemCount() == 0) {
                return false;
            }
            for (DataTransferPipe pipe : this.dtWizard.getSettings().getDataPipes()) {
                if (!(this.dtWizard.getSettings().isProducerOptional() || pipe.getProducer() != null && pipe.getProducer().isConfigurationComplete())) {
                    return false;
                }
                if (this.dtWizard.getSettings().isConsumerOptional() || pipe.getConsumer() != null && pipe.getConsumer().isConfigurationComplete()) continue;
                return false;
            }
            return this.objectsTable.getItemCount() > 0;
        }

        public String getErrorMessage() {
            if (this.objectsTable.getItemCount() == 0) {
                return DTUIMessages.data_transfer_error_no_objects_selected;
            }
            for (DataTransferPipe pipe : this.dtWizard.getSettings().getDataPipes()) {
                if (!(this.dtWizard.getSettings().isProducerOptional() || pipe.getProducer() != null && pipe.getProducer().isConfigurationComplete())) {
                    return NLS.bind((String)DTUIMessages.data_transfer_error_source_not_specified, (Object)(pipe.getConsumer() == null ? "?" : pipe.getConsumer().getObjectName()));
                }
                if (this.dtWizard.getSettings().isConsumerOptional() || pipe.getConsumer() != null && pipe.getConsumer().isConfigurationComplete()) continue;
                return NLS.bind((String)DTUIMessages.data_transfer_error_target_not_specified, (Object)(pipe.getProducer() == null ? "?" : pipe.getProducer().getObjectName()));
            }
            return null;
        }
    }
}

