/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.format.tokenized;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterConfiguration;
import org.jkiss.dbeaver.model.sql.format.tokenized.FormatterToken;
import org.jkiss.dbeaver.model.sql.format.tokenized.TokenType;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

class SQLTokensParser {
    private static final String[] twoCharacterSymbol = new String[]{"<>", "<=", ">=", "||", "()", "!=", ":=", ".*"};
    private final SQLFormatterConfiguration configuration;
    private final String[][] quoteStrings;
    private String fBefore;
    private int fPos;
    private char structSeparator;
    private String catalogSeparator;
    private Set<String> commands = new HashSet<String>();
    private String[] singleLineComments;
    private char[] singleLineCommentStart;

    public SQLTokensParser(SQLFormatterConfiguration configuration) {
        this.configuration = configuration;
        this.structSeparator = configuration.getSyntaxManager().getStructSeparator();
        this.catalogSeparator = configuration.getSyntaxManager().getCatalogSeparator();
        this.quoteStrings = configuration.getSyntaxManager().getIdentifierQuoteStrings();
        this.singleLineComments = configuration.getSyntaxManager().getDialect().getSingleLineComments();
        this.singleLineCommentStart = new char[this.singleLineComments.length];
        int i = 0;
        while (i < this.singleLineComments.length) {
            this.singleLineCommentStart[i] = this.singleLineComments[i].isEmpty() ? (char)'\u0000' : this.singleLineComments[i].charAt(0);
            ++i;
        }
        String delimiterRedefiner = configuration.getSyntaxManager().getDialect().getScriptDelimiterRedefiner();
        if (ArrayUtils.contains((Object[])configuration.getSyntaxManager().getDialect().getScriptDelimiters(), (Object)delimiterRedefiner)) {
            delimiterRedefiner = null;
        }
        if (!CommonUtils.isEmpty((String)delimiterRedefiner)) {
            this.commands.add(delimiterRedefiner.toUpperCase(Locale.ENGLISH));
        }
    }

    public static boolean isSpace(char argChar) {
        return Character.isWhitespace(argChar);
    }

    public static boolean isLetter(char argChar) {
        return !SQLTokensParser.isSpace(argChar) && !SQLTokensParser.isDigit(argChar) && !SQLTokensParser.isSymbol(argChar);
    }

    public static boolean isDigit(char argChar) {
        return Character.isDigit(argChar);
    }

    public static boolean isSymbol(char argChar) {
        switch (argChar) {
            case '!': 
            case '\"': 
            case '#': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '[': 
            case ']': 
            case '`': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    FormatterToken nextToken() {
        int start_pos = this.fPos;
        if (this.fPos >= this.fBefore.length()) {
            ++this.fPos;
            return new FormatterToken(TokenType.END, "", start_pos);
        }
        char fChar = this.fBefore.charAt(this.fPos);
        if (SQLTokensParser.isSpace(fChar)) {
            StringBuilder workString = new StringBuilder();
            while (this.fPos < this.fBefore.length()) {
                fChar = this.fBefore.charAt(this.fPos);
                if (!SQLTokensParser.isSpace(fChar)) break;
                workString.append(fChar);
                ++this.fPos;
            }
            return new FormatterToken(TokenType.SPACE, workString.toString(), start_pos);
        }
        if (fChar == ';') {
            ++this.fPos;
            return new FormatterToken(TokenType.SYMBOL, ";", start_pos);
        }
        if (SQLTokensParser.isDigit(fChar)) {
            int startPosition = this.fPos;
            StringBuilder s = new StringBuilder();
            int radix = 10;
            while (CommonUtils.isDigit((int)fChar, (int)radix) || radix == 10 && (fChar == '.' || fChar == 'e' || fChar == 'E')) {
                s.append(fChar);
                ++this.fPos;
                if (this.fPos >= this.fBefore.length()) break;
                if (fChar == '0' && this.fPos + 1 < this.fBefore.length() && ((fChar = this.fBefore.charAt(this.fPos)) == 'x' || fChar == 'X')) {
                    radix = 16;
                    s.append(fChar);
                    ++this.fPos;
                }
                fChar = this.fBefore.charAt(this.fPos);
            }
            if (SQLTokensParser.isLetter(fChar) && this.configuration.getSyntaxManager().getDialect().validIdentifierStart(this.fBefore.charAt(startPosition))) {
                return this.parseNameStartWithDigit(startPosition);
            }
            return new FormatterToken(TokenType.VALUE, s.toString(), start_pos);
        }
        if (ArrayUtils.contains((char[])this.singleLineCommentStart, (char)fChar)) {
            ++this.fPos;
            String commentString = null;
            String[] stringArray = this.singleLineComments;
            int n = this.singleLineComments.length;
            int radix = 0;
            while (radix < n) {
                String slc = stringArray[radix];
                if (this.fBefore.length() >= start_pos + slc.length() && slc.equals(this.fBefore.substring(start_pos, start_pos + slc.length()))) {
                    commentString = slc;
                    break;
                }
                ++radix;
            }
            if (commentString == null) {
                return new FormatterToken(TokenType.SYMBOL, String.valueOf(fChar), start_pos);
            }
            this.fPos += commentString.length() - 1;
            while (this.fPos < this.fBefore.length()) {
                ++this.fPos;
                if (this.fBefore.substring(this.fPos).startsWith(System.lineSeparator())) break;
            }
            commentString = this.fBefore.substring(start_pos, this.fPos);
            return new FormatterToken(TokenType.COMMENT, commentString, start_pos);
        }
        if (SQLTokensParser.isLetter(fChar)) {
            StringBuilder s = new StringBuilder();
            this.fPos = this.readWord(s, this.fPos);
            String word = s.toString();
            if (this.commands.contains(word.toUpperCase(Locale.ENGLISH))) {
                s.setLength(0);
                while (this.fPos < this.fBefore.length()) {
                    fChar = this.fBefore.charAt(this.fPos);
                    if (fChar == '\n' || fChar == '\r') break;
                    s.append(fChar);
                    ++this.fPos;
                }
                return new FormatterToken(TokenType.COMMAND, word + s.toString(), start_pos);
            }
            if (this.configuration.getSyntaxManager().getDialect().getKeywordType(word) == DBPKeywordType.KEYWORD) {
                return new FormatterToken(TokenType.KEYWORD, word, start_pos);
            }
            return new FormatterToken(TokenType.NAME, word, start_pos);
        }
        if (fChar == '/') {
            char ch0;
            ++this.fPos;
            char ch2 = this.fBefore.charAt(this.fPos);
            if (ch2 != '*') {
                return new FormatterToken(TokenType.SYMBOL, "/", start_pos);
            }
            StringBuilder s = new StringBuilder("/*");
            ++this.fPos;
            do {
                ch0 = fChar;
                fChar = this.fBefore.charAt(this.fPos);
                s.append(fChar);
                ++this.fPos;
            } while (ch0 != '*' || fChar != '/');
            return new FormatterToken(TokenType.COMMENT, s.toString(), start_pos);
        }
        if (fChar == '\'' || this.isQuoteChar(fChar)) {
            ++this.fPos;
            char endQuoteChar = fChar;
            if (this.quoteStrings != null) {
                String[][] stringArray = this.quoteStrings;
                int n = this.quoteStrings.length;
                int ch0 = 0;
                while (ch0 < n) {
                    String[] quoteString = stringArray[ch0];
                    if (quoteString[0].charAt(0) == endQuoteChar) {
                        endQuoteChar = quoteString[1].charAt(0);
                        break;
                    }
                    ++ch0;
                }
            }
            StringBuilder s = new StringBuilder();
            s.append(fChar);
            int posMark = this.fPos;
            while (this.fPos < this.fBefore.length()) {
                char fNextChar;
                fChar = this.fBefore.charAt(this.fPos);
                s.append(fChar);
                ++this.fPos;
                char c = fNextChar = this.fPos >= this.fBefore.length() - 1 ? (char)'\u0000' : this.fBefore.charAt(this.fPos);
                if (fChar == endQuoteChar && fNextChar == endQuoteChar) {
                    s.append(fChar);
                    ++this.fPos;
                    continue;
                }
                if (fChar != endQuoteChar) continue;
                return new FormatterToken(TokenType.VALUE, s.toString(), start_pos);
            }
            this.fPos = posMark;
            return new FormatterToken(TokenType.SYMBOL, String.valueOf(s.charAt(0)), start_pos);
        }
        if (SQLTokensParser.isSymbol(fChar)) {
            Object s = String.valueOf(fChar);
            ++this.fPos;
            if (this.fPos >= this.fBefore.length()) {
                return new FormatterToken(TokenType.SYMBOL, (String)s, start_pos);
            }
            char ch2 = this.fBefore.charAt(this.fPos);
            int i = 0;
            while (i < twoCharacterSymbol.length) {
                if (twoCharacterSymbol[i].charAt(0) == fChar && twoCharacterSymbol[i].charAt(1) == ch2) {
                    ++this.fPos;
                    s = (String)s + ch2;
                    break;
                }
                ++i;
            }
            return new FormatterToken(TokenType.SYMBOL, (String)s, start_pos);
        }
        ++this.fPos;
        return new FormatterToken(TokenType.UNKNOWN, String.valueOf(fChar), start_pos);
    }

    @NotNull
    private FormatterToken parseNameStartWithDigit(int startPosition) {
        StringBuilder s = new StringBuilder();
        this.fPos = this.readWord(s, startPosition);
        String word = s.toString();
        return new FormatterToken(TokenType.NAME, word, startPosition);
    }

    private int readWord(@NotNull StringBuilder s, int startPosition) {
        char firstChar = this.fBefore.charAt(startPosition);
        int position = startPosition;
        while (SQLTokensParser.isLetter(firstChar) || SQLTokensParser.isDigit(firstChar) || firstChar == '*' && position > 0 && this.fBefore.charAt(position - 1) == this.structSeparator || this.structSeparator == firstChar || this.catalogSeparator.indexOf(firstChar) != -1) {
            s.append(firstChar);
            if (++position >= this.fBefore.length()) break;
            firstChar = this.fBefore.charAt(position);
        }
        return position;
    }

    private boolean isQuoteChar(char fChar) {
        if (this.quoteStrings != null) {
            int i = 0;
            while (i < this.quoteStrings.length) {
                if (this.quoteStrings[i][0].charAt(0) == fChar) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public List<FormatterToken> parse(String argSql) {
        FormatterToken token;
        this.fPos = 0;
        this.fBefore = argSql;
        ArrayList<FormatterToken> list = new ArrayList<FormatterToken>();
        while ((token = this.nextToken()).getType() != TokenType.END) {
            list.add(token);
        }
        return list;
    }
}

