/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.lsm.LSMAnalyzer;
import org.jkiss.dbeaver.model.lsm.LSMAnalyzerParameters;
import org.jkiss.dbeaver.model.lsm.sql.dialect.LSMDialectRegistry;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.semantics.DirectedGraph;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryExpressionMapper;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDummyDataSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryObjectDropModel;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableAlterModel;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableCreateModel;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableDropModel;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryDeleteModel;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryInsertModel;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryUpdateModel;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueColumnReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueConstantExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueFlattenedExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueIndexingExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueMemberExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueSubqueryExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueTupleReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueTypeCastExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueVariableExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.STMErrorListener;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMSkippingErrorListener;
import org.jkiss.dbeaver.model.stm.STMSource;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMTreeRuleNode;
import org.jkiss.dbeaver.model.stm.STMTreeTermNode;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.Pair;

public class SQLQueryModelRecognizer {
    private final Set<SQLQuerySymbolEntry> symbolEntries = new HashSet<SQLQuerySymbolEntry>();
    private final SQLQueryRecognitionContext recognitionContext;
    private final DBCExecutionContext executionContext;
    private final Set<String> reservedWords;
    private final SQLDialect dialect;
    private final LinkedList<SQLQueryLexicalScope> currentLexicalScopes = new LinkedList();
    private SQLQueryDataContext queryDataContext;
    @NotNull
    private static final Set<String> columnNameListWrapperNames = Set.of(STMKnownRuleNames.correspondingSpec, STMKnownRuleNames.referencedTableAndColumns, STMKnownRuleNames.correlationSpecification, STMKnownRuleNames.nonjoinedTableReference, STMKnownRuleNames.namedColumnsJoin, STMKnownRuleNames.joinSpecification, STMKnownRuleNames.naturalJoinTerm, STMKnownRuleNames.unionTerm, STMKnownRuleNames.exceptTerm, STMKnownRuleNames.intersectTerm, STMKnownRuleNames.uniqueConstraintDefinition, STMKnownRuleNames.createViewStatement, STMKnownRuleNames.insertColumnsAndSource, STMKnownRuleNames.referenceColumnList, STMKnownRuleNames.referencingColumns, STMKnownRuleNames.derivedColumnList, STMKnownRuleNames.joinColumnList, STMKnownRuleNames.correspondingColumnList, STMKnownRuleNames.uniqueColumnList, STMKnownRuleNames.viewColumnList, STMKnownRuleNames.insertColumnList);
    private static final Set<String> identifierDirectWrapperNames = Set.of(STMKnownRuleNames.unqualifiedSchemaName, STMKnownRuleNames.catalogName, STMKnownRuleNames.correlationName, STMKnownRuleNames.authorizationIdentifier, STMKnownRuleNames.columnName, STMKnownRuleNames.queryName);
    private static final Set<String> tableNameContainers = Set.of(STMKnownRuleNames.referencedTableAndColumns, STMKnownRuleNames.qualifier, STMKnownRuleNames.nonjoinedTableReference, STMKnownRuleNames.explicitTable, STMKnownRuleNames.createTableStatement, STMKnownRuleNames.createViewStatement, STMKnownRuleNames.alterTableStatement, STMKnownRuleNames.dropTableStatement, STMKnownRuleNames.dropViewStatement, STMKnownRuleNames.deleteStatement, STMKnownRuleNames.insertStatement, STMKnownRuleNames.updateStatement, STMKnownRuleNames.correlationSpecification);
    private static final Set<String> actualTableNameContainers = Set.of(STMKnownRuleNames.tableName, STMKnownRuleNames.correlationName);
    private static final Set<String> qualifiedNameDirectWrapperNames = Set.of(STMKnownRuleNames.tableName, STMKnownRuleNames.constraintName);
    private static final Set<String> knownValueExpressionRootNames = Set.of(STMKnownRuleNames.valueExpression, STMKnownRuleNames.valueExpressionAtom, STMKnownRuleNames.searchCondition, STMKnownRuleNames.havingClause, STMKnownRuleNames.whereClause, STMKnownRuleNames.groupByClause, STMKnownRuleNames.orderByClause, STMKnownRuleNames.rowValueConstructor, STMKnownRuleNames.defaultClause, STMKnownRuleNames.checkConstraintDefinition);
    private static final Set<String> knownRecognizableValueExpressionNames = Set.of(STMKnownRuleNames.subquery, STMKnownRuleNames.columnReference, STMKnownRuleNames.valueReference, STMKnownRuleNames.variableExpression, STMKnownRuleNames.truthValue, STMKnownRuleNames.unsignedNumericLiteral, STMKnownRuleNames.signedNumericLiteral, STMKnownRuleNames.characterStringLiteral, STMKnownRuleNames.datetimeLiteral, STMKnownRuleNames.columnIndex);

    private SQLQueryModelRecognizer(@NotNull SQLQueryRecognitionContext recognitionContext) {
        this.recognitionContext = recognitionContext;
        this.executionContext = recognitionContext.getExecutionContext();
        this.dialect = this.executionContext != null && this.executionContext.getDataSource() != null ? this.executionContext.getDataSource().getSQLDialect() : BasicSQLDialect.INSTANCE;
        this.reservedWords = new HashSet<String>(this.dialect.getReservedWords());
    }

    public SQLQueryDataContext getQueryDataContext() {
        return this.queryDataContext;
    }

    @Nullable
    private SQLQueryModel recognizeQuery(@NotNull String text) {
        SQLQueryModelContent contents;
        STMSource querySource = STMSource.fromString((String)text);
        LSMAnalyzer analyzer = LSMDialectRegistry.getInstance().getAnalyzerFactoryForDialect(this.dialect).createAnalyzer(LSMAnalyzerParameters.forDialect((SQLDialect)this.dialect, (SQLSyntaxManager)this.recognitionContext.getSyntaxManager()));
        STMTreeRuleNode tree = analyzer.parseSqlQueryTree(querySource, (STMErrorListener)new STMSkippingErrorListener());
        if (tree == null) {
            return null;
        }
        this.queryDataContext = this.prepareDataContext((STMTreeNode)tree);
        STMTreeNode queryNode = tree.getFirstStmChild();
        if (queryNode == null) {
            return null;
        }
        block0 : switch (queryNode.getNodeKindId()) {
            case 2: {
                SQLQueryModelContent sQLQueryModelContent;
                STMTreeNode stmtBodyNode = queryNode.getLastStmtChild();
                switch (stmtBodyNode.getNodeKindId()) {
                    case 243: {
                        sQLQueryModelContent = SQLQueryDeleteModel.recognize(this, stmtBodyNode);
                        break block0;
                    }
                    case 244: {
                        sQLQueryModelContent = SQLQueryInsertModel.recognize(this, stmtBodyNode);
                        break block0;
                    }
                    case 247: {
                        sQLQueryModelContent = SQLQueryUpdateModel.recognize(this, stmtBodyNode);
                        break block0;
                    }
                }
                sQLQueryModelContent = this.collectQueryExpression((STMTreeNode)tree);
                break;
            }
            case 207: {
                SQLQueryModelContent sQLQueryModelContent;
                STMTreeNode stmtBodyNode = queryNode.getFirstStmChild();
                switch (stmtBodyNode.getNodeKindId()) {
                    case 214: {
                        sQLQueryModelContent = SQLQueryTableCreateModel.recognize(this, stmtBodyNode);
                        break block0;
                    }
                    case 220: {
                        sQLQueryModelContent = null;
                        break block0;
                    }
                    case 236: {
                        sQLQueryModelContent = SQLQueryTableDropModel.recognize(this, stmtBodyNode, false);
                        break block0;
                    }
                    case 237: {
                        sQLQueryModelContent = SQLQueryTableDropModel.recognize(this, stmtBodyNode, true);
                        break block0;
                    }
                    case 238: {
                        sQLQueryModelContent = SQLQueryObjectDropModel.recognize(this, stmtBodyNode, RelationalObjectType.TYPE_PROCEDURE);
                        break block0;
                    }
                    case 225: {
                        sQLQueryModelContent = SQLQueryTableAlterModel.recognize(this, stmtBodyNode);
                        break block0;
                    }
                }
                sQLQueryModelContent = null;
                break;
            }
            default: {
                SQLQueryModelContent sQLQueryModelContent = contents = null;
            }
        }
        if (contents != null) {
            SQLQueryModel model = new SQLQueryModel((STMTreeNode)tree, contents, this.symbolEntries);
            model.propagateContext(this.queryDataContext, this.recognitionContext);
            int actualTailPosition = model.getSyntaxNode().getRealInterval().b;
            SQLQueryNodeModel tailNode = model.findNodeContaining(actualTailPosition);
            if (tailNode != model) {
                SQLQueryLexicalScope nodeScope = tailNode.findLexicalScope(actualTailPosition);
                SQLQueryLexicalScope tailScope = new SQLQueryLexicalScope();
                tailScope.setInterval(Interval.of((int)actualTailPosition, (int)Integer.MAX_VALUE));
                tailScope.setContext(nodeScope != null && nodeScope.getContext() != null ? nodeScope.getContext() : tailNode.getGivenDataContext());
                model.registerLexicalScope(tailScope);
            }
            return model;
        }
        Predicate<SQLQuerySymbolEntry> tryFallbackForStringLiteral = s -> {
            boolean forced;
            String rawString = s.getRawName();
            SQLQuerySymbolClass forcedClass = this.dialect.isQuotedString(rawString) ? SQLQuerySymbolClass.STRING : SQLQueryModelRecognizer.tryFallbackSymbolForStringLiteral(this.dialect, s, false);
            boolean bl = forced = forcedClass != null;
            if (forced) {
                s.getSymbol().setSymbolClass(forcedClass);
            }
            return forced;
        };
        this.traverseForIdentifiers((STMTreeNode)tree, (e, c) -> {
            if (c.isNotClassified() && (e != null || !tryFallbackForStringLiteral.test((SQLQuerySymbolEntry)c))) {
                c.getSymbol().setSymbolClass(SQLQuerySymbolClass.COLUMN);
            }
        }, e -> {
            if (e.isNotClassified() && (e.catalogName != null || e.schemaName != null || !tryFallbackForStringLiteral.test(e.entityName))) {
                e.entityName.getSymbol().setSymbolClass(SQLQuerySymbolClass.TABLE);
                if (e.schemaName != null) {
                    e.schemaName.getSymbol().setSymbolClass(SQLQuerySymbolClass.SCHEMA);
                    if (e.catalogName != null) {
                        e.catalogName.getSymbol().setSymbolClass(SQLQuerySymbolClass.CATALOG);
                    }
                }
            }
        }, false);
        return new SQLQueryModel((STMTreeNode)tree, null, this.symbolEntries);
    }

    private void traverseForIdentifiers(@NotNull STMTreeNode root, @NotNull BiConsumer<SQLQueryQualifiedName, SQLQuerySymbolEntry> columnAction, @NotNull Consumer<SQLQueryQualifiedName> entityAction, boolean forceUnquotted) {
        List refs = STMUtils.expandSubtree((STMTreeNode)root, null, Set.of(STMKnownRuleNames.columnReference, STMKnownRuleNames.columnName, STMKnownRuleNames.tableName));
        block4: for (STMTreeNode ref : refs) {
            switch (ref.getNodeKindId()) {
                case 34: 
                case 88: {
                    STMTreeNode columnName;
                    SQLQueryQualifiedName tableName;
                    if (ref.getChildCount() > 1) {
                        tableName = this.collectTableName(ref.getFirstStmChild(), forceUnquotted);
                        if (tableName != null) {
                            entityAction.accept(tableName);
                        }
                    } else {
                        tableName = null;
                    }
                    STMTreeNode sTMTreeNode = columnName = ref.getNodeKindId() == 34 ? ref : ref.findChildOfName(STMKnownRuleNames.columnName);
                    if (columnName == null) continue block4;
                    columnAction.accept(tableName, this.collectIdentifier(columnName, forceUnquotted));
                    break;
                }
                case 46: {
                    SQLQueryQualifiedName tableName = this.collectTableName(ref, forceUnquotted);
                    if (tableName == null) continue block4;
                    entityAction.accept(tableName);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + ref.getNodeName());
                }
            }
        }
    }

    @NotNull
    private SQLQueryDataContext prepareDataContext(@NotNull STMTreeNode root) {
        if (this.recognitionContext.useRealMetadata() && this.executionContext != null && this.executionContext.getDataSource() instanceof DBSObjectContainer && this.executionContext.getDataSource().getSQLDialect() instanceof BasicSQLDialect) {
            return new SQLQueryDataSourceContext(this.dialect, this.executionContext);
        }
        HashSet<String> allColumnNames = new HashSet<String>();
        HashSet<List<String>> allTableNames = new HashSet<List<String>>();
        this.traverseForIdentifiers(root, (e, c) -> {
            boolean bl = allColumnNames.add(c.getName());
        }, e -> {
            boolean bl = allTableNames.add(e.toListOfStrings());
        }, true);
        this.symbolEntries.clear();
        return new SQLQueryDummyDataSourceContext(this.dialect, allColumnNames, allTableNames);
    }

    @NotNull
    public SQLQueryRowsSourceModel collectQueryExpression(@NotNull STMTreeNode tree) {
        SQLQueryExpressionMapper queryExpressionMapper = new SQLQueryExpressionMapper(this);
        return (SQLQueryRowsSourceModel)queryExpressionMapper.translate(tree);
    }

    @NotNull
    public List<SQLQuerySymbolEntry> collectColumnNameList(@NotNull STMTreeNode node) {
        if (!node.getNodeName().equals(STMKnownRuleNames.columnNameList)) {
            if (!columnNameListWrapperNames.contains(node.getNodeName())) {
                throw new UnsupportedOperationException("columnNameList (or its wrapper) expected while facing with " + node.getNodeName());
            }
            List actual = STMUtils.expandSubtree((STMTreeNode)node, columnNameListWrapperNames, Set.of(STMKnownRuleNames.columnNameList));
            switch (actual.size()) {
                case 0: {
                    return Collections.emptyList();
                }
                case 1: {
                    node = (STMTreeNode)actual.get(0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Ambiguous columnNameList collection at " + node.getNodeName());
                }
            }
        }
        ArrayList<SQLQuerySymbolEntry> result = new ArrayList<SQLQuerySymbolEntry>(node.getChildCount());
        int i = 0;
        while (i < node.getChildCount()) {
            result.add(this.collectIdentifier(node.getStmChild(i)));
            i += 2;
        }
        return result;
    }

    @NotNull
    public SQLQuerySymbolEntry collectIdentifier(@NotNull STMTreeNode node) {
        return this.collectIdentifier(node, false);
    }

    @NotNull
    private SQLQuerySymbolEntry collectIdentifier(@NotNull STMTreeNode node, boolean forceUnquotted) {
        Token t;
        STMTreeNode actual;
        STMTreeNode sTMTreeNode = actual = identifierDirectWrapperNames.contains(node.getNodeName()) ? node.getFirstStmChild() : node;
        if (!actual.getNodeName().equals(STMKnownRuleNames.identifier)) {
            throw new UnsupportedOperationException("identifier expected while facing with " + node.getNodeName());
        }
        STMTreeNode actualIdentifier = actual.findChildOfName(STMKnownRuleNames.actualIdentifier);
        if (actualIdentifier == null) {
            SQLQuerySymbolEntry entry = this.registerSymbolEntry(actual, actual.getTextContent(), actual.getTextContent());
            entry.getSymbol().setSymbolClass(SQLQuerySymbolClass.ERROR);
            return entry;
        }
        STMTreeNode actualBody = actualIdentifier.getFirstStmChild();
        String rawIdentifierString = actualBody.getTextContent();
        Object object = actualBody.getPayload();
        if (object instanceof Token && (t = (Token)object).getType() == 207) {
            SQLQuerySymbolEntry entry = this.registerSymbolEntry(actualBody, rawIdentifierString, rawIdentifierString);
            return entry;
        }
        if (this.reservedWords.contains(rawIdentifierString.toUpperCase())) {
            SQLQuerySymbolEntry entry = this.registerSymbolEntry(actualBody, rawIdentifierString, rawIdentifierString);
            entry.getSymbol().setSymbolClass(SQLQuerySymbolClass.RESERVED);
            return entry;
        }
        String actualIdentifierString = SQLUtils.identifierToCanonicalForm((SQLDialect)this.dialect, (String)rawIdentifierString, (boolean)forceUnquotted, (boolean)false);
        return this.registerSymbolEntry(actualBody, actualIdentifierString, rawIdentifierString);
    }

    @NotNull
    private SQLQuerySymbolEntry registerSymbolEntry(@NotNull STMTreeNode syntaxNode, @NotNull String name, @NotNull String rawName) {
        SQLQuerySymbolEntry entry = new SQLQuerySymbolEntry(syntaxNode, name, rawName);
        this.symbolEntries.add(entry);
        this.registerScopeItem(entry);
        return entry;
    }

    @NotNull
    public SQLQueryRowsTableDataModel collectTableReference(@NotNull STMTreeNode node) {
        return new SQLQueryRowsTableDataModel(node, this.collectTableName(node));
    }

    @Nullable
    public SQLQueryQualifiedName collectTableName(@NotNull STMTreeNode node) {
        return this.collectTableName(node, false);
    }

    @Nullable
    private SQLQueryQualifiedName collectTableName(@NotNull STMTreeNode node, boolean forceUnquotted) {
        List actual = STMUtils.expandSubtree((STMTreeNode)node, tableNameContainers, actualTableNameContainers);
        return switch (actual.size()) {
            case 0 -> null;
            case 1 -> {
                node = (STMTreeNode)actual.get(0);
                if (node.getNodeName().equals(STMKnownRuleNames.tableName)) {
                    yield this.collectQualifiedName(node, forceUnquotted);
                }
                yield this.registerScopeItem(new SQLQueryQualifiedName(node, this.collectIdentifier(node, forceUnquotted)));
            }
            default -> throw new UnsupportedOperationException("Ambiguous tableName collection at " + node.getNodeName());
        };
    }

    public SQLQueryQualifiedName collectQualifiedName(@NotNull STMTreeNode node) {
        return this.collectQualifiedName(node, false);
    }

    @NotNull
    private SQLQueryQualifiedName collectQualifiedName(@NotNull STMTreeNode node, boolean forceUnquotted) {
        STMTreeNode entityNameNode;
        STMTreeNode sTMTreeNode = entityNameNode = qualifiedNameDirectWrapperNames.contains(node.getNodeName()) ? node.getFirstStmChild() : node;
        if (!entityNameNode.getNodeName().equals(STMKnownRuleNames.qualifiedName)) {
            throw new UnsupportedOperationException("identifier expected while facing with " + node.getNodeName());
        }
        SQLQuerySymbolEntry entityName = this.collectIdentifier(entityNameNode.getLastStmtChild(), forceUnquotted);
        if (entityNameNode.getChildCount() == 1) {
            return this.registerScopeItem(new SQLQueryQualifiedName(entityNameNode, entityName));
        }
        STMTreeNode schemaNameNode = entityNameNode.getFirstStmChild();
        SQLQuerySymbolEntry schemaName = this.collectIdentifier(schemaNameNode.getLastStmtChild(), forceUnquotted);
        if (schemaNameNode.getChildCount() == 1) {
            return this.registerScopeItem(new SQLQueryQualifiedName(entityNameNode, schemaName, entityName));
        }
        STMTreeNode catalogNameNode = schemaNameNode.getFirstStmChild();
        SQLQuerySymbolEntry catalogName = this.collectIdentifier(catalogNameNode.getLastStmtChild(), forceUnquotted);
        return this.registerScopeItem(new SQLQueryQualifiedName(entityNameNode, catalogName, schemaName, entityName));
    }

    @NotNull
    public SQLQueryValueExpression collectValueExpression(@NotNull STMTreeNode node) {
        if (!knownValueExpressionRootNames.contains(node.getNodeName())) {
            throw new UnsupportedOperationException("Search condition or value expression expected while facing with " + node.getNodeName());
        }
        if (knownRecognizableValueExpressionNames.contains(node.getNodeName())) {
            return this.collectKnownValueExpression(node);
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (LexicalScopeHolder sh = this.openScope();){
            Stack<STMTreeNode> stack = new Stack<STMTreeNode>();
            Stack childLists = new Stack();
            stack.add(node);
            childLists.push(new ArrayList(1));
            while (!stack.isEmpty()) {
                SQLQueryValueFlattenedExpression c;
                Object e;
                STMTreeNode n = (STMTreeNode)stack.pop();
                if (n != null) {
                    STMTreeNode rn = n;
                    while (rn.getChildCount() == 1 && !knownRecognizableValueExpressionNames.contains(rn.getNodeName())) {
                        rn = rn.getFirstStmChild();
                    }
                    if (knownRecognizableValueExpressionNames.contains(rn.getNodeName()) || rn.getNodeName().equals(STMKnownRuleNames.valueExpressionPrimary)) {
                        ((List)childLists.peek()).add(this.collectKnownValueExpression(rn));
                        continue;
                    }
                    stack.push(n);
                    stack.push(null);
                    childLists.push(new ArrayList(rn.getChildCount()));
                    int i = rn.getChildCount() - 1;
                    while (i >= 0) {
                        stack.push(rn.getStmChild(i));
                        --i;
                    }
                    continue;
                }
                STMTreeNode content = (STMTreeNode)stack.pop();
                List children = (List)childLists.pop();
                if (children.isEmpty()) continue;
                SQLQueryValueFlattenedExpression e2 = children.size() == 1 && (e = children.get(0)) instanceof SQLQueryValueFlattenedExpression ? (c = (SQLQueryValueFlattenedExpression)e) : new SQLQueryValueFlattenedExpression(content, children);
                ((List)childLists.peek()).add(e2);
            }
            List roots = (List)childLists.pop();
            SQLQueryValueExpression result = roots.isEmpty() ? new SQLQueryValueFlattenedExpression(node, Collections.emptyList()) : (SQLQueryValueExpression)roots.get(0);
            result.registerLexicalScope(sh.lexicalScope);
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    public SQLQueryValueExpression collectKnownValueExpression(@NotNull STMTreeNode node) {
        return switch (node.getNodeKindId()) {
            case 102 -> new SQLQueryValueSubqueryExpression(node, this.collectQueryExpression(node));
            case 89 -> this.collectValueReferenceExpression(node);
            case 169 -> {
                SQLQueryValueExpression subexpr = this.collectValueExpression(node.getFirstStmChild());
                STMTreeNode castSpecNode = node.findChildOfName(STMKnownRuleNames.valueExpressionCastSpec);
                if (castSpecNode != null) {
                    String typeName = castSpecNode.getStmChild(1).getTextContent();
                    yield new SQLQueryValueTypeCastExpression(node, subexpr, typeName);
                }
                yield subexpr;
            }
            case 173 -> {
                STMTreeNode varExprNode = node.getFirstStmChild();
                if (varExprNode instanceof STMTreeTermNode) {
                    STMTreeTermNode varExprTermNode = (STMTreeTermNode)varExprNode;
                    String rawName = varExprTermNode.getTextContent();
                    switch (rawName.charAt(0)) {
                        case '@': {
                            yield new SQLQueryValueVariableExpression(node, this.registerSymbolEntry(node, rawName.substring(1), rawName), SQLQueryValueVariableExpression.VariableExpressionKind.BATCH_VARIABLE, rawName);
                        }
                        case '$': {
                            yield new SQLQueryValueVariableExpression(node, this.registerSymbolEntry(node, rawName.substring(2, rawName.length() - 1), rawName), SQLQueryValueVariableExpression.VariableExpressionKind.CLIENT_VARIABLE, rawName);
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported term variable expression: " + node.getTextContent());
                }
                switch (varExprNode.getNodeKindId()) {
                    case 174: {
                        yield new SQLQueryValueVariableExpression(node, this.registerSymbolEntry(node, varExprNode.getStmChild(1).getTextContent(), varExprNode.getTextContent()), SQLQueryValueVariableExpression.VariableExpressionKind.CLIENT_PARAMETER, varExprNode.getTextContent());
                    }
                    case 175: {
                        String mark = varExprNode.getFirstStmChild().getTextContent();
                        this.registerSymbolEntry(node, mark, mark);
                        yield new SQLQueryValueVariableExpression(node, null, SQLQueryValueVariableExpression.VariableExpressionKind.CLIENT_PARAMETER, varExprNode.getTextContent());
                    }
                }
                throw new UnsupportedOperationException("Unsupported variable expression: " + node.getTextContent());
            }
            case 205 -> this.makeValueConstantExpression(node, SQLQueryExprType.NUMERIC);
            case 70 -> this.makeValueConstantExpression(node, SQLQueryExprType.BOOLEAN);
            case 6 -> this.makeValueConstantExpression(node, SQLQueryExprType.NUMERIC);
            case 7 -> this.makeValueConstantExpression(node, SQLQueryExprType.NUMERIC);
            case 8 -> this.makeValueConstantExpression(node, SQLQueryExprType.STRING);
            case 10 -> this.makeValueConstantExpression(node, SQLQueryExprType.DATETIME);
            default -> throw new UnsupportedOperationException("Unknown expression kind " + node.getNodeName());
        };
    }

    @NotNull
    private SQLQueryValueExpression makeValueConstantExpression(@NotNull STMTreeNode node, @NotNull SQLQueryExprType type) {
        return new SQLQueryValueConstantExpression(node, node.getTextContent(), type);
    }

    @NotNull
    private SQLQueryValueExpression collectValueReferenceExpression(@NotNull STMTreeNode node) {
        STMTreeNode head = node.getFirstStmChild();
        SQLQueryValueExpression expr = switch (head.getNodeKindId()) {
            case 88 -> {
                SQLQueryQualifiedName tableName = this.collectTableName(head.getFirstStmChild());
                STMTreeNode nameNode = head.findChildOfName(STMKnownRuleNames.columnName);
                if (nameNode != null) {
                    SQLQuerySymbolEntry columnName = this.collectIdentifier(nameNode);
                    if (head.getChildCount() == 1) {
                        yield new SQLQueryValueColumnReferenceExpression(head, columnName);
                    }
                    yield new SQLQueryValueColumnReferenceExpression(head, tableName, columnName);
                }
                yield new SQLQueryValueTupleReferenceExpression(head, tableName);
            }
            case 90 -> this.collectValueReferenceExpression(head.getStmChild(1));
            default -> throw new UnsupportedOperationException("Value reference expression expected while facing with " + head.getNodeName());
        };
        int rangeStart = node.getRealInterval().a;
        boolean[] slicingFlags = new boolean[node.getChildCount()];
        int i = 1;
        while (i < node.getChildCount()) {
            STMTreeNode step = node.getStmChild(i);
            Interval range = new Interval(rangeStart, step.getRealInterval().b);
            expr = switch (step.getNodeKindId()) {
                case 91 -> {
                    int s = i;
                    while (i < node.getChildCount() && step.getNodeKindId() == 91) {
                        step = node.getStmChild(i);
                        slicingFlags[i] = step.getStmChild(1).getNodeKindId() == 93;
                        ++i;
                    }
                    boolean[] slicingSpec = Arrays.copyOfRange(slicingFlags, s, i);
                    yield new SQLQueryValueIndexingExpression(range, node, expr, slicingSpec);
                }
                case 94 -> {
                    ++i;
                    yield new SQLQueryValueMemberExpression(range, node, expr, this.collectIdentifier(step.getStmChild(1)));
                }
                default -> throw new UnsupportedOperationException("Value member expression expected while facing with " + node.getNodeName());
            };
        }
        return expr;
    }

    @Nullable
    public static SQLQuerySymbolClass tryFallbackSymbolForStringLiteral(@NotNull SQLDialect dialect, @NotNull SQLQuerySymbolEntry symbolEntry, boolean isColumnResolved) {
        SQLQuerySymbolClass forcedClass = null;
        boolean isQuotedIdentifier = dialect.isQuotedIdentifier(symbolEntry.getRawName());
        char quoteChar = symbolEntry.getRawName().charAt(0);
        if (!isQuotedIdentifier && (quoteChar == '\"' || quoteChar == '`' || quoteChar == '\'') || isQuotedIdentifier && !isColumnResolved) {
            forcedClass = switch (quoteChar) {
                case '\'' -> SQLQuerySymbolClass.STRING;
                case '\"', '`' -> SQLQuerySymbolClass.QUOTED;
                default -> null;
            };
        }
        return forcedClass;
    }

    private SQLQueryLexicalScope beginScope() {
        SQLQueryLexicalScope scope = new SQLQueryLexicalScope();
        this.currentLexicalScopes.addLast(scope);
        return scope;
    }

    private void endScope(SQLQueryLexicalScope scope) {
        if (this.currentLexicalScopes.peekLast() != scope) {
            throw new IllegalStateException();
        }
        this.currentLexicalScopes.removeLast();
    }

    private <T extends SQLQueryLexicalScopeItem> T registerScopeItem(T item) {
        SQLQueryLexicalScope scope = this.currentLexicalScopes.peekLast();
        if (scope != null) {
            scope.registerItem(item);
        }
        return item;
    }

    public LexicalScopeHolder openScope() {
        return new LexicalScopeHolder(this.beginScope());
    }

    @Nullable
    public static SQLQueryModel recognizeQuery(@NotNull SQLQueryRecognitionContext recognitionContext, @NotNull String queryText) {
        SQLQueryModelRecognizer recognizer = new SQLQueryModelRecognizer(recognitionContext);
        return recognizer.recognizeQuery(queryText);
    }

    private static class DebugGraphBuilder {
        private final DirectedGraph graph = new DirectedGraph();
        private final LinkedList<Pair<Object, Object>> stack = new LinkedList();
        private final Set<Object> done = new HashSet<Object>();
        private final Map<Object, DirectedGraph.Node> objs = new HashMap<Object, DirectedGraph.Node>();

        private DebugGraphBuilder() {
        }

        private void expandObject(Object prev, Object o) {
            Object src;
            String propName = prev == null ? null : (String)((Pair)prev).getFirst();
            Object object = src = prev == null ? null : ((Pair)prev).getSecond();
            if (o instanceof SQLQueryDataContext || o instanceof SQLQueryRowsSourceModel || o instanceof SQLQueryValueExpression) {
                DirectedGraph.Node node = this.objs.get(o);
                DirectedGraph.Node prevNode = this.objs.get(src);
                if (node == null) {
                    String color = o instanceof SQLQueryDataContext ? "#bbbbff" : (o instanceof SQLQueryRowsSourceModel ? "#bbffbb" : (o instanceof SQLQueryValueExpression ? "#ffbbbb" : "#bbbbbb"));
                    node = this.graph.createNode(o.toString().substring(o.getClass().getPackageName().length()), color);
                    this.objs.put(o, node);
                }
                if (prevNode != null) {
                    this.graph.createEdge(prevNode, node, propName, null);
                }
                src = o;
                propName = "";
            }
            if (this.done.contains(o)) {
                return;
            }
            this.done.add(o);
            if (o instanceof String || o.getClass().isPrimitive() || o.getClass().isEnum()) {
                return;
            }
            if (o instanceof SQLQuerySymbol || o instanceof DBSObject || o instanceof DBCExecutionContext) {
                return;
            }
            if (o instanceof Iterable) {
                Iterable it = (Iterable)o;
                return;
            }
            Class<?> t = o.getClass();
            while (t != Object.class) {
                Field[] fieldArray = t.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    try {
                        Object x;
                        if ((f.canAccess(o) || f.trySetAccessible()) && (x = f.get(o)) != null) {
                            if (x instanceof String || x.getClass().isEnum()) {
                                DirectedGraph.Node prevNode = this.objs.get(src);
                                if (prevNode != null) {
                                    String text = x.toString().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;").replace("\n", "&#10;");
                                    prevNode.label = String.valueOf(prevNode.label) + "&#10;" + propName + "." + f.getName() + " = " + text;
                                }
                            } else if (x instanceof Iterable) {
                                Iterable it = (Iterable)x;
                                int index = 0;
                                for (Object y : it) {
                                    if (y == null || this.done.contains(y)) continue;
                                    this.stack.addLast((Pair<Object, Object>)new Pair((Object)new Pair((Object)(propName + "[" + index++ + "]"), src), y));
                                }
                            } else {
                                this.stack.addLast((Pair<Object, Object>)new Pair((Object)new Pair((Object)(propName + "." + f.getName()), src), x));
                            }
                        }
                    }
                    catch (Throwable throwable) {}
                    ++n2;
                }
                t = t.getSuperclass();
            }
        }

        public void traverseObjs(Object obj) {
            this.stack.addLast((Pair<Object, Object>)new Pair(null, obj));
            while (!this.stack.isEmpty()) {
                Pair<Object, Object> p = this.stack.removeLast();
                this.expandObject(p.getFirst(), p.getSecond());
            }
        }
    }

    public class LexicalScopeHolder
    implements AutoCloseable {
        public final SQLQueryLexicalScope lexicalScope;

        public LexicalScopeHolder(SQLQueryLexicalScope scope) {
            this.lexicalScope = scope;
        }

        @Override
        public void close() {
            SQLQueryModelRecognizer.this.endScope(this.lexicalScope);
        }
    }
}

