/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SQLQueryQualifiedName
extends SQLQueryLexicalScopeItem {
    @Nullable
    public final SQLQuerySymbolEntry catalogName;
    @Nullable
    public final SQLQuerySymbolEntry schemaName;
    @NotNull
    public final SQLQuerySymbolEntry entityName;

    public SQLQueryQualifiedName(@NotNull STMTreeNode syntaxNode, @NotNull SQLQuerySymbolEntry entityName) {
        this(syntaxNode, null, null, entityName);
    }

    public SQLQueryQualifiedName(@NotNull STMTreeNode syntaxNode, @Nullable SQLQuerySymbolEntry schemaName, @NotNull SQLQuerySymbolEntry entityName) {
        this(syntaxNode, null, schemaName, entityName);
    }

    public SQLQueryQualifiedName(@NotNull STMTreeNode syntaxNode, @Nullable SQLQuerySymbolEntry catalogName, @Nullable SQLQuerySymbolEntry schemaName, @NotNull SQLQuerySymbolEntry entityName) {
        super(syntaxNode);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.entityName = entityName;
    }

    @Override
    @NotNull
    public STMTreeNode[] getSyntaxComponents() {
        if (this.catalogName != null && this.schemaName != null) {
            return new STMTreeNode[]{this.catalogName.getSyntaxNode(), this.schemaName.getSyntaxNode(), this.entityName.getSyntaxNode()};
        }
        if (this.schemaName != null) {
            return new STMTreeNode[]{this.schemaName.getSyntaxNode(), this.entityName.getSyntaxNode()};
        }
        return new STMTreeNode[]{this.entityName.getSyntaxNode()};
    }

    public void setSymbolClass(@NotNull SQLQuerySymbolClass symbolClass) {
        if (this.entityName != null) {
            this.entityName.getSymbol().setSymbolClass(symbolClass);
        }
        if (this.schemaName != null) {
            this.schemaName.getSymbol().setSymbolClass(symbolClass);
        }
        if (this.catalogName != null) {
            this.catalogName.getSymbol().setSymbolClass(symbolClass);
        }
    }

    public void setDefinition(@NotNull DBSObject realTable) {
        if (this.entityName != null) {
            this.entityName.setDefinition(new SQLQuerySymbolByDbObjectDefinition(realTable, SQLQuerySymbolClass.TABLE));
            if (this.schemaName != null) {
                DBSObject schema = realTable.getParentObject();
                if (schema != null) {
                    this.schemaName.setDefinition(new SQLQuerySymbolByDbObjectDefinition(schema, SQLQuerySymbolClass.SCHEMA));
                } else {
                    this.schemaName.getSymbol().setSymbolClass(SQLQuerySymbolClass.ERROR);
                }
                if (this.catalogName != null && schema != null) {
                    DBSObject catalog = schema.getParentObject();
                    if (catalog != null) {
                        this.catalogName.setDefinition(new SQLQuerySymbolByDbObjectDefinition(catalog, SQLQuerySymbolClass.CATALOG));
                    } else {
                        this.catalogName.getSymbol().setSymbolClass(SQLQuerySymbolClass.ERROR);
                    }
                }
            }
        }
    }

    public void setDefinition(@NotNull SourceResolutionResult rr) {
        if (rr.aliasOrNull != null) {
            this.entityName.merge(rr.aliasOrNull);
        } else if (rr.source instanceof SQLQueryRowsTableDataModel) {
            SQLQueryRowsTableDataModel tableModel = (SQLQueryRowsTableDataModel)rr.source;
            if (this.entityName != null) {
                SQLQueryQualifiedName tableName = tableModel.getName();
                this.entityName.setDefinition(tableName.entityName);
                if (this.schemaName != null) {
                    SQLQuerySymbolEntry schemaDef = tableName.schemaName != null ? tableName.schemaName : tableName.entityName;
                    this.schemaName.setDefinition(schemaDef);
                    if (this.catalogName != null) {
                        SQLQuerySymbolEntry catalogDef = tableName.catalogName != null ? tableName.catalogName : schemaDef;
                        this.catalogName.setDefinition(catalogDef);
                    }
                }
            }
        }
    }

    @NotNull
    public List<String> toListOfStrings() {
        if (this.catalogName != null && this.schemaName != null) {
            return List.of(this.catalogName.getName(), this.schemaName.getName(), this.entityName.getName());
        }
        if (this.schemaName != null) {
            return List.of(this.schemaName.getName(), this.entityName.getName());
        }
        return List.of(this.entityName.getName());
    }

    @NotNull
    public String toIdentifierString() {
        if (this.catalogName != null && this.schemaName != null) {
            return String.join((CharSequence)".", this.catalogName.getRawName(), this.schemaName.getRawName(), this.entityName.getRawName());
        }
        if (this.schemaName != null) {
            return String.join((CharSequence)".", this.schemaName.getRawName(), this.entityName.getRawName());
        }
        return this.entityName.getRawName();
    }

    public String toString() {
        return String.join((CharSequence)".", this.toListOfStrings());
    }

    public int hashCode() {
        return this.toListOfStrings().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SQLQueryQualifiedName) {
            SQLQueryQualifiedName other = (SQLQueryQualifiedName)obj;
            if (this.toListOfStrings().equals(other.toListOfStrings())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNotClassified() {
        return !(!this.entityName.isNotClassified() || this.schemaName != null && !this.schemaName.isNotClassified() || this.catalogName != null && !this.catalogName.isNotClassified());
    }
}

