/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionProblemInfo;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRecognitionContext {
    @NotNull
    private final DBRProgressMonitor monitor;
    @Nullable
    private final DBCExecutionContext executionContext;
    private final boolean useRealMetadata;
    @NotNull
    private final SQLSyntaxManager syntaxManager;
    @NotNull
    private final Deque<SQLQueryRecognitionProblemInfo> problems = new LinkedList<SQLQueryRecognitionProblemInfo>();
    private boolean errorsAsWarnings = false;

    public SQLQueryRecognitionContext(@NotNull DBRProgressMonitor monitor, @Nullable DBCExecutionContext executionContext, boolean useRealMetadata, @NotNull SQLSyntaxManager syntaxManager) {
        this.monitor = monitor;
        this.executionContext = executionContext;
        this.useRealMetadata = useRealMetadata;
        this.syntaxManager = syntaxManager;
    }

    public void setTreatErrorAsWarnings(boolean errorsAsWarnings) {
        this.errorsAsWarnings = errorsAsWarnings;
    }

    public boolean isTreatErrorsAsWarnings() {
        return this.errorsAsWarnings;
    }

    @NotNull
    public DBRProgressMonitor getMonitor() {
        return this.monitor;
    }

    @Nullable
    DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    boolean useRealMetadata() {
        return this.useRealMetadata;
    }

    @NotNull
    SQLSyntaxManager getSyntaxManager() {
        return this.syntaxManager;
    }

    public List<SQLQueryRecognitionProblemInfo> getProblems() {
        return List.copyOf(this.problems);
    }

    private SQLQueryRecognitionProblemInfo makeError(@NotNull STMTreeNode syntaxNode, @Nullable SQLQuerySymbolEntry symbol, @NotNull String message, @Nullable DBException exception) {
        SQLQueryRecognitionProblemInfo.Severity severity = this.errorsAsWarnings ? SQLQueryRecognitionProblemInfo.Severity.WARNING : SQLQueryRecognitionProblemInfo.Severity.ERROR;
        return new SQLQueryRecognitionProblemInfo(severity, syntaxNode, symbol, message, exception);
    }

    private SQLQueryRecognitionProblemInfo makeWarning(@NotNull STMTreeNode syntaxNode, @Nullable SQLQuerySymbolEntry symbol, @NotNull String message, @Nullable DBException exception) {
        return new SQLQueryRecognitionProblemInfo(SQLQueryRecognitionProblemInfo.Severity.WARNING, syntaxNode, symbol, message, exception);
    }

    public void appendError(@NotNull SQLQuerySymbolEntry symbol, @NotNull String error, @NotNull DBException ex) {
        this.problems.addLast(this.makeError(symbol.getSyntaxNode(), symbol, error, ex));
    }

    public void appendError(@NotNull SQLQuerySymbolEntry symbol, @NotNull String error) {
        this.problems.addLast(this.makeError(symbol.getSyntaxNode(), symbol, error, null));
    }

    public void appendError(@NotNull STMTreeNode treeNode, @NotNull String error) {
        this.problems.addLast(this.makeError(treeNode, null, error, null));
    }

    public void appendWarning(@NotNull SQLQuerySymbolEntry symbol, @NotNull String error) {
        this.problems.addLast(this.makeWarning(symbol.getSyntaxNode(), symbol, error, null));
    }

    public void appendWarning(@NotNull STMTreeNode treeNode, @NotNull String error) {
        this.problems.addLast(this.makeWarning(treeNode, null, error, null));
    }

    public void reset() {
        this.problems.clear();
    }
}

